/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.sendheadearly;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.HTTP})
@LoginAs(user="admin")
public class TestCommittedResponseHtmlErrorRecovery
extends BaseJiraFuncTest {
    private static final String OPENING_HTML_TAG = "<html";
    private static final String CLOSING_HTML_TAG = "</html>";
    private static final String MAGIC_JAVASCRIPT_MARKER = "'\"-->>]]>";
    private static final String POST_FLUSH_CONTENT = "POST_FLUSH_CONTENT";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.login("admin", "admin");
    }

    @After
    public void tearDownTest() {
        this.navigation.logout();
    }

    @Test
    public void testWithFlushAndContent() {
        this.tester.gotoPage("/CommittedResponseExceptionThrowingAction.jspa");
        String response = this.tester.getDialog().getResponseText();
        Assert.assertNotNull((String)"Expected a response", (Object)response);
        Assert.assertThat((String)"Expected to see an opening HTML tag in the response", (Object)response, (Matcher)JUnitMatchers.containsString((String)OPENING_HTML_TAG));
        Assert.assertThat((String)"Expected to NOT see a closing HTML tag in the response", (Object)response, (Matcher)Matchers.not((Matcher)JUnitMatchers.containsString((String)CLOSING_HTML_TAG)));
        Assert.assertThat((String)"Expected to see magic javascript injected in the response", (Object)response, (Matcher)JUnitMatchers.containsString((String)MAGIC_JAVASCRIPT_MARKER));
        Assert.assertThat((String)"Expected to NOT to see any post-flush content in the response", (Object)response, (Matcher)Matchers.not((Matcher)JUnitMatchers.containsString((String)POST_FLUSH_CONTENT)));
    }
}

