/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.statistics;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.restclient.Component;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestComponentStatisticsManager
extends BaseJiraRestTest {
    public static final String HSP_PROJECT = "HSP";
    public static final String MKY_PROJECT = "MKY";
    @Inject
    private Backdoor backdoor;

    @Before
    public void setUpTest() {
        this.backdoor.restoreDataFromResource("blankprojects.xml");
        Component component1 = new Component();
        component1.name("Component 1");
        component1.description("Component 1");
        component1.project(HSP_PROJECT);
        component1 = this.backdoor.components().create(component1);
        Component component2 = new Component();
        component2.name("Component 2");
        component2.description("Component 2");
        component2.project(HSP_PROJECT);
        component2 = this.backdoor.components().create(component2);
        Component component3 = new Component();
        component3.name("Component 3");
        component3.description("Component 3");
        component3.project(MKY_PROJECT);
        component3 = this.backdoor.components().create(component3);
        this.createIssue("Issue 1", component1);
        this.createIssue("Issue 2", component1);
        this.createIssue("Issue 3", component1);
        this.createIssue("Issue 4", component2);
        this.createIssue("Issue 5", HSP_PROJECT);
        this.createIssue("Issue 6", component3);
        this.createIssue("Issue 7", component3);
    }

    private String createIssue(String description, String projectKey) {
        return this.backdoor.issues().createIssue((String)projectKey, (String)description).key;
    }

    private String createIssue(String description, Component component) {
        String key = this.createIssue(description, component.project);
        IssueFields fields = new IssueFields();
        fields.components(new ResourceRef[]{ResourceRef.withId((String)component.id.toString())});
        this.backdoor.issues().setIssueFields(key, fields);
        return key;
    }

    @Test
    public void testCorrectProjectsAndComponents() {
        Map<String, Map<String, Integer>> result = this.backdoor.statisticsControl().getComponentsResultingFrom("");
        Assert.assertThat((String)"Both projects were returned", result.keySet(), (Matcher)Matchers.contains((Object[])new String[]{HSP_PROJECT, MKY_PROJECT}));
        Assert.assertThat((String)"Only expected components were returned", (Object)result.get(HSP_PROJECT).size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((String)"Only expected components were returned", (Object)result.get(MKY_PROJECT).size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 1"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 2"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 3"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Non empty components are present", (Object)result.get(HSP_PROJECT).get("Component 1"), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Non empty components are present", (Object)result.get(HSP_PROJECT).get("Component 2"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Non empty components are present", (Object)result.get(MKY_PROJECT).get("Component 3"), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testCorrectProjectsAndComponentsWithQuery() {
        Map<String, Map<String, Integer>> result = this.backdoor.statisticsControl().getComponentsResultingFrom("project = HSP");
        Assert.assertThat((String)"HSP project was returned", result.keySet(), (Matcher)Matchers.contains((Object[])new String[]{HSP_PROJECT}));
        Assert.assertThat((String)"Only expected components were returned", (Object)result.get(HSP_PROJECT).size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 1"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 2"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Empty components are present", (Object)result.get(HSP_PROJECT).get("New Component 3"), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"Non empty components are present", (Object)result.get(HSP_PROJECT).get("Component 1"), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Non empty components are present", (Object)result.get(HSP_PROJECT).get("Component 2"), (Matcher)Matchers.is((Object)1));
    }
}

