/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.subtask.SubTaskAssertions;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestIssueToSubtaskConversionSystemFields.xml")
public class TestIssueToSubTaskConversionSystemFields
extends BaseJiraFuncTest {
    private static final String ISSUE_MKY_1 = "MKY-1";
    private static final String PARENT_ISSUE_MKY_3 = "MKY-3";
    private static final String ISSUE_HSP_1 = "HSP-1";
    private static final String PARENT_ISSUE_HSP_2 = "HSP-2";
    private static final String ISSUE_GOD_1 = "GOD-1";
    private static final String PARENT_ISSUE_GOD_2 = "GOD-2";
    @Inject
    SubTaskAssertions subTaskAssertions;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testConvertHiddenAndSomeShownScenarios() {
        this.navigation.issue().gotoIssue(ISSUE_MKY_1);
        this.tester.clickLink("issue-to-subtask");
        this.tester.assertTextPresent("Step 1 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 1);
        this.tester.assertTextPresent("Convert Issue to Sub-task: MKY-1");
        this.tester.setFormElement("parentIssueKey", PARENT_ISSUE_MKY_3);
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Step 2 of 4");
        this.tester.assertTextPresent("Step 3 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 3);
        this.tester.assertTextPresent("Component/s:");
        this.tester.assertTextPresent("Environment:");
        this.tester.assertTextNotPresent("Affects:");
        this.tester.assertTextNotPresent("Assignee:");
        this.tester.assertTextNotPresent("Description:");
        this.tester.assertTextNotPresent("Due Date:");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 3);
        this.tester.assertTextPresent("Component/s is required");
        this.tester.selectOption("components", "Component1");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 4 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 4);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        Assert.assertEquals((String)"number of rows", (long)5L, (long)table.getRowCount());
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 0, "Type");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Bug");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 2, "Sub-task");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 0, "Component/s");
        this.assertions.getTableAssertions().assertTableCellHasNoText(table, 2, 1, "Component1");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 2, "Component1");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 0, "Environment");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "A test value");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 2, "A test value");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 0, "Description");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 1, "A test value");
        this.assertions.getTableAssertions().assertTableCellHasNoText(table, 4, 2, "A test value");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "MKY-3 A third monkey issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), ISSUE_MKY_1);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A monkey bug");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    @Test
    public void testShownAndSomeRequiredScenarios() {
        this.navigation.issue().gotoIssue(ISSUE_HSP_1);
        this.tester.clickLink("issue-to-subtask");
        this.tester.assertTextPresent("Step 1 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 1);
        this.tester.assertTextPresent("Convert Issue to Sub-task: HSP-1");
        this.tester.setFormElement("parentIssueKey", PARENT_ISSUE_HSP_2);
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Step 2 of 4");
        this.tester.assertTextPresent("Step 3 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 3);
        this.tester.assertTextPresent("Component/s:");
        this.tester.assertTextPresent("Environment:");
        this.tester.assertTextPresent("Description:");
        this.tester.assertTextNotPresent("Affects:");
        this.tester.assertTextNotPresent("Due Date:");
        this.tester.assertTextNotPresent("Priority:");
        this.tester.assertTextNotPresent("Summary:");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 3);
        this.tester.assertTextPresent("Component/s is required");
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 4 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 4);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        Assert.assertEquals((String)"number of rows", (long)6L, (long)table.getRowCount());
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 0, "Type");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Bug");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 2, "Sub-task");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 0, "Component/s");
        this.assertions.getTableAssertions().assertTableCellHasNoText(table, 2, 1, "New Component 1");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 2, "New Component 1");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 0, "Description");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "A test desc");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 2, "A test desc");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 0, "Environment");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 1, "A test env");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 2, "A test env");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 5, 0, "Fix Version/s");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 5, 1, "New Version 1");
        this.assertions.getTableAssertions().assertTableCellHasNoText(table, 5, 2, "New Version 1");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), ISSUE_HSP_1);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A new issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    @Test
    public void testSomeMoreShownAndSomeRequiredScenarios() {
        this.navigation.issue().gotoIssue(ISSUE_GOD_1);
        this.tester.clickLink("issue-to-subtask");
        this.tester.assertTextPresent("Step 1 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 1);
        this.tester.assertTextPresent("Convert Issue to Sub-task: GOD-1");
        this.tester.setFormElement("parentIssueKey", PARENT_ISSUE_GOD_2);
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Step 2 of 4");
        this.tester.assertTextPresent("Step 3 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 3);
        this.tester.assertTextPresent("Description:");
        this.tester.assertTextNotPresent("Component/s:");
        this.tester.assertTextNotPresent("Environment:");
        this.tester.assertTextNotPresent("Affects:");
        this.tester.assertTextNotPresent("Due Date:");
        this.tester.assertTextNotPresent("Priority:");
        this.tester.assertTextNotPresent("Summary:");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 4 of 4");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 4);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        Assert.assertEquals((String)"number of rows", (long)3L, (long)table.getRowCount());
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 0, "Type");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Bug");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 2, "Sub-task");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 0, "Description");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "A test desc");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 2, "A test desc");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "GOD-2 The overlord");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), ISSUE_GOD_1);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A new issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }
}

