/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.subtask.SubTaskAssertions;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestIssueToSubtaskConversionVariousOperations.xml")
@DevMode(enabled=false)
public class TestIssueToSubTaskConversionVariousOperations
extends BaseJiraFuncTest {
    @Inject
    SubTaskAssertions subTaskAssertions;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAddNewSubtaskToExistingIssueWithSubtask() {
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertTextPresent("Sub-Tasks");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1.", "My sub-task summary");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2.", "Second subtask");
        this.tester.assertTextNotPresent("A new issue");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
        this.navigation.issue().gotoIssue("HSP-2");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1.", "My sub-task summary");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2.", "Second subtask");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "3.", "A new issue");
        this.tester.clickLink("stqc_show");
        this.tester.submit("Create");
        this.tester.setFormElement("summary", "The new manually added subtask");
        this.tester.setFormElement("description", "A test Desc");
        this.tester.selectOption("components", "New Component 1");
        this.tester.selectOption("versions", "New Version 1");
        this.tester.submit("Create");
        this.navigation.issue().gotoIssue("HSP-2");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1.", "My sub-task summary");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2.", "Second subtask");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "3.", "A new issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "4.", "The new manually added subtask");
    }

    @Test
    public void testCancelFirstStep() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("A new issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Bug");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A new issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    @Test
    public void testCancelThirdStep() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("issue-to-subtask");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("HSP-1", 1);
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("HSP-1", 3);
        this.tester.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("A new issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Bug");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A new issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    @Test
    public void testCancelLastStep() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("issue-to-subtask");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("HSP-1", 1);
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("HSP-1", 3);
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("HSP-1", 4);
        this.tester.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("A new issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Bug");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-2");
        this.tester.submit("Next >>");
        this.tester.selectOption("components", "New Component 1");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content header h2"), "A new issue");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    @Test
    public void testConversionWithoutBrowsePermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("/secure/ConvertIssue.jspa?id=10080");
        this.tester.setFormElement("parentIssueKey", "CAT-3");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
        this.tester.assertTextPresent("You have successfully converted the issue (CAT-1), however you do not have the permission to view the converted issue");
    }

    @Test
    public void testConversionWithHiddenField() {
        this.backdoor.license().replace(LicenseKeys.COMMERCIAL);
        this.navigation.issue().gotoIssue("CAT-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("environment", "Test environment");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLinkWithText("Default Field Configuration");
        this.tester.clickLink("hide_9");
        this.navigation.issue().gotoIssue("CAT-1");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "CAT-2");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps("CAT-1", 4);
        this.tester.assertTextPresent("Environment");
    }
}

