/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.MimeMessageMatchers;
import com.atlassian.jira.functest.rule.MailTest;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
@MailTest
@Restore(value="TestIssueToSubtaskConversionNotifications.xml")
public class TestIssueToSubtaskConversionNotifications
extends BaseJiraEmailTest {
    private static final String ISSUE_TO_CONVERT_ID = "10001";
    private static final String PARENT_ISSUE = "TEST-1";
    private static final String SUBTASK_TYPE_ID = "5";
    public static final String EMAIL_ADDRESS = "admin@example.com";

    @Test
    public void testEmailIsSentWhenIssueIsConvertedToSubtask() throws Exception {
        this.convertIssueToSubtask(ISSUE_TO_CONVERT_ID);
        this.assertOneEmailWasSent(EMAIL_ADDRESS, "updated", "an issue", "Change By:", "Parent:", PARENT_ISSUE, "TEST-2", "Bug", "Sub-task", "Add Comment", "ViewProfile.jspa?name=admin", "This message was sent by Atlassian Jira");
    }

    public void convertIssueToSubtask(String issueId) {
        this.tester.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + PARENT_ISSUE + "&issuetype=" + SUBTASK_TYPE_ID);
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
    }

    private void assertOneEmailWasSent(String emailAddress, String ... expectedTexts) throws Exception {
        Collection<MimeMessage> emails = this.mailHelper.flushMailQueueAndWait(1);
        MimeMessage email = emails.iterator().next();
        for (String expectedText : expectedTexts) {
            MatcherAssert.assertThat((Object)email, (Matcher)Matchers.allOf(MimeMessageMatchers.withRecipientEqualTo(emailAddress), MimeMessageMatchers.containsString(expectedText)));
        }
    }
}

