/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestSubTaskActions
extends BaseJiraFuncTest {
    public static final String ADD_SUBTASK_LINK = "add-subtask-type";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testRedirectedTryingToAddSubtaskButDisabled() {
        this.backdoor.subtask().disable();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.assertLinkNotPresent(ADD_SUBTASK_LINK);
        this.tester.gotoPage("/secure/admin/subtasks/AddNewSubTaskIssueType.jspa");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/admin/subtasks/ManageSubTasks.jspa");
    }

    @Test
    public void testSubTaskActions() {
        this.administration.restoreBlankInstance();
        this.subTasksCreateSubTaskType();
        this.subTasksDeleteSubTaskType();
        this.subTaskCreateDuplicateSubTaskType();
        this.subTaskCreateInvalidSubTaskType();
    }

    @Test
    public void testSubTaskOperationsHaveTheRightIssueHeader() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.attachments().enable();
        this.administration.subtasks().enable();
        this.administration.subtasks().addSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.textAssertions.assertTextPresent(this.locator.page(), "Sub-Tasks");
        this.textAssertions.assertTextPresent(this.locator.page(), "Custom Sub Task");
        String summary = "Parent Summary";
        String childSummary = "Child Summary";
        String parentIssueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Parent Summary");
        String childIssueKey = this.navigation.issue().createSubTask(parentIssueKey, "Custom Sub Task", "Child Summary", "Sub Task Desc");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.tester.clickLink("attach-file");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.tester.clickLink("clone-issue");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.tester.clickLink("delete-issue");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.tester.clickLink("view-voters");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.tester.clickLink("manage-watchers");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.navigation.issue().gotoIssue(childIssueKey);
        this.tester.clickLink("log-work");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
    }

    private void assertSubTaskIssueHeader(String parentIssueKey, String childIssueKey, String parentSummary, String childSummary) {
        this.textAssertions.assertTextSequence(this.locator.page(), "homosapien", parentIssueKey, parentSummary, childIssueKey, childSummary);
    }

    private void subTasksCreateSubTaskType() {
        this.logger.log((Object)"Sub Task Action: Tests the ability to create a sub task type");
        this.administration.subtasks().addSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.administration.subtasks().enable();
        this.textAssertions.assertTextPresent(this.locator.page(), "Sub-Tasks");
        this.textAssertions.assertTextPresent(this.locator.page(), "Custom Sub Task");
        this.administration.subtasks().disable();
    }

    private void subTasksDeleteSubTaskType() {
        this.logger.log((Object)"Sub Task Action: Tests the ability to create a sub task type");
        this.administration.subtasks().enable();
        this.administration.subtasks().deleteSubTaskType("Custom Sub Task");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.textAssertions.assertTextPresent(this.locator.page(), "Sub-Tasks");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Custom Sub Task");
        this.administration.subtasks().addSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.administration.subtasks().disable();
    }

    private void subTaskCreateDuplicateSubTaskType() {
        this.logger.log((Object)"Sub Task Action: Ensures two sub task types cannot be given the same name");
        this.administration.subtasks().enable();
        this.gotoAddSubtask();
        this.tester.setFormElement("name", "Custom Sub Task");
        this.tester.setFormElement("description", "Custom Sub Task");
        this.tester.submit("Add");
        this.textAssertions.assertTextPresent(this.locator.page(), "This name is already taken.");
        this.administration.subtasks().disable();
    }

    private void subTaskCreateInvalidSubTaskType() {
        this.logger.log((Object)"Sub Task Action: Ensures a sub task types cannot be given no name");
        this.administration.subtasks().enable();
        this.gotoAddSubtask();
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("description", "Custom Sub Task");
        this.tester.submit("Add");
        this.textAssertions.assertTextPresent(this.locator.page(), "You must specify a name for this new sub-task issue type.");
        this.administration.subtasks().disable();
    }

    private void gotoAddSubtask() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink(ADD_SUBTASK_LINK);
    }
}

