/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestSubTaskToIssueConversionSecurityLevel
extends BaseJiraFuncTest {
    private static final String SUB_SL_REQ_NO_VAL = "HSP-8";
    private static final String PARENT_NO_VAL = "HSP-7";
    private static final String SUB_SL_REQ_HAS_VAL = "HSP-6";
    private static final String SUB_SL_HIDDEN = "HSP-9";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestSubTaskToIssueConversionSecurityLevel.xml");
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelNoValToOptional() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextNotPresent(PARENT_NO_VAL);
        this.tester.clickLinkWithText("History");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", PARENT_NO_VAL});
        this.navigation.issue().gotoIssue(PARENT_NO_VAL);
        this.tester.assertTableNotPresent(SUB_SL_REQ_NO_VAL);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_NO_VAL);
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelNoValToHidden() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_NO_VAL);
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelNoValToRequired() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Security Level");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.tester.selectOption("security", "Developers");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "None", "Developers"});
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelValToOptional() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelValToHidden() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.tester.assertTextPresent(SUB_SL_REQ_HAS_VAL);
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelHiddenToOptional() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextPresent(SUB_SL_HIDDEN);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextNotPresent("Security Level");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextPresent(SUB_SL_HIDDEN);
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelHiddenToHidden() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextPresent(SUB_SL_HIDDEN);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextNotPresent("Security Level");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextPresent(SUB_SL_HIDDEN);
    }

    @Test
    public void testSubTaskToIssueConversionSecurityLevelHiddenToRequired() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextPresent(SUB_SL_HIDDEN);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.tester.assertTextNotPresent("Security Level");
        this.tester.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Security Level");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.tester.selectOption("security", "Developers");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "None", "Developers"});
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Developers"});
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUB_SL_HIDDEN);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }
}

