/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestSubTaskToIssueConversion.xml")
public class TestSubTaskToIssueConversionStep1
extends BaseJiraFuncTest {
    private static final String BUG_KEY = "HSP-1";
    private static final String BUG_ID = "10000";
    private static final String SUBTASK_KEY = "HSP-3";
    private static final String SUBTASK_ID = "10002";
    private static final String SUBTASK_KEY_NO_FEATURES_IN_SCHEME = "MKY-2";
    private static final String SUBTASK_ID_NO_FEATURES_IN_SCHEME = "10021";
    private static final String FEATURE_KEY = "HSP-4";
    private static final String FEATURE_ID = "10010";
    private static final String TASK_KEY = "HSP-5";
    private static final String IMPROVEMENT_KEY = "HSP-6";
    private static final String INVALID_ISSUE_ID = "9999";
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testSubTaskToIssueConversionEditPermission() {
        this.navigation.issue().gotoIssue(SUBTASK_KEY);
        this.tester.assertLinkPresent("subtask-to-issue");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(SUBTASK_KEY);
        this.tester.assertLinkNotPresent("subtask-to-issue");
        this.gotoConvertSubTask(SUBTASK_ID);
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.navigation.logout();
        this.gotoConvertSubTask(SUBTASK_ID);
        this.tester.assertTextPresent("You must log in to access this page.");
    }

    @Test
    public void testSubTaskToIssueConversionCheckIssueType() {
        this.navigation.issue().gotoIssue(SUBTASK_KEY);
        this.tester.assertLinkPresent("subtask-to-issue");
        this.navigation.issue().gotoIssue(BUG_KEY);
        this.tester.assertLinkNotPresent("subtask-to-issue");
        this.navigation.issue().gotoIssue(FEATURE_KEY);
        this.tester.assertLinkNotPresent("subtask-to-issue");
        this.navigation.issue().gotoIssue(TASK_KEY);
        this.tester.assertLinkNotPresent("subtask-to-issue");
        this.navigation.issue().gotoIssue(IMPROVEMENT_KEY);
        this.tester.assertLinkNotPresent("subtask-to-issue");
        this.gotoConvertSubTask(FEATURE_ID);
        this.tester.assertTextPresent("Issue HSP-4 is not a sub-task");
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Return to", FEATURE_KEY);
        this.tester.assertLinkPresentWithText(FEATURE_KEY);
        this.gotoConvertSubTask(SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
    }

    @Test
    public void testIssueToSubTaskConversionInvalidIssue() {
        this.gotoConvertSubTask(SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.gotoConvertSubTask(INVALID_ISSUE_ID);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Issue not found");
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Return to", "Dashboard");
        this.tester.assertLinkPresentWithText("Dashboard");
    }

    @Test
    public void testIssueToSubTaskConversionIssueType() {
        this.gotoConvertSubTask(SUBTASK_ID);
        this.tester.assertOptionsEqual("issuetype", new String[]{"Bug", "New Feature", "Task", "Improvement"});
        this.tester.assertRadioOptionValueNotPresent("issuetype", "Sub-task");
        this.gotoConvertSubTask(SUBTASK_ID_NO_FEATURES_IN_SCHEME);
        this.tester.assertOptionsEqual("issuetype", new String[]{"Bug", "Improvement", "Task"});
        this.tester.assertRadioOptionValueNotPresent("issuetype", "New Feature");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "2");
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("Issue type New Feature not applicable for this project");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, INVALID_ISSUE_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("Selected issue type not found.");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "");
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("Issue type not specified");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "5");
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("Issue type Sub-task is a sub-task");
    }

    private void gotoConvertSubTask(String issueId) {
        this.tester.gotoPage("/secure/ConvertSubTask.jspa?id=" + issueId);
    }

    private void gotoConvertSubTaskStep2(String issueId, String issueType) {
        this.tester.gotoPage("/secure/ConvertSubTaskSetIssueType.jspa?id=" + issueId + "&issuetype=" + issueType);
    }
}

