/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestMoveSubTask
extends BaseJiraFuncTest {
    private static final String NEW_SUBTASK_TYPE = "newSubTaskType";
    private static final String STEP_ONE_TITLE = "Choose Operation";
    private static final String STEP_TWO_TITLE = "Operation Details";
    private static final String STEP_THREE_TITLE = "Update Fields";
    private static final String STEP_FOUR_TITLE = "Confirmation";
    private static final String SUBTASK_SUMMARY = "this subtask is moved";
    private String parentIssue1;
    private String parentIssue2;
    private String parentIssue3;
    private String subtask;
    private String subtask2;
    private String subtask3;
    @Inject
    private Form form;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.backdoor.subtask().enable();
    }

    @Test
    public void testMoveSubTask() {
        this.parentIssue1 = this.navigation.issue().createIssue("homosapien", "Bug", "control parent issue in project homosap");
        this.subtask = this.navigation.issue().createSubTask(this.parentIssue1, "Sub-task", SUBTASK_SUMMARY, "description: Test subject");
        this._testMoveSubTaskOperationListVisibility();
        this._testSidePanelLinksForMoveSubTaskType();
        this._testSuccessfulMoveOfSubTaskType();
        this.parentIssue2 = this.navigation.issue().createIssue("homosapien", "Bug", "control parent issue 2 in project homosap");
        this.parentIssue3 = this.navigation.issue().createIssue("monkey", "Bug", "control parent issue 3 in project monkey");
        this.subtask2 = this.navigation.issue().createSubTask(this.parentIssue1, "Sub-task", "control subtask of parent 1 (homosap)", "description");
        this.subtask3 = this.navigation.issue().createSubTask(this.parentIssue3, "Sub-task", "control subtask of parent 3 (monkey)", "description");
        this._testSidePanelLinksForMoveSubTaskParent();
        this._testValidateMoveSubTaskParent();
        this._testSuccessfulMoveOfSubTaskParent();
        this.administration.subtasks().deleteSubTaskType(NEW_SUBTASK_TYPE);
    }

    private void _testMoveSubTaskOperationListVisibility() {
        this.logger.log((Object)"Check move-subtask link is hidden with no permission");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.subtask);
        this.tester.assertLinkNotPresent("move-subtask");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.logger.log((Object)"Check move subtask type operation cannot be perfomed");
        this.navigation.issue().gotoIssue(this.subtask);
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.logger.log((Object)"Check move subtask type operation can be performed");
        this.addNewSubTaskType();
        this.navigation.issue().gotoIssue(this.subtask);
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
    }

    private void _testSuccessfulMoveOfSubTaskType() {
        this.addNewSubTaskType();
        this.gotoStep1ofMoveSubTaskType();
        this.tester.assertFormElementPresent("issuetype");
        this.navigation.issue().selectIssueType(NEW_SUBTASK_TYPE, "issuetype");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Sub-task");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Sub-task", NEW_SUBTASK_TYPE);
        this.tester.submit("Move");
        this.assertions.assertLastChangeHistoryRecords(this.subtask, new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Issue Type", "Sub-task", NEW_SUBTASK_TYPE)));
    }

    private void addNewSubTaskType() {
        this.administration.subtasks().addSubTaskType(NEW_SUBTASK_TYPE, "temporary subtask type");
    }

    private void _testSidePanelLinksForMoveSubTaskType() {
        this.gotoStep2ofMoveSubTaskType();
        this.tester.assertTextPresent("Step 1 of 4");
        this.gotoStep3ofMoveSubTaskType();
        this.tester.clickLinkWithText(STEP_ONE_TITLE);
        this.tester.assertTextPresent("Step 1 of 4");
        this.gotoStep3ofMoveSubTaskType();
        this.tester.clickLinkWithText(STEP_TWO_TITLE);
        this.tester.assertTextPresent("Step 2 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.tester.clickLinkWithText(STEP_ONE_TITLE);
        this.tester.assertTextPresent("Step 1 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.tester.clickLinkWithText(STEP_TWO_TITLE);
        this.tester.assertTextPresent("Step 2 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.tester.clickLinkWithText(STEP_THREE_TITLE);
        this.tester.assertTextPresent("Step 3 of 4");
    }

    private void _testWizardCancelForMoveSubTaskType() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep1ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep2ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep3ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep4ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
    }

    private void checkCancelRedirectsViewIssue() {
        this.tester.assertFormElementPresent("Cancel");
        this.form.clickAnyButtonWithValue("Cancel");
        this.tester.assertTextNotPresent("Step ");
        this.tester.assertLinkPresentWithText(this.subtask);
        this.tester.assertLinkPresentWithText("move-subtask");
    }

    private void gotoMoveSubTaskChooseOperation() {
        this.navigation.issue().gotoIssue(this.subtask);
        this.tester.clickLink("move-subtask");
        this.tester.assertTextPresent("Step 1 of 4");
    }

    private void gotoStep1ofMoveSubTaskType() {
        this.gotoMoveSubTaskChooseOperation();
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
    }

    private void gotoStep2ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.tester.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
        this.tester.clickLinkWithText(STEP_ONE_TITLE);
    }

    private void gotoStep3ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.tester.submit("Next >>");
        this.tester.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.tester.assertLinkPresentWithText(STEP_TWO_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    private void gotoStep4ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.tester.assertLinkPresentWithText(STEP_TWO_TITLE);
        this.tester.assertLinkPresentWithText(STEP_THREE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    private void gotoStep4ofMoveSubTaskParent() {
        this.gotoMoveSubTaskChooseOperation();
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
    }

    private void _testValidateMoveSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.tester.setFormElement("parentIssue", "");
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Parent Issue is a required field");
        this.tester.setFormElement("parentIssue", "dontExist");
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("The issue key &quot;dontExist&quot; does not exist");
        this.tester.setFormElement("parentIssue", this.subtask);
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Issue cannot be its own parent");
        this.tester.setFormElement("parentIssue", this.parentIssue1);
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Already linked to this parent issue");
        this.tester.setFormElement("parentIssue", this.parentIssue3);
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Cannot link Parent issue from a different project");
        this.tester.setFormElement("parentIssue", this.subtask2);
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Subtasks cannot be a parent issue");
        this.tester.setFormElement("parentIssue", this.subtask3);
        this.tester.submit("Change Parent");
        this.tester.assertTextPresent("Subtasks cannot be a parent issue");
    }

    private void _testWizardCancelForMoveSubTaskParent() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep4ofMoveSubTaskParent();
        this.checkCancelRedirectsViewIssue();
    }

    private void _testSuccessfulMoveOfSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.tester.setFormElement("parentIssue", this.parentIssue2);
        this.tester.submit("Change Parent");
        this.tester.assertTextNotPresent("Step 4 of 4");
        this.assertions.assertNewestChangeHistoryRecord("HSP-2", "admin", Collections.singletonList(new ExpectedChangeHistoryItem("Parent Issue", this.parentIssue1, this.parentIssue2)));
    }

    private void _testSidePanelLinksForMoveSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.tester.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
        this.tester.clickLinkWithText(STEP_ONE_TITLE);
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertLinkNotPresentWithText(STEP_ONE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.tester.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    @Test
    public void testMoveParentSubTaskLinks() {
        String origParentName = "First Parent";
        String firstParent = this.navigation.issue().createIssue("monkey", "Bug", origParentName);
        String newParent = this.navigation.issue().createIssue("monkey", "Bug", "Second Parent");
        String childKey = this.navigation.issue().createSubTask(firstParent, "Sub-task", "subtask originally on First Parent", "sub bug");
        String linkageName = "linkoid";
        String linkLabel = "is linked to";
        this.backdoor.issueLinking().createIssueLinkType(linkageName, linkLabel, linkLabel);
        this.navigation.issue().linkIssueWithComment(childKey, linkLabel, firstParent, null, null);
        this.administration.issueLinking().enable();
        this.navigation.issue().gotoIssue(childKey);
        this.tester.clickLink("move-subtask");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.setFormElement("parentIssue", newParent);
        this.tester.submit("Change Parent");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{linkLabel, firstParent, origParentName});
    }
}

