/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestMoveSubTaskIssueType
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreData("TestMoveSubTaskIssueType.xml");
    }

    @After
    public void tearDown() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testHappy() {
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Sub-task 2");
        this.tester.assertTextNotPresent("Sub-task 3");
    }

    @Test
    public void testNoOtherSubsInProject() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("del_Sub-task 2");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.tester.assertTextPresent("There are no other sub-task issue types associated with this project.");
    }

    @Test
    public void testNoScheme() {
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Default Issue Type Scheme");
        this.tester.submit(" OK ");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Sub-task 2");
        this.tester.assertTextPresent("Sub-task 3");
    }

    @Test
    public void testNoOtherSubsAtAll() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("del_Sub-task 2");
        this.tester.submit("Delete");
        this.tester.clickLink("del_Sub-task 3");
        this.tester.submit("Delete");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Default Issue Type Scheme");
        this.tester.submit(" OK ");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("move-subtask");
        this.tester.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.tester.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.tester.assertTextPresent("There are no other sub-task issue types defined in the system.");
    }
}

