/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.MimeMessageMatchers;
import com.atlassian.jira.functest.rule.MailTest;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
@Restore(value="TestWorklogNotificationsIncludingUserThatListensToIssueUpdated.xml")
@MailTest
public class TestWorklogNotifications
extends BaseJiraEmailTest {
    public static final String EMAIL_ADDRESS = "admin@example.com";
    public static final String EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED = "fred@example.com";
    public static final String TEXT_ON_WORKLOG_ADDED_MAIL = "added a worklog";
    public static final String TEXT_ON_WORKLOG_UPDATED_MAIL = "updated a worklog";
    public static final String TEXT_ON_WORKLOG_DELETED_MAIL = "deleted a worklog";

    @Test
    public void testAddingNewWorkLogSendsEmail() throws Exception {
        this.logSomeWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_ADDED_MAIL);
    }

    @Test
    public void testUpdatingWorkLogSendsEmail() throws Exception {
        this.updateWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_UPDATED_MAIL);
    }

    @Test
    public void testDeletingWorklogSendsEmail() throws Exception {
        this.deleteWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_DELETED_MAIL);
    }

    @Test
    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenLoggingWork() throws Exception {
        this.logSomeWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    @Test
    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenUpdatingWork() throws Exception {
        this.updateWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    @Test
    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenDeletingWork() throws Exception {
        this.deleteWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    private void logSomeWork(String issueKey) {
        this.navigation.issue().logWork(issueKey, "1h");
    }

    private void updateWork(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.clickLink("edit_worklog_10000");
        this.tester.submit("Log");
    }

    private void deleteWork(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.clickLink("delete_worklog_10000");
        this.tester.submit("Delete");
    }

    private void assertOneEmailWasSent(String emailAddress, String expectedText) throws Exception {
        Collection<MimeMessage> emails = this.mailHelper.flushMailQueueAndWait(1);
        MimeMessage email = emails.iterator().next();
        Assert.assertThat((Object)email, (Matcher)Matchers.allOf(MimeMessageMatchers.withRecipientEqualTo(emailAddress), MimeMessageMatchers.containsString(expectedText)));
    }

    private void assertNoEmailsWereSentTo(String emailAddress) throws Exception {
        Collection<MimeMessage> emails = this.mailHelper.flushMailQueueAndWait(1);
        Assert.assertThat(emails, (Matcher)Matchers.not((Matcher)Matchers.hasItem(MimeMessageMatchers.withRecipientEqualTo(emailAddress))));
    }
}

