/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.TIME_TRACKING})
@Restore(value="TestTimeTrackingAggregates.xml")
@LoginAs(user="admin")
public class TestTimeTrackingAggregates
extends BaseJiraFuncTest {
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAllTest() throws SAXException {
        this._testNoValues();
        this._testNoOrigValue();
        this._testNoTimeSpent();
        this._testAllValuesTotalGreaterThanOrigNoSubs();
        this._testNoValuesWithSubstasks();
        this._testWithNoValueSubTaskAsStartingPoint();
        this._testWithValuesWithSubstasksWithValues();
        this._testWithRemainingZeroValue();
        this._testPermissionedSubtasks();
        this._testCantSeeSubTasks();
    }

    @Test
    public void testTimeTrackingDisabled() {
        this.administration.timeTracking().disable();
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertHeadingNotPresent();
        this.tester.assertTextNotPresent("Estimated:");
        this.tester.assertTextNotPresent("subtasks_resolution_percentage");
        this.navigation.issue().gotoIssue("HSP-6");
        this.assertHeadingNotPresent();
        this.tester.assertTextNotPresent("Estimated:");
        this.tester.assertTextPresent("subtasks_resolution_percentage");
    }

    @Test
    public void testTimeTrackingHidden() {
        this.editIssueFieldVisibility.setHiddenFields("Time Tracking");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextNotPresent("tt_single_text_orig");
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.navigation.issue().gotoIssue("HSP-6");
        this.tester.assertTextNotPresent("tt_single_text_orig");
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
    }

    public void _testNoValues() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-2");
        Assert.assertEquals((long)0L, (long)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
    }

    public void _testNoOrigValue() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "Not Specified", "Remaining", "2d", "Logged:", "2d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoTimeSpent() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "3d", "Remaining", "3d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testAllValuesTotalGreaterThanOrigNoSubs() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-5");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1w 1d", "Remaining", "4d", "Logged:", "4d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoValuesWithSubstasks() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-6");
        Assert.assertEquals((long)0L, (long)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
        Assert.assertEquals((long)0L, (long)new IdLocator(this.tester, "tt_aggregate_table_info").getNodes().length);
        this.assertHeadingNotPresent();
        this.tester.assertTextNotPresent("subtasks_resolution_percentage");
    }

    public void _testWithNoValueSubTaskAsStartingPoint() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-7");
        this.assertHeadingNotPresent();
        Assert.assertEquals((long)0L, (long)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
    }

    public void _testWithValuesWithSubstasksWithNoValues() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-9");
        this.assertHeadingPresent();
        this.tester.assertTextPresent("tt_aggregate_text_orig");
        this.tester.assertTextPresent("Issue & Sub-Tasks");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "3d", "Remaining", "3d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:75%");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "Not Specified", "Remaining", "Not Specified", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_percent_HSP-10"), "50%");
        this.assertGraphContainerAttribute("tt_graph_inner_HSP-10", "width:100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 1, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 2, "width:50%");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "tt_percent_HSP-11"), "%");
        this.assertGraphContainerAttribute("tt_graph_inner_HSP-11", "width:100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-11", 0, "width:100%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-11", 0, "width:100%");
    }

    public void _testWithAllValueSubTaskAsStartingPoint() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-10");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1d", "Remaining", "1d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testWithValuesWithSubstasksWithValues() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-12");
        this.assertHeadingPresent();
        this.tester.assertTextPresent("tt_aggregate_text_orig");
        this.tester.assertTextPresent("Include sub-tasks");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "1w 1d", "Remaining", "4d", "Logged", "1w");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:66%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:34%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:45%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:45%");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "4d", "Remaining", "4d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:80%");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-13"), "100%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-13", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 0, "width:57%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 1, "width:43%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-13", 0, "width:100%");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-14"), "100%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-14", "width:14%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-14", 0, "width:0%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-14", 0, "width:100%");
    }

    public void _testWithRemainingZeroValue() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-13");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "0m", "Logged:", "3d 4h");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:57%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:43%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testPermissionedSubtasks() throws SAXException {
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue("HSP-15");
        this.assertHeadingPresent();
        this.tester.assertTextPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "2d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "3d 2h", "Remaining", "3d 2h", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue("HSP-15");
        this.assertHeadingPresent();
        this.tester.assertTextPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "2d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "4d", "Remaining", "4d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:80%");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_graph_outer_HSP-17");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_percent_HSP-17");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_graph_inner_HSP-17");
        this.tester.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.tester.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
        this.tester.assertTextNotPresent("tt_dpb_graph_orig_HSP-18");
    }

    public void _testCantSeeSubTasks() throws SAXException {
        this.navigation.issue().gotoIssue("HSP-19");
        this.assertHeadingPresent();
        this.tester.assertTextNotPresent("tt_aggregate_text_orig");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1d", "Remaining", "1d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    @Test
    public void testProgressNavigableField() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_graph_outer_HSP-17");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_percent_HSP-17_");
        this.assertions.assertNodeByIdDoesNotExist("tt_dpb_graph_inner_HSP-17");
        this.tester.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.tester.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
    }

    @Test
    public void testAggregateProgressBar() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotPresent("\u03a3 Estimated");
        this.backdoor.columnControl().addLoggedInUserColumns(Arrays.asList("aggregateprogress"));
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent(" Progress");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-19"), "0%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-19", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-19", 0, "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-19", 0, "width:100%");
        this.assertions.assertNodeByIdDoesNotExist("tt_apb_graph_outer_HSP-17");
        this.assertions.assertNodeByIdDoesNotExist("tt_apb_percent_HSP-17_");
        this.assertions.assertNodeByIdDoesNotExist("tt_apb_graph_inner_HSP-17");
        this.tester.assertTextNotPresent("tt_apb_graph_orig_HSP-17_empty_cell");
        this.tester.assertTextNotPresent("tt_apb_graph_progress_HSP-17_empty_cell");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 2, "width:67%");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-12"), "55%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-12", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 0, "width:55%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 2, "width:45%");
    }

    private void assertHeadingPresent() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//h3"), "Time Tracking");
    }

    private void assertHeadingNotPresent() {
        this.textAssertions.assertTextNotPresent(new XPathLocator(this.tester, "//h3"), "Time Tracking");
    }

    private void assertGraphElementAttribute(String tableName, int col, String attribute) throws SAXException {
        WebTable table = this.tester.getDialog().getResponse().getTableWithID(tableName);
        String style = table.getTableCell(0, col).getDOM().getAttributes().getNamedItem("style").getNodeValue();
        Assert.assertTrue((boolean)style.contains(attribute));
    }

    private void assertGraphContainerAttribute(String tableId, String attributeValue) throws SAXException {
        String actualStyle = this.tester.getDialog().getElement(tableId).getAttribute("style");
        Assert.assertTrue((boolean)actualStyle.contains(attributeValue));
    }
}

