/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.I18N, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingLocalization
extends BaseJiraFuncTest {
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;

    @Test
    public void testTimeTrackingI18N() throws Exception {
        this.administration.restoreData("TimeTrackingi18n.xml");
        this.navigation.issue().viewIssue("HSP-1");
        ViewIssueDetails issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"1d 1h 1m", (Object)issueDetails.getOriginalEstimate());
        Assert.assertEquals((Object)"1d 1h 1m", (Object)issueDetails.getRemainingEstimate());
        this.navigation.login("fred");
        this.navigation.issue().viewIssue("HSP-1");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"1j 1h 1m", (Object)issueDetails.getOriginalEstimate());
        Assert.assertEquals((Object)"1j 1h 1m", (Object)issueDetails.getRemainingEstimate());
        this.navigation.login("anne");
        this.navigation.issue().viewIssue("HSP-1");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"1 \u65e5 1 \u6642\u9593 1 \u5206", (Object)issueDetails.getOriginalEstimate());
        Assert.assertEquals((Object)"1 \u65e5 1 \u6642\u9593 1 \u5206", (Object)issueDetails.getRemainingEstimate());
    }
}

