/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.REPORTS, Category.TIME_TRACKING})
@LoginAs(user="admin")
@Restore(value="TestTimeTrackingReportPermissions.xml")
public class TestTimeTrackingReportPermissions
extends BaseJiraFuncTest {
    private static final char NON_BREAKING_NEGATIVE = '\u2011';
    private static final String SIGMA = "&Sigma;";

    @Test
    public void test() throws SAXException {
        this._testAdminNoVersion();
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this._testBobNoVersion();
        this._testBobVersion1();
        this._testBobVersion4();
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this._testFredNoVersion();
        this._testFredVersion1();
        this._testFredVersion4();
    }

    private void _testBobVersion1() {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "10000");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(91, 14);
        Table table = this.getTable("timeReport");
        table.assertRows(4);
        Row row = table.nextRow();
        row.summary("Sub One - Version One - Bob Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - Version One - Bob Security - Estimate 2 Hours");
        row.originalEstimate("2h");
        row.originalEstimateAggregate("2h");
        row.remainingEstimate("2h");
        row.remainingEstimateAggregate("2h");
        row.timeSpent("-");
        row.timeSpentAggregate("-");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Sub Two - Bob Security - Version One - Overestimate");
        row.isOrphan();
        row.originalEstimate("1d");
        row.originalEstimateAggregate("1d");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("4h");
        row.timeSpentAggregate("4h");
        row.accuracy("4h");
        row.accuracyAggregate("4h");
        row = table.nextRow();
        row.summary("Sub One - Version One - Bob Security - EstAct 2 days 2 hours");
        row.isOrphan();
        row.originalEstimate("2d 2h");
        row.originalEstimateAggregate("2d 2h");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("2d 2h");
        row.timeSpentAggregate("2d 2h");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Total");
        row.originalEstimate("3d 4h");
        row.originalEstimateAggregate("3d 4h");
        row.remainingEstimate("2h");
        row.remainingEstimateAggregate("2h");
        row.timeSpent("2d 6h");
        row.timeSpentAggregate("2d 6h");
        row.accuracy("4h");
        row.accuracyAggregate("4h");
    }

    private void _testBobVersion4() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "10001");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "incomplete");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(0, 0);
        Table table = this.getTable("timeReport");
        table.assertRows(4);
        Row row = table.nextRow();
        row.summary("Parent One - Version Four - Bob Security");
        row.isNotOrphan();
        row.hasNoTimeTracking();
        row.originalEstimateAggregate("6h");
        row.remainingEstimateAggregate("6h");
        row.timeSpentAggregate("-");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Sub One - Version Four - Bob Security - Estimate 3 Hours");
        row.isNotOrphan();
        row.hasNoTimeTrackingAggregate();
        row.originalEstimate("3h");
        row.remainingEstimate("3h");
        row.timeSpent("-");
        row.accuracy("on track");
        row = table.nextRow();
        row.summary("Sub One - Version One - Bob Security - Estimate 2 Hours");
        row.isNotOrphan();
        row.hasNoTimeTrackingAggregate();
        row.originalEstimate("2h");
        row.remainingEstimate("2h");
        row.timeSpent("-");
        row.accuracy("on track");
        row = table.nextRow();
        row.summary("Sub One - No Version - Bob Security - Estimate 1 Hour");
        row.isNotOrphan();
        row.hasNoTimeTrackingAggregate();
        row.originalEstimate("1h");
        row.remainingEstimate("1h");
        row.timeSpent("-");
        row.accuracy("on track");
        row = table.nextRow();
        row.summary("Total");
        row.originalEstimate("6h");
        row.originalEstimateAggregate("6h");
        row.remainingEstimate("6h");
        row.remainingEstimateAggregate("6h");
        row.timeSpent("0m");
        row.timeSpentAggregate("0m");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void _testBobNoVersion() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "-1");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(90, 0);
        Table table = this.getTable("timeReport");
        table.assertRows(4);
        Row row = table.nextRow();
        row.summary("Parent Three - No Version - Bob Security");
        row.isNotOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - No Version - Bob Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        this.assertOneHourEstimate(table);
        this.assertOneDayOneHourEstimate(table);
        row = table.nextRow();
        row.summary("Total");
        row.isNotOrphan();
        row.originalEstimate("1d 2h");
        row.originalEstimateAggregate("1d 2h");
        row.remainingEstimate("1h");
        row.remainingEstimateAggregate("1h");
        row.timeSpent("1d 1h");
        row.timeSpentAggregate("1d 1h");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void assertOneDayOneHourEstimate(Table table) {
        Row row = table.nextRow();
        row.summary("Sub One - No Version - Bob Security - EstAct 1 day 1 hour");
        row.isOrphan();
        row.originalEstimate("1d 1h");
        row.originalEstimateAggregate("1d 1h");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("1d 1h");
        row.timeSpentAggregate("1d 1h");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void _testFredVersion4() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "10001");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(83, 0);
        Table table = this.getTable("timeReport");
        table.assertRows(3);
        Row row = table.nextRow();
        row.summary("Sub One - Version Four - Fred Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - Version Four - Fred Security - Estimate Three Days");
        row.isOrphan();
        row.originalEstimate("3d");
        row.originalEstimateAggregate("3d");
        row.remainingEstimate("3d");
        row.remainingEstimateAggregate("3d");
        row.timeSpent("-");
        row.timeSpentAggregate("-");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Sub One - Version Four - Fred Security - EstAct 3 Weeks");
        row.isOrphan();
        row.originalEstimate("3w");
        row.originalEstimateAggregate("3w");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("3w");
        row.timeSpentAggregate("3w");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Total");
        row.originalEstimate("3w 3d");
        row.originalEstimateAggregate("3w 3d");
        row.remainingEstimate("3d");
        row.remainingEstimateAggregate("3d");
        row.timeSpent("3w");
        row.timeSpentAggregate("3w");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void _testFredVersion1() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "10000");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(84, -4);
        Table table = this.getTable("timeReport");
        table.assertRows(4);
        String minusFour = "\u20114h";
        Row row = table.nextRow();
        row.summary("Sub One - Version One - Fred Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - Version One - Fred Security - Estimate Two Days");
        row.isOrphan();
        row.originalEstimate("2d");
        row.originalEstimateAggregate("2d");
        row.remainingEstimate("2d");
        row.remainingEstimateAggregate("2d");
        row.timeSpent("-");
        row.timeSpentAggregate("-");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Sub Two - Fred Security - Version One - Under Estimate");
        row.isOrphan();
        row.originalEstimate("4h");
        row.originalEstimateAggregate("4h");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("1d");
        row.timeSpentAggregate("1d");
        row.accuracy(minusFour);
        row.accuracyAggregate(minusFour);
        row = table.nextRow();
        row.summary("Sub One - Version One - Fred Security - EstAct 2 Weeks");
        row.isOrphan();
        row.originalEstimate("2w");
        row.originalEstimateAggregate("2w");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("2w");
        row.timeSpentAggregate("2w");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
        row = table.nextRow();
        row.summary("Total");
        row.originalEstimate("2w 2d 4h");
        row.originalEstimateAggregate("2w 2d 4h");
        row.remainingEstimate("2d");
        row.remainingEstimateAggregate("2d");
        row.timeSpent("2w 1d");
        row.timeSpentAggregate("2w 1d");
        row.accuracy(minusFour);
        row.accuracyAggregate(minusFour);
    }

    private void _testFredNoVersion() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "-1");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(83, 0);
        Table table = this.getTable("timeReport");
        table.assertRows(3);
        Row row = table.nextRow();
        row.summary("Sub One - No Version - Fred Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        this.assertOneDayEstimate(table);
        this.assertOneWeekEstimate(table);
        row = table.nextRow();
        row.summary("Total");
        row.isNotOrphan();
        row.originalEstimate("1w 1d");
        row.originalEstimateAggregate("1w 1d");
        row.remainingEstimate("1d");
        row.remainingEstimateAggregate("1d");
        row.timeSpent("1w");
        row.timeSpentAggregate("1w");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void assertOneWeekEstimate(Table table) {
        Row row = table.nextRow();
        row.summary("Sub One - No Version - Fred Security - EstAct 1 Week");
        row.isOrphan();
        row.originalEstimate("1w");
        row.originalEstimateAggregate("1w");
        row.isComplete();
        row.isCompleteAggregate();
        row.timeSpent("1w");
        row.timeSpentAggregate("1w");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void _testAdminNoVersion() throws SAXException {
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "-1");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        this.assertSummaryPercentages(84, 0);
        Table table = this.getTable("timeReport");
        table.assertRows(7);
        Row row = table.nextRow();
        row.summary("Parent Three - No Version - Bob Security");
        row.isNotOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - No Version - Bob Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        row = table.nextRow();
        row.summary("Sub One - No Version - Fred Security - No Time");
        row.isOrphan();
        row.hasNoTimeTrackingAtAll();
        this.assertOneDayEstimate(table);
        this.assertOneHourEstimate(table);
        this.assertOneDayOneHourEstimate(table);
        this.assertOneWeekEstimate(table);
        row = table.nextRow();
        row.summary("Total");
        row.isNotOrphan();
        row.originalEstimate("1w 2d 2h");
        row.originalEstimateAggregate("1w 2d 2h");
        row.remainingEstimate("1d 1h");
        row.remainingEstimateAggregate("1d 1h");
        row.timeSpent("1w 1d 1h");
        row.timeSpentAggregate("1w 1d 1h");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void assertOneHourEstimate(Table table) {
        Row row = table.nextRow();
        row.summary("Sub One - No Version - Bob Security - Estimate 1 Hour");
        row.isOrphan();
        row.originalEstimate("1h");
        row.originalEstimateAggregate("1h");
        row.remainingEstimate("1h");
        row.remainingEstimateAggregate("1h");
        row.timeSpent("-");
        row.timeSpentAggregate("-");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void assertOneDayEstimate(Table table) {
        Row row = table.nextRow();
        row.summary("Sub One - No Version - Fred Security - Estimate One Day");
        row.isOrphan();
        row.originalEstimate("1d");
        row.originalEstimateAggregate("1d");
        row.remainingEstimate("1d");
        row.remainingEstimateAggregate("1d");
        row.timeSpent("-");
        row.timeSpentAggregate("-");
        row.accuracy("on track");
        row.accuracyAggregate("on track");
    }

    private void selectMultiOptionByValue(String fieldId, String value) {
        this.tester.checkCheckbox(fieldId, value);
    }

    private void gotoReportConfig(int projectId) {
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&selectedProjectId=" + projectId);
    }

    private void assertSummaryPercentages(int progressPercentage, int accuracyPercentage) {
        WebTable barsSummary = this.tester.getDialog().getWebTableBySummaryOrId("bars-summary");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 0, 0, "Progress: " + progressPercentage + "%");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 1, 0, "Accuracy: " + accuracyPercentage + "%");
    }

    private Table getTable(String id) {
        try {
            return new Table(this.tester.getDialog().getResponse().getTableWithID(id));
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not get WebTable", e);
        }
    }

    private List<String> getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    private class Row
    extends Assert {
        private final String[] row;

        Row(String[] row) {
            this.row = row;
        }

        Row(List rowList) {
            this(rowList.toArray(new String[rowList.size()]));
        }

        void hasNoTimeTrackingAtAll() {
            this.hasNoTimeTracking();
            this.hasNoTimeTrackingAggregate();
        }

        void hasNoTimeTracking() {
            this.originalEstimate("-");
            this.remainingEstimate("-");
            this.timeSpent("-");
            this.accuracy("-");
        }

        void hasNoTimeTrackingAggregate() {
            this.originalEstimateAggregate("-");
            this.remainingEstimateAggregate("-");
            this.timeSpentAggregate("-");
            this.accuracyAggregate("-");
        }

        void isOrphan() {
            this.summary("HSP-");
        }

        void isNotOrphan() {
            Row.assertTrue((String)this.row[3], (!this.row[3].contains("HSP-") ? 1 : 0) != 0);
        }

        void isComplete() {
            this.remainingEstimate("0m");
        }

        void isCompleteAggregate() {
            this.remainingEstimateAggregate("0m");
        }

        void summary(String str) {
            Row.assertTrue((String)this.row[3], (boolean)this.row[3].contains(str));
        }

        void originalEstimate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[4]);
        }

        void originalEstimateAggregate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[5]);
        }

        void remainingEstimate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[6]);
        }

        void remainingEstimateAggregate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[7]);
        }

        void timeSpent(String str) {
            Row.assertEquals((Object)str, (Object)this.row[8]);
        }

        void timeSpentAggregate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[9]);
        }

        void accuracy(String str) {
            Row.assertEquals((Object)str, (Object)this.row[10]);
        }

        void accuracyAggregate(String str) {
            Row.assertEquals((Object)str, (Object)this.row[11]);
        }
    }

    private class Table {
        private final WebTable table;
        private int nextRow = 1;

        Table(WebTable table) {
            this.table = table;
        }

        Row nextRow() {
            return new Row(TestTimeTrackingReportPermissions.this.getTableRowAsList(this.table, this.nextRow++));
        }

        void assertRows(int rows) {
            Assert.assertEquals((long)(rows += 2), (long)this.table.getRowCount());
        }
    }

    private static class Urls {
        private static final String TIMETRACKING_REPORT_CONFIG = "/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking";

        private Urls() {
        }
    }
}

