/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
public class TestWorkLogTabPanel
extends BaseJiraFuncTest {
    private static final String ADMIN_TIME_WORKED = "4h 30m";
    private static final String ADMIN_TIME_PERFORMED = "18/Jun/07 05:39 PM";
    private static final String ADMIN_COMMENT = "Admin's worklog comment.";
    private static final String ADMIN = "admin";
    private static final String FRED_TIME_WORKED = "3d";
    private static final String FRED_TIME_PERFORMED = "20/Jun/07 05:39 PM";
    private static final String FRED_COMMENT = "Fred's worklog comment.";
    private static final String FRED = "fred";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestLogWork.xml");
        this.grantPermission(FRED, ProjectPermissions.WORK_ON_ISSUES);
        this.addTestWorklogs();
    }

    @Test
    public void testViewIssuePermissionOnly() {
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    @Test
    public void testEditOwnWorklogsPermission() {
        this.grantPermission(ADMIN, ProjectPermissions.EDIT_OWN_WORKLOGS);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    @Test
    public void testEditAllWorklogsPermission() {
        this.grantPermission(ADMIN, ProjectPermissions.EDIT_ALL_WORKLOGS);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertTrue((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    @Test
    public void testDeleteOwnWorklogsPermission() {
        this.grantPermission(ADMIN, ProjectPermissions.DELETE_OWN_WORKLOGS);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    @Test
    public void testDeleteAllWorklogsPermission() {
        this.grantPermission(ADMIN, ProjectPermissions.DELETE_ALL_WORKLOGS);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertTrue((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    @Test
    public void testFullWorklogPermissions() {
        this.grantPermission(ADMIN, ProjectPermissions.EDIT_ALL_WORKLOGS);
        this.grantPermission(ADMIN, ProjectPermissions.DELETE_ALL_WORKLOGS);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        Assert.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        Assert.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        Assert.assertTrue((boolean)this.isFredsWorklogEditLinkPresent());
        Assert.assertTrue((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    private void assertWorklogsPresent() {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Fred Normal", "Time Spent:", "3 days", "Fred&#39;s worklog comment.", "Administrator", "Time Spent:", "4 hours, 30 minutes", "Admin&#39;s worklog comment."});
    }

    private void gotoHSP1WorklogTab() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("Work Log");
    }

    private boolean isAdminWorklogEditLinkPresent() {
        this.logger.log((Object)"checking if the edit link for Admin's worklog is present");
        return this.tester.getDialog().isTextInResponse("/secure/UpdateWorklog!default.jspa?id=10000&worklogId=10000");
    }

    private boolean isAdminWorklogDeleteLinkPresent() {
        this.logger.log((Object)"checking if the delete link for Admin's worklog is present");
        return this.tester.getDialog().isTextInResponse("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
    }

    private boolean isFredsWorklogEditLinkPresent() {
        this.logger.log((Object)"checking if the edit link for Fred's worklog is present");
        return this.tester.getDialog().isTextInResponse("/secure/UpdateWorklog!default.jspa?id=10000&worklogId=10001");
    }

    private boolean isFredsWorklogDeleteLinkPresent() {
        this.logger.log((Object)"checking if the edit link for Fred's worklog is present");
        return this.tester.getDialog().isTextInResponse("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10001");
    }

    private void addTestWorklogs() {
        this.logger.log((Object)"Adding worklog as admin");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", ADMIN_TIME_WORKED);
        this.tester.setFormElement("startDate", ADMIN_TIME_PERFORMED);
        this.tester.getDialog().setFormParameter("comment", ADMIN_COMMENT);
        this.tester.submit("Log");
        this.navigation.logout();
        this.logger.log((Object)"Adding worklog as fred");
        this.navigation.login(FRED, FRED);
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", FRED_TIME_WORKED);
        this.tester.setFormElement("startDate", FRED_TIME_PERFORMED);
        this.tester.getDialog().setFormParameter("comment", FRED_COMMENT);
        this.tester.submit("Log");
        this.navigation.logout();
        this.logger.log((Object)"Logging back in as admin");
        this.navigation.login(ADMIN, ADMIN);
    }

    private void grantPermission(String username, ProjectPermissionKey permission) {
        this.navigation.gotoAdmin();
        this.backdoor.permissionSchemes().addUserPermission(0L, permission, username);
    }
}

