/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import java.text.SimpleDateFormat;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Before;

abstract class AbstractWorklogSearchingTest
extends BaseJiraRestTest {
    protected static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final long DEFAULT_PERMISSION_SCHEME_ID = 0L;
    protected final String defaultStartDate = "2014-08-06";
    protected WorklogClient worklogClient;
    protected IssueClient issueClient;
    protected final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    AbstractWorklogSearchingTest() {
    }

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    protected Worklog createWorklog(String issueKey, String date) {
        return this.createWorklog(issueKey, date, "admin");
    }

    protected Worklog createWorklog(String issueKey, String date, String userName) {
        return this.createWorklog(issueKey, this.dateTimeFormatter.parseDateTime(date), userName);
    }

    protected Worklog createWorklog(String issueKey, String date, String userName, String comment) {
        return this.createWorklog(issueKey, this.dateTimeFormatter.parseDateTime(date), userName, comment);
    }

    protected Worklog createWorklogAsUser(String issueKey, String userName) {
        return this.createWorklog(issueKey, DateTime.now(), userName);
    }

    protected Worklog createWorklogAsUserWithComment(String issueKey, String userName, String comment) {
        return this.createWorklog(issueKey, DateTime.now(), userName, comment);
    }

    private Worklog createWorklog(String issueKey, DateTime date, String userName) {
        return this.createWorklog(issueKey, date, userName, "");
    }

    protected Worklog createWorklog(String issueKey, DateTime date, String userName, String comment) {
        Worklog worklog = new Worklog();
        worklog.started = new SimpleDateFormat(TIME_FORMAT).format(date.toDate());
        worklog.timeSpent = "1h";
        worklog.comment = comment;
        return (Worklog)((WorklogClient)this.worklogClient.loginAs((String)userName)).post((String)issueKey, (Worklog)worklog).body;
    }

    protected void deleteWorklog(String issueKey, Worklog worklog) {
        ((WorklogClient)this.worklogClient.loginAs("admin")).delete(issueKey, worklog);
    }

    protected void updateWorklog(String issueKey, Worklog worklog) {
        ((WorklogClient)this.worklogClient.loginAs("admin")).put(issueKey, worklog);
    }

    protected String getDateFromString(String date) {
        DateTime dateTime = this.dateTimeFormatter.parseDateTime(date);
        return new SimpleDateFormat(TIME_FORMAT).format(dateTime.toDate());
    }

    protected String createDefaultIssue() {
        return this.backdoor.issues().createIssue((String)"HSP", (String)"test issue!", (String)"admin").key;
    }

    protected SearchResult executeEqualWorklogDateSearch(String date) {
        return ((SearchClient)this.backdoor.search().loginAs("fred", "fred")).getSearch(new SearchRequest().jql("worklogDate=" + date));
    }

    protected SearchResult executeEqualWorklogDateSearchAsUser(String date, String user) {
        return ((SearchClient)this.backdoor.search().loginAs(user, user)).getSearch(new SearchRequest().jql("worklogDate=" + date));
    }

    protected SearchResult executeJqlSearch(String query) {
        return this.executeJqlSearchAsUser(query, "fred");
    }

    protected SearchResult executeJqlSearchAsUser(String query, String user) {
        return ((SearchClient)this.backdoor.search().loginAs(user)).getSearch(new SearchRequest().jql(query));
    }

    protected int getResponseCode(String jql) throws Exception {
        ParsedResponse response = ((SearchClient)this.backdoor.search().loginAs("fred")).getSearchResponse(new SearchRequest().jql(jql));
        return response.statusCode;
    }
}

