/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.timetracking.modern.AbstractTestCreateWorklogAsField;
import com.atlassian.jira.webtests.ztests.timetracking.modern.LogWorkRunner;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
public class TestCreateWorklogOnCloseTransition
extends AbstractTestCreateWorklogAsField {
    private LogWorkRunner logWorkRunner;
    @Inject
    private WorkflowUtil workflowUtil;

    @Override
    protected LogWorkRunner getLogWorkRunner() {
        if (this.logWorkRunner == null) {
            this.logWorkRunner = new CloseTransitionLogWorkRunner();
        }
        return this.logWorkRunner;
    }

    @Override
    @Test
    public void testWorklogNoPermToCreate() {
        super.testWorklogNoPermToCreate();
    }

    @Override
    @Test
    public void testWorklogTimeTrackingDisabled() {
        super.testWorklogTimeTrackingDisabled();
    }

    @Override
    @Test
    public void testLogWorkLeaveEstimateNoteCorrect() {
        super.testLogWorkLeaveEstimateNoteCorrect();
    }

    @Override
    @Test
    public void testMandatoryFields() {
        super.testMandatoryFields();
    }

    @Override
    @Test
    public void testInvalidFormattedDurationFields() {
        super.testInvalidFormattedDurationFields();
    }

    @Override
    @Test
    public void testBadFractionDuration() {
        super.testBadFractionDuration();
    }

    @Override
    @Test
    public void testGoodFractionDuration() throws Exception {
        super.testGoodFractionDuration();
    }

    @Override
    @Test
    public void testInvalidTimeSpentZero() {
        super.testInvalidTimeSpentZero();
    }

    @Override
    @Test
    public void testInvalidStartDateField() {
        super.testInvalidStartDateField();
    }

    @Override
    @Test
    public void testAutoAdjustEstimate() {
        super.testAutoAdjustEstimate();
    }

    @Override
    @Test
    public void testNewEstimate() {
        super.testNewEstimate();
    }

    @Override
    @Test
    public void testLeaveExistingEstimate() {
        super.testLeaveExistingEstimate();
    }

    @Override
    @Test
    public void testManuallyAdjustEstimate() {
        super.testManuallyAdjustEstimate();
    }

    @Override
    @Test
    public void testLogWorkVisibleToAll() {
        super.testLogWorkVisibleToAll();
    }

    @Override
    @Test
    public void testLogWorkVisibleToAllDaysTimeFormat() {
        super.testLogWorkVisibleToAllDaysTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkVisibleToAllHoursTimeFormat() {
        super.testLogWorkVisibleToAllHoursTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkVisibleToRole() {
        super.testLogWorkVisibleToRole();
    }

    @Override
    @Test
    public void testLogWorkVisibleToRoleDaysTimeFormat() {
        super.testLogWorkVisibleToRoleDaysTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkVisibleToRoleHoursTimeFormat() {
        super.testLogWorkVisibleToRoleHoursTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkVisibleToGroup() {
        super.testLogWorkVisibleToGroup();
    }

    @Override
    @Test
    public void testLogWorkVisibleToGroupDaysTimeFormat() {
        super.testLogWorkVisibleToGroupDaysTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkVisibleToGroupHoursTimeFormat() {
        super.testLogWorkVisibleToGroupHoursTimeFormat();
    }

    @Override
    @Test
    public void testLogWorkCommentsNotCopiedWhenCopyingDisabled() {
        super.testLogWorkCommentsNotCopiedWhenCopyingDisabled();
    }

    @Override
    @Test
    public void testLogWorkCommentsCopiedWhenCopyingEnabled() {
        super.testLogWorkCommentsCopiedWhenCopyingEnabled();
    }

    @Override
    @Test
    public void testLogWorkDateIsStartDate() {
        super.testLogWorkDateIsStartDate();
    }

    @Override
    @Test
    public void testChangeHistory() throws Exception {
        super.testChangeHistory();
    }

    class CloseTransitionLogWorkRunner
    implements LogWorkRunner {
        CloseTransitionLogWorkRunner() {
        }

        @Override
        public void gotoLogWorkScreen1() {
            TestCreateWorklogOnCloseTransition.this.navigation.issue().viewIssue("HSP-1");
            TestCreateWorklogOnCloseTransition.this.workflowUtil.clickAction("action_id_2");
        }

        @Override
        public boolean isCommentFieldShown() {
            return true;
        }

        @Override
        public void gotoLogWorkScreen2() {
            TestCreateWorklogOnCloseTransition.this.navigation.issue().gotoIssue("HSP-1");
            TestCreateWorklogOnCloseTransition.this.workflowUtil.clickAction("action_id_3");
        }

        @Override
        public void gotoLogWorkScreenWithOriginalEstimate(String originalEstimate) {
            TestCreateWorklogOnCloseTransition.this.navigation.issue().viewIssue("HSP-1");
            TestCreateWorklogOnCloseTransition.this.tester.clickLink("edit-issue");
            TestCreateWorklogOnCloseTransition.this.tester.setFormElement("timetracking", originalEstimate);
            TestCreateWorklogOnCloseTransition.this.tester.submit("Update");
            this.gotoLogWorkScreen1();
        }

        @Override
        public void gotoLogWorkResult() {
            TestCreateWorklogOnCloseTransition.this.navigation.issue().viewIssue("HSP-1");
        }

        @Override
        public boolean isLoggingWorkTwiceSupported() {
            return true;
        }
    }
}

