/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingIsEditable
extends BaseJiraFuncTest {
    private static final String ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME = "timetracking_originalestimate";
    private static final String REMAINING_ESTIMATE_FORM_ELEMENT_NAME = "timetracking_remainingestimate";
    private static final String RESOLVE_ISSUE_LINK_ID = "action_id_5";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    @Test
    public void testAllEstimatesAreEditableOnCreateIssue() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.assertEstimateInputFieldsArePresent();
        this.tester.setFormElement("summary", "Test Original and Remaining Estimate Are Editable On Create");
        this.tester.setFormElement(ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME, "1d");
        this.tester.setFormElement(REMAINING_ESTIMATE_FORM_ELEMENT_NAME, "1d");
        this.tester.submit("Create");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("1d", "1d", "Not Specified");
    }

    @Test
    public void testsAllEstimatesAreEditableOnEditBeforeLoggingWork() {
        this.navigation.issue().gotoIssue("HSP-4");
        this.tester.clickLink("edit-issue");
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().setEstimates("HSP-4", "4d", "4d");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "4d", "Not Specified");
    }

    @Test
    public void testAllEstimatesAreEditableOnEditAfterLoggingWork() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().setEstimates("HSP-1", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "3d");
    }

    @Test
    public void testAllEstimatesAreEditableOnTransitionBeforeLoggingWork() {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().gotoIssue("HSP-4");
        this.workflowUtil.clickAction(RESOLVE_ISSUE_LINK_ID);
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().resolveIssue("HSP-4", "Fixed", "Test All Estimates Are Editable On Transition After Logging Work", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "Not Specified");
    }

    @Test
    public void testAllEstimatesAreEditableOnTransitionAfterLoggingWork() {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().gotoIssue("HSP-1");
        this.workflowUtil.clickAction(RESOLVE_ISSUE_LINK_ID);
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().resolveIssue("HSP-1", "Fixed", "Test All Estimates Are Editable On Transition After Logging Work", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "3d");
    }

    private void assertEstimateInputFieldsArePresent() {
        this.tester.assertFormElementPresent(ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME);
        this.tester.assertFormElementPresent(REMAINING_ESTIMATE_FORM_ELEMENT_NAME);
    }

    private void assertIssueHasBeenCreatedOrEditedSuccessfully() {
        String issueKeyTagId = "key-val";
        this.tester.assertElementPresent("key-val");
        Assert.assertNotNull((Object)new IdLocator(this.tester, "key-val"));
    }

    private void assertTimeTrackingValuesAreEqualTo(String originalEstimateValue, String remainingEstimateValue, String timeSpentValue) {
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_orig"), originalEstimateValue);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_remain"), remainingEstimateValue);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_spent"), timeSpentValue);
    }

    private void addTimeTrackingFieldToResolveIssueScreen() {
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Time Tracking");
    }
}

