/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingIsOptional
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    @Test
    public void testEmptyEstimatesOnCreateAreAccepted() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original And Remaining Estimates Are Accepted On Create");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Remaining Estimate Is Accepted On Create");
        this.tester.setFormElement("timetracking_originalestimate", "1d");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original Estimate Is Accepted On Create");
        this.tester.setFormElement("timetracking_remainingestimate", "1d");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    @Test
    public void testEmptyEstimatesOnEditAreAccepted() throws Exception {
        this.navigation.issue().setEstimates("HSP-5", "", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().setRemainingEstimate("HSP-5", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().setOriginalEstimate("HSP-5", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    @Test
    public void testEmptyEstimatesOnTransitionAreAccepted() throws Exception {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().resolveIssue("HSP-5", "Fixed", "Resolving With Empty Estimates", "", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().resolveIssue("HSP-4", "Fixed", "Resolving With Empty Remaining Estimate", null, "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().resolveIssue("HSP-10", "Fixed", "Resolving With Empty Original Estimate", "", null);
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    private void addTimeTrackingFieldToResolveIssueScreen() {
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Time Tracking");
    }

    private void assertIssueHasBeenCreatedOrEditedSuccessfully() {
        String issueKeyTagId = "key-val";
        this.tester.assertElementPresent("key-val");
        Assert.assertNotNull((Object)new IdLocator(this.tester, "key-val"));
    }

    private void assertIsRequiredErrorMessagesAreNotPresent() {
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
    }
}

