/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingIsRequired
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Time Tracking");
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    @Test
    public void testTwoEmptyEstimatesOnCreateAreRejected() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original And Remaining Estimates Are Rejected On Create");
        this.tester.submit("Create");
        this.textAssertions.assertTextPresent("Original Estimate is required.");
        this.textAssertions.assertTextPresent("Remaining Estimate is required.");
    }

    @Test
    public void testSpecifyingOneEstimateIsOkayAndCopiesToOther() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Remaining Estimate Is Rejected On Create");
        this.tester.setFormElement("timetracking_originalestimate", "1d");
        this.tester.submit("Create");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "1d", "Remaining", "1d");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original Estimate Is Rejected On Create");
        this.tester.setFormElement("timetracking_remainingestimate", "5h");
        this.tester.submit("Create");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "5h", "Remaining", "5h");
    }

    @Test
    public void testEmptyEstimatesOnEditAreRejectedOnlyWhenBothAreEmpty() throws Exception {
        this.navigation.issue().setEstimates("HSP-5", "", "");
        this.textAssertions.assertTextPresent("Original Estimate is required.");
        this.textAssertions.assertTextPresent("Remaining Estimate is required.");
        this.navigation.issue().setEstimates("HSP-4", "8m", "");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("8m", "8m", "Not Specified");
        this.navigation.issue().setEstimates("HSP-10", "", "4h");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "4h", "1d");
    }

    @Test
    public void testEmptyEstimatesOnTransitionAreRejectedOnlyWhenBothAreEmpty() throws Exception {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().resolveIssue("HSP-5", "Fixed", "Resolving With Empty Estimates", "", "");
        this.textAssertions.assertTextPresent("Original Estimate is required.");
        this.textAssertions.assertTextPresent("Remaining Estimate is required.");
        this.navigation.issue().resolveIssue("HSP-4", "Fixed", "Resolving With Empty Remaining Estimate", "8m", "");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("8m", "8m", "Not Specified");
        this.navigation.issue().resolveIssue("HSP-10", "Fixed", "Resolving With Empty Original Estimate", "", "4h");
        this.textAssertions.assertTextNotPresent("Original Estimate is required.");
        this.textAssertions.assertTextNotPresent("Remaining Estimate is required.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "4h", "1d");
    }

    private void addTimeTrackingFieldToResolveIssueScreen() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Time Tracking").addFieldToScreen("Resolve Issue Screen");
    }
}

