/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.DirectoryDTO;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.MockCrowdServerRule;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestBrowseUserDirectories
extends BaseJiraFuncTest {
    private static final String JAACS_APPLICATION_NAME = "CousinMabel";
    private static final String JAACS_APPLICATION_CREDENTIAL = "secret";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Assertions assertions;
    @Inject
    private TextAssertions textAssertions;
    @Rule
    public final MockCrowdServerRule mockCrowdServerRule = new MockCrowdServerRule();
    private String internalDirectoryName;

    @Before
    public void setUpTest() {
        this.setUpJaacsServer();
        this.internalDirectoryName = this.backdoor.usersAndGroups().getAllDirectories().stream().filter(directory -> directory.getType() == DirectoryType.INTERNAL).map(DirectoryDTO::getName).findFirst().orElse("");
    }

    @Test
    public void testEmptyData() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        this.tester.setWorkingForm("");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("<button id=\"new-directory\" class=\"aui-button\">Add Directory</button>");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
    }

    @Test
    public void testMultipleDirectories() throws IOException, SAXException {
        this.logger.log((Object)"Add a bunch of directories");
        this.addDirectories();
        this.logger.log((Object)"Checking directories present in the correct order");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.logger.log((Object)"Moving directory up");
        this.logger.log((Object)"Checking directories present in the correct order");
        WebLink link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(true).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(3).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.logger.log((Object)"Moving directory down");
        this.logger.log((Object)"Checking directories present in the correct order");
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("down");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(true).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.logger.log((Object)"Moving directory up");
        this.logger.log((Object)"Checking directories present in the correct order");
        link = userDirectoryTable.getTableCell(4, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(true).hasMoveDown(false).hasOnlyEditOperation();
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        link = userDirectoryTable.getTableCell(4, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        link = userDirectoryTable.getTableCell(3, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
    }

    private void addDirectories() {
        this.addCrowdDirectory("CROWD1", JAACS_APPLICATION_NAME, this.mockCrowdServerRule.url(), JAACS_APPLICATION_CREDENTIAL);
        this.addCrowdDirectory("CROWD2", JAACS_APPLICATION_NAME, this.mockCrowdServerRule.url(), JAACS_APPLICATION_CREDENTIAL);
        this.addCrowdDirectory("CROWD3", JAACS_APPLICATION_NAME, this.mockCrowdServerRule.url(), JAACS_APPLICATION_CREDENTIAL);
    }

    private void addCrowdDirectory(String name, String applicationName, String serverUrl, String password) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/crowd/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Server URL is a required field.");
        this.textAssertions.assertTextPresent("Application name is a required field.");
        this.textAssertions.assertTextPresent("Application password is a required field.");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("crowdServerUrl", serverUrl);
        this.tester.setFormElement("applicationName", applicationName);
        this.tester.setFormElement("applicationPassword", password);
        this.tester.submit("test");
        this.tester.submit("save");
    }

    private void setUpJaacsServer() {
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
        this.tester.clickLink("crowd-add-application");
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("credential", JAACS_APPLICATION_CREDENTIAL);
        this.tester.clickButton("edit-crowd-application-submit");
    }
}

