/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.MockCrowdServerRule;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestCrowdDirectoryMaintenance
extends BaseJiraFuncTest {
    private static final String JAACS_APPLICATION_NAME = "CousinMabel";
    private static final String JAACS_APPLICATION_CREDENTIAL = "secret";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Assertions assertions;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private LdapUtil ldapUtil;
    @Rule
    public final MockCrowdServerRule mockCrowdServerRule = new MockCrowdServerRule();
    private String internalDirectoryName;

    @Before
    public void setUpTest() {
        this.setUpJaacsServer();
        this.internalDirectoryName = this.ldapUtil.getInternalDirectoryName();
    }

    @Test
    public void testAddCrowdDirectory() {
        this.addDirectory();
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    private void addDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/crowd/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Server URL is a required field.");
        this.textAssertions.assertTextPresent("Application name is a required field.");
        this.textAssertions.assertTextPresent("Application password is a required field.");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "First Crowd");
        this.tester.setFormElement("crowdServerUrl", this.mockCrowdServerRule.url());
        this.tester.setFormElement("applicationName", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("applicationPassword", JAACS_APPLICATION_CREDENTIAL);
        this.tester.submit("test");
        this.tester.assertTextPresent("Connection test successful");
        this.tester.submit("save");
    }

    @Test
    public void testEditCrowdDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "First Crowd X");
        this.tester.setFormElement("crowdServerUrl", this.mockCrowdServerRule.url());
        this.tester.setFormElement("applicationName", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("applicationPassword", JAACS_APPLICATION_CREDENTIAL);
        this.tester.submit("test");
        this.tester.submit("save");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd X", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("crowdServerUrl", "");
        this.tester.setFormElement("applicationName", "");
        this.tester.setFormElement("applicationPassword", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Server URL is a required field.");
        this.textAssertions.assertTextPresent("Application name is a required field.");
        this.tester.clickLink("configure-crowd-form-cancel");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd X", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    @Test
    public void testDeleteCrowdDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd  (inactive)", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveSynchroniseOperations();
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "First Crowd");
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLinkWithPost(link);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Crowd");
    }

    private void setUpJaacsServer() {
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
        this.tester.clickLink("crowd-add-application");
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("credential", JAACS_APPLICATION_CREDENTIAL);
        this.tester.clickButton("edit-crowd-application-submit");
    }
}

