/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdLogEntry;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdMetricName;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestIpdUserDirectoryMetrics
extends BaseInProductDiagnosticsTest {
    private static final List<String> USR_DIR_METRIC_NAMES = Lists.list((Object[])new String[]{IpdMetricName.USR_DIR_CONNECTION_STATE.getCustomName(), IpdMetricName.USR_DIR_CONNECTION_LATENCY.getLastValueName(), IpdMetricName.USR_DIR_CONNECTION_LATENCY.getStatisticsName()});
    @Inject
    private LdapUtil ldapUtil;

    @Before
    public void init() throws InterruptedException, IOException {
        super.setUp();
        this.enableIPDFeature();
        this.enableIpdWipFeature();
        this.ldapUtil.createLdapDirectory();
        this.cleanIpdLogFile();
    }

    @Test
    public void shouldLogWhenDirectoryActive() throws IOException {
        String dirNameTagKey = "userDirName";
        List<IpdLogEntry> entries = this.readDistinctRegularLogMetricsInIpdLogFile();
        String escapedDirectoryName = this.ldapUtil.getDirectoryName().replace(" ", "_");
        entries.stream().filter(entry -> {
            assert (IpdMetricName.USR_DIR_CONNECTION_STATE.getCustomName() != null);
            return entry.getLabel().equals(IpdMetricName.USR_DIR_CONNECTION_STATE.getCustomName().toUpperCase());
        }).forEach(entry -> {
            Assertions.assertThat(entry.getTags()).isNotNull();
            Assertions.assertThat((String)entry.getTags().get("userDirName")).isEqualTo(escapedDirectoryName);
            Assertions.assertThat((boolean)entry.getAttributes().containsKey("connected")).isTrue();
            Assertions.assertThat((boolean)entry.getAttributes().containsKey("totalFailures")).isTrue();
            Assertions.assertThat((String)entry.getAttributes().get("connected")).isEqualTo("true");
            Assertions.assertThat((String)entry.getAttributes().get("totalFailures")).isEqualTo("0");
        });
        entries.stream().filter(entry -> {
            assert (IpdMetricName.USR_DIR_CONNECTION_LATENCY.getLastValueName() != null);
            return entry.getLabel().equals(IpdMetricName.USR_DIR_CONNECTION_LATENCY.getLastValueName().toUpperCase());
        }).forEach(entry -> {
            Assertions.assertThat(entry.getTags()).isNotNull();
            Assertions.assertThat((String)entry.getTags().get("userDirName")).isEqualTo(escapedDirectoryName);
            Assertions.assertThat((double)Double.parseDouble(entry.getAttributes().get("_value"))).isGreaterThan(0.0);
        });
        entries.stream().filter(entry -> {
            assert (IpdMetricName.USR_DIR_CONNECTION_LATENCY.getStatisticsName() != null);
            return entry.getLabel().equals(IpdMetricName.USR_DIR_CONNECTION_LATENCY.getStatisticsName().toUpperCase());
        }).forEach(entry -> {
            Assertions.assertThat(entry.getTags()).isNotNull();
            Assertions.assertThat((String)entry.getTags().get("userDirName")).isEqualTo(escapedDirectoryName);
        });
    }

    @Test
    public void shouldNotLogMetricsWhenDirectoryIsDisabled() throws IOException {
        this.setActiveLdapDirectory(false);
        this.cleanIpdLogFile();
        List<IpdLogEntry> entries = this.readDistinctRegularLogMetricsInIpdLogFile();
        Assertions.assertThat(entries.stream().filter(entry -> USR_DIR_METRIC_NAMES.contains(entry.getLabel())).collect(Collectors.toList())).isEmpty();
        this.setActiveLdapDirectory(true);
    }

    @Test
    public void shouldNotLogMetricsWhenDirectoryIsRemoved() throws IOException {
        this.removeLdapDirectory();
        this.cleanIpdLogFile();
        List<IpdLogEntry> entries = this.readDistinctRegularLogMetricsInIpdLogFile();
        Assertions.assertThat(entries.stream().filter(entry -> USR_DIR_METRIC_NAMES.contains(entry.getLabel())).collect(Collectors.toList())).isEmpty();
    }

    private void setActiveLdapDirectory(boolean active) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, active ? "Enable" : "Disable"));
        this.assertions.getTextAssertions().assertTextPresent(this.ldapUtil.getDirectoryName() + "</span>" + (active ? "" : "  <em>(inactive)</em>"));
    }

    private void removeLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Disable"));
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Remove"));
        this.assertions.getTextAssertions().assertTextNotPresent(this.ldapUtil.getDirectoryName());
    }
}

