/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.AdvancedAuditingClient;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestTpmDelegatingLdap
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    protected FuncTestLogger logger;
    @Inject
    protected Assertions assertions;
    @Inject
    protected LdapUtil ldapUtil;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void createDirectory() throws InterruptedException {
        this.ldapUtil.createLdapDirectory();
    }

    @Test
    public void testAddAndDeleteUser() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    @Test
    public void testAddAndDeleteGroup() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", "newGroup");
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists("newGroup");
        this.deleteGroup("newGroup");
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    @Test
    public void testLoginAsInvalidLdapUser() throws Exception {
        this.navigation.gotoAdmin();
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "password");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("admin");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    @Test
    public void testLoginAsValidLdapUser() throws Exception {
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "fail");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("wilma", "password");
        this.tester.clickLink("header-details-user-fullname");
        this.assertions.assertNodeByIdHasText("up-user-title-name", "Wilma Flintstone");
        this.navigation.logout();
        this.navigation.login("admin");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
        this.deleteUser("wilma");
    }

    @Test
    public void testLoginAsValidLdapUserWithCopyOnLogin() throws Exception {
        AdvancedAuditingClient aaClient = this.backdoor.advancedAuditing();
        this.setupUserWilma();
        long numberOfNewUserBeforeTheTest = this.getUserCreatedEvents(aaClient).count();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectoryWithCopyOnLogin();
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "fail");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("wilma", "password");
        this.tester.clickLink("header-details-user-fullname");
        this.assertions.assertNodeByIdHasText("up-user-title-name", "Wilma Flintstone");
        this.navigation.logout();
        this.assertCorrectUserCreated(numberOfNewUserBeforeTheTest);
        this.navigation.login("admin");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
        this.deleteUser("wilma");
    }

    private void assertCorrectUserCreated(long numberOfUsersBeforeTheTest) {
        List usersCreated = this.getUserCreatedEvents(this.backdoor.advancedAuditing()).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)((long)usersCreated.size() - numberOfUsersBeforeTheTest));
        Assert.assertThat((Object)((AdvancedAuditingClient.AuditEntities)usersCreated.get(0)).getAffectedObjects().get(0).getName(), (Matcher)CoreMatchers.startsWith((String)"wilma"));
    }

    private Stream<AdvancedAuditingClient.AuditEntities> getUserCreatedEvents(AdvancedAuditingClient aaClient) {
        return aaClient.takeAllEvents().stream().filter(aud -> aud.getType().getAction().equals("User created"));
    }

    @Test
    public void testEditUser() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.setFormElement("userSearchFilter", "wil");
        this.tester.submit("");
        this.tester.clickLink("edituser_link_wilma");
        this.tester.setFormElement("fullname", "Betty Rubble");
        this.tester.setFormElement("email", "betty@example.com");
        this.tester.submit("Update");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Betty Rubble", "betty@example.com", "Delegating LDAP Directory");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.addGroup("cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "cartoon-characters");
        this.administration.usersAndGroups().addUserToGroup("wilma", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("fred", "cartoon-characters");
        this.administration.usersAndGroups().addUserToGroup("fred", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("fred", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("wilma", "jira-developers");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "jira-developers");
        this.deleteUser("wilma");
        this.deleteGroup("cartoon-characters");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    private void setupUserWilma() {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }

    private void addGroup(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", name);
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists(name);
    }

    private void deleteGroup(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("nameFilter", name);
        this.tester.submit("filter");
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }

    private void addDelegatingLdapDirectory() throws Exception {
        this.addDelegatingLdapDirectory(false);
    }

    private void addDelegatingLdapDirectoryWithCopyOnLogin() throws Exception {
        this.addDelegatingLdapDirectory(true);
    }

    private void addDelegatingLdapDirectory(boolean createUserOnAuth) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.assertTextPresent("User Directories");
        if (this.ldapUtil.isActiveDirectory()) {
            this.logger.log((Object)"Attempting to add a Delegating Active Directory LDAP User Directory...");
            this.addActiveDirectory(createUserOnAuth);
        } else {
            this.logger.log((Object)"Attempting to add a Delegating Open LDAP User Directory...");
            this.addOpenLdap(createUserOnAuth);
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "Delegating LDAP Directory");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(3, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
        table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Delegating LDAP Directory");
    }

    private void addActiveDirectory(boolean createUserOnAuth) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "Delegating LDAP Directory");
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        if (createUserOnAuth) {
            this.tester.checkCheckbox("createUserOnAuth", "true");
            this.tester.setFormElement("ldapAutoAddGroups", "jira-users");
            this.tester.setFormElement("ldapUserObjectclass", "user");
            this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
            this.tester.setFormElement("ldapUserUsernameRdn", "cn");
            this.tester.setFormElement("ldapUserFirstname", "givenName");
            this.tester.setFormElement("ldapUserLastname", "sn");
            this.tester.setFormElement("ldapUserDisplayname", "displayName");
            this.tester.setFormElement("ldapUserEmail", "mail");
            this.tester.setFormElement("ldapExternalId", "objectGUID");
        }
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent(this.ldapUtil.getInternalDirectoryName());
        this.tester.assertTextPresent("Delegating LDAP Directory");
    }

    private void addOpenLdap(boolean createUserOnAuth) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "Delegating LDAP Directory");
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapUserUsername", "cn");
        if (createUserOnAuth) {
            this.tester.checkCheckbox("createUserOnAuth", "true");
            this.tester.setFormElement("ldapAutoAddGroups", "jira-users");
            this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
            this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
            this.tester.setFormElement("ldapUserUsername", "cn");
            this.tester.setFormElement("ldapUserUsernameRdn", "cn");
            this.tester.setFormElement("ldapUserFirstname", "givenName");
            this.tester.setFormElement("ldapUserLastname", "sn");
            this.tester.setFormElement("ldapUserDisplayname", "displayName");
            this.tester.setFormElement("ldapUserEmail", "mail");
            this.tester.setFormElement("ldapUserGroup", "memberOf");
            this.tester.setFormElement("ldapExternalId", "entryUUID");
        }
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent(this.ldapUtil.getInternalDirectoryName());
        this.tester.assertTextPresent("Delegating LDAP Directory");
    }

    private void deleteDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(1, 4).getLinkWith("Disable");
        this.navigation.clickLinkWithPost(link);
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Delegating LDAP Directory");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        link = userDirectoryTable.getTableCell(1, 4).getLinkWith("Remove");
        this.navigation.clickLinkWithPost(link);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "Delegating LDAP Directory");
    }

    private void disableLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        Assert.assertTrue((boolean)userDirectoryTable.getTableCell(1, 1).asText().contains("LDAP Directory"));
        WebLink link = userDirectoryTable.getTableCell(1, 3).getLinkWith("Move Down");
        this.navigation.clickLinkWithPost(link);
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(2).hasEnableEditRemoveSynchroniseOperations();
    }

    private void enableLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        Assert.assertTrue((boolean)userDirectoryTable.getTableCell(2, 1).asText().contains("LDAP Directory"));
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Enable");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        Assert.assertTrue((boolean)userDirectoryTable.getTableCell(2, 1).asText().contains("LDAP Directory"));
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("Move Up");
        this.navigation.clickLinkWithPost(link);
    }
}

