/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.NodeLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Assert;
import org.w3c.dom.Node;

public class UserDirectoryTable {
    private final WebTable table;
    private final Assertions assertions;
    private final FuncTestLogger logger;

    public static WebTable getDirectoryListTable(WebTester tester) {
        return new TableLocator(tester, "directory-list").getTable();
    }

    public static WebLink getDirectoryListActionLink(WebTester tester, int row, String actionText) {
        return UserDirectoryTable.getDirectoryListTable(tester).getTableCell(row, 4).getLinkWith(actionText);
    }

    public UserDirectoryTable(BaseJiraFuncTest funcTestCase, FuncTestLogger logger, Assertions assertions) {
        this(funcTestCase.getTester(), logger, assertions);
    }

    public UserDirectoryTable(WebTester tester, FuncTestLogger logger, Assertions assertions) {
        this.logger = logger;
        this.table = UserDirectoryTable.getDirectoryListTable(tester);
        this.assertions = assertions;
        this.checkTheHeaderRow(assertions);
    }

    private void checkTheHeaderRow(Assertions assertions) {
        assertions.getTableAssertions().assertTableRowEqualsCollapsed(this.table, 0, new String[]{"ID", "Directory Name", "Type", "Order", "Operations"});
    }

    public TableCell getTableCell(int row, int column) {
        return this.table.getTableCell(row, column);
    }

    public RowAssertions assertRow(int rowNum) {
        return new RowAssertions(rowNum);
    }

    public class RowAssertions {
        private int rowNum;

        public RowAssertions(int rowNum) {
            this.rowNum = rowNum;
        }

        public RowAssertions contains(String id, String name, String type) {
            UserDirectoryTable.this.assertions.getTableAssertions().assertTableRowEqualsCollapsed(UserDirectoryTable.this.table, this.rowNum, new String[]{id, null, type, null, null});
            UserDirectoryTable.this.assertions.getTableAssertions().assertTableCellHasText(UserDirectoryTable.this.table, this.rowNum, 1, name);
            return this;
        }

        public RowAssertions hasMoveUp(boolean enabled) {
            Node cellNode = UserDirectoryTable.this.table.getTableCell(this.rowNum, 3).getDOM();
            String cellText = new NodeLocator(cellNode).getHTML();
            boolean containsArrow = cellText.contains("<SPAN class=\"aui-icon aui-icon-small aui-iconfont-up icon-default icon-move-up\">Move Up</SPAN>");
            if (enabled) {
                Assert.assertTrue((String)("Enabled Move Up button expected. Found '" + cellText + "'"), (boolean)containsArrow);
            } else {
                Assert.assertFalse((String)("No Move Up button expected. Found '" + cellText + "'"), (boolean)containsArrow);
            }
            return this;
        }

        public RowAssertions hasMoveDown(boolean enabled) {
            Node cellNode = UserDirectoryTable.this.table.getTableCell(this.rowNum, 3).getDOM();
            String cellText = new NodeLocator(cellNode).getHTML();
            boolean containsArrow = cellText.contains("<SPAN class=\"aui-icon aui-icon-small aui-iconfont-down icon-default icon-move-down\">Move Down</SPAN>");
            if (enabled) {
                Assert.assertTrue((String)("Enabled Move Down button expected. Found '" + cellText + "'"), (boolean)containsArrow);
            } else {
                Assert.assertFalse((String)("No Move Down button expected. Found '" + cellText + "'"), (boolean)containsArrow);
            }
            return this;
        }

        public void hasOnlyEditOperation() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
        }

        public void hasDisableEditOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Disable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Disable"));
            Assert.assertFalse((String)"Enable operation found but not expected.", (boolean)cellText.contains("Enable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertFalse((String)"Synchronise operation found but not expected.", (boolean)cellText.contains("Synchronise"));
        }

        public void hasDisableEditSynchroniseOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Disable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Disable"));
            Assert.assertFalse((String)"Enable operation found but not expected.", (boolean)cellText.contains("Enable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            this.hasSynchroniseOperationOrIsSynchronising();
        }

        public void hasEnableEditRemoveSynchroniseOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Enable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Enable"));
            Assert.assertFalse((String)"Disable operation found but not expected.", (boolean)cellText.contains("Disable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertTrue((String)("Remove operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Remove"));
            this.hasSynchroniseOperationOrIsSynchronising();
        }

        public void hasEnableEditRemoveOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Enable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Enable"));
            Assert.assertFalse((String)"Disable operation found but not expected.", (boolean)cellText.contains("Disable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertTrue((String)("Remove operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Remove"));
            Assert.assertFalse((String)"Synchronise operation found but not expected.", (boolean)cellText.contains("Synchronise"));
        }

        private void hasSynchroniseOperationOrIsSynchronising() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            if (cellText.contains("Synchronising for")) {
                UserDirectoryTable.this.logger.log((Object)"The user directory is already synchronising.");
            } else {
                Assert.assertTrue((String)("Synchronise operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Synchronise"));
            }
        }
    }
}

