/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.rest.v2.issue.GroupBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.user.UsersPageBean;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class GroupClient
extends RestApiClient<GroupClient> {
    public static final String GROUP_RESOURCE = "group";
    private static final String GROUP_ADD_USER_RESOURCE = "group/user";
    public static final String GROUP_NAME = "groupname";
    public static final String USER_NAME = "username";
    public static final String NAME = "name";
    private final Set<Response> responses = Sets.newHashSet();

    public GroupClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    public GroupBean toGroupBean(Response response) {
        return (GroupBean)this.toResponse((RestApiClient.RestCall)(RestApiClient.RestCall)LambdaMetafactory.metafactory(null, null, null, ()Ljavax/ws/rs/core/Response;, lambda$toGroupBean$0(javax.ws.rs.core.Response ), ()Ljavax/ws/rs/core/Response;)((Response)response), GroupBean.class).body;
    }

    public Response createGroup(String groupName) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)NAME, (Object)groupName);
        return this.doPost(this.groupResource(), (ImmutableMap.Builder<Object, Object>)builder);
    }

    private WebTarget groupResource() {
        return this.createResource().path(GROUP_RESOURCE);
    }

    public Response getGroup(String group, @Nullable String expand) {
        WebTarget webResource = this.groupResource().queryParam(GROUP_NAME, new Object[]{group});
        if (expand != null) {
            webResource = webResource.queryParam("expand", new Object[]{expand});
        }
        Response response = (Response)webResource.request().get(Response.class);
        this.responses.add(response);
        return response;
    }

    public Response getGroup(String group) {
        return this.getGroup(group, null);
    }

    public GroupBean getGroupBean(String group) {
        return this.toGroupBean(this.getGroup(group, null));
    }

    public GroupBean getGroupBean(String group, String expand) {
        return this.toGroupBean(this.getGroup(group, expand));
    }

    public Response deleteGroup(String group) {
        WebTarget webResource = this.groupResource().queryParam(GROUP_NAME, new Object[]{group});
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return this.doDelete(webResource, (ImmutableMap.Builder<Object, Object>)builder);
    }

    public Response addUserToGroup(String group, String user) {
        WebTarget webResource = this.createResource().path(GROUP_ADD_USER_RESOURCE).queryParam(GROUP_NAME, new Object[]{group});
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)NAME, (Object)user);
        return this.doPost(webResource, (ImmutableMap.Builder<Object, Object>)builder);
    }

    public Response removeUserFromGroup(String group, String user) {
        WebTarget webResource = this.createResource().path(GROUP_ADD_USER_RESOURCE).queryParam(GROUP_NAME, new Object[]{group}).queryParam(USER_NAME, new Object[]{user});
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return this.doDelete(webResource, (ImmutableMap.Builder<Object, Object>)builder);
    }

    private Response doPost(WebTarget webResource, ImmutableMap.Builder<Object, Object> builder) {
        Response response = (Response)webResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)builder.build()), Response.class);
        this.responses.add(response);
        return response;
    }

    private Response doDelete(WebTarget webResource, ImmutableMap.Builder<Object, Object> builder) {
        Response response = (Response)webResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)builder.build()), Response.class);
        this.responses.add(response);
        return response;
    }

    public UsersPageBean getPaginatedUsersForGroup(String group, Boolean includeInactiveUsers, Long startAt, Long maxResults) {
        return (UsersPageBean)((Object)this.groupResource().path("member").queryParam(GROUP_NAME, new Object[]{group}).queryParam("includeInactiveUsers", new Object[]{includeInactiveUsers.toString()}).queryParam("startAt", new Object[]{startAt.toString()}).queryParam("maxResults", new Object[]{maxResults.toString()}).request().get(UsersPageBean.class));
    }

    public UsersPageBean getNextPage(UsersPageBean usersPageBean) {
        if (usersPageBean.getIsLast().booleanValue()) {
            throw new IllegalStateException("Cannot retrieve next page as this is already the last page");
        }
        try {
            return (UsersPageBean)((Object)this.resourceRoot(usersPageBean.getNextPage().toURL().toExternalForm()).request().get(UsersPageBean.class));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        for (Response response : this.responses) {
            response.close();
        }
    }

    private static /* synthetic */ Response lambda$toGroupBean$0(Response response) {
        return response;
    }
}

