/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestAutoWatches
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testAutowatchIsEnabledByDefault() throws Exception {
        String key = this.createIssueAndGotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(key);
    }

    @Test
    public void testAutowatchDisabledInUserSettings() throws Exception {
        this.setUserAutoWatchValue(false);
        this.createIssueAndGotoWatched();
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    public void testAutowatchDisabledGlobally() {
        this.setGlobalAutoWatchValue(false);
        this.navigation.issue().createIssue("homosapien", null, "I am not watching this");
        this.createIssueAndGotoWatched();
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    public void testCommentIssueWithAutowatchDisabled() {
        this.setGlobalAutoWatchValue(false);
        String key = this.navigation.issue().createIssue("homosapien", null, "Not watching this issue");
        this.navigation.issue().addComment(key, "I have autowatch disabled, i wouldn't like to watch this");
        this.gotoWatched();
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    public void testCommentIssueWithAutowatchEnabled() {
        this.setGlobalAutoWatchValue(false);
        String key = this.navigation.issue().createIssue("homosapien", null, "Not watching this issue");
        this.gotoWatched();
        this.tester.assertElementNotPresent("issuetable");
        this.setGlobalAutoWatchValue(true);
        this.navigation.issue().addComment(key, "Autowatch settings has changed, i am watching this issue after this comment");
        this.gotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(key);
    }

    @Test
    public void testAutowatchEnabledGloballyDisabedAtUserProfile() {
        this.setGlobalAutoWatchValue(true);
        this.setUserAutoWatchValue(false);
        this.createIssueAndGotoWatched();
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    public void testAutowatchReturnedToGlobalEnabledSettings() {
        this.setGlobalAutoWatchValue(true);
        this.setUserAutoWatchValue(true);
        String key = this.createIssueAndGotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(key);
        this.setUserAutoWatchValue(null);
        String secondIssueKey = this.navigation.issue().createIssue("homosapien", null, "Second test bug");
        this.gotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(secondIssueKey, key);
    }

    @Test
    public void testAutowatchReturnedToGlobalDisabledSettings() {
        this.setGlobalAutoWatchValue(false);
        this.setUserAutoWatchValue(true);
        String key = this.createIssueAndGotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(key);
        this.setUserAutoWatchValue(null);
        this.navigation.issue().createIssue("homosapien", null, "Second test bug");
        this.gotoWatched();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(key);
    }

    private String createIssueAndGotoWatched() {
        String key = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.gotoWatched();
        return key;
    }

    private void gotoWatched() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.clickLink("watched");
    }

    private void setGlobalAutoWatchValue(boolean autoWatchValue) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DEFAULTS);
        this.tester.clickLink("user-defaults-edit");
        this.tester.setWorkingForm("edit_user_defaults");
        if (autoWatchValue) {
            this.tester.checkCheckbox("autoWatch", "true");
        } else {
            this.tester.uncheckCheckbox("autoWatch");
        }
        this.tester.submit();
    }

    private void setUserAutoWatchValue(Boolean autoWatchValue) {
        this.backdoor.userProfile().changeUserAutoWatch(autoWatchValue, "admin");
    }
}

