/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.permission.GlobalPermissionKey;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestEditUserGroups
extends BaseJiraFuncTest {
    public static final String ERROR_LEAVING_ALL_ADMIN_GROUPS = "You are trying to leave all of the administration groups jira-administrators. You cannot delete your own administration permission";
    public static final String ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS = "You are trying to leave all of the system administration groups jira-administrators. You cannot delete your own system administration permission";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Test
    @RestoreBlankInstance
    public void testEditUserGroupsJoinAndLeaveAtSameTime() throws SAXException {
        this.navigateToUser("admin");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToLeave", "jira-developers");
        this.tester.submit("leave");
        this.tester.assertRadioOptionValuePresent("groupsToLeave", "jira-administrators");
        this.tester.assertRadioOptionValuePresent("groupsToLeave", "jira-users");
        this.tester.selectOption("groupsToLeave", "jira-users");
        FormParameterUtil form = new FormParameterUtil(this.tester, "user-edit-groups", "join");
        form.addOptionToHtmlSelect("groupsToJoin", new String[]{"jira-developers"});
        form.setFormElement("groupsToJoin", "jira-developers");
        form.submitForm();
        this.tester.getDialog().hasRadioOptionValue("groupsToLeave", "jira-developers");
        this.tester.getDialog().hasRadioOptionValue("groupsToLeave", "jira-administrators");
        this.tester.getDialog().hasRadioOptionValue("groupsToLeave", "jira-users");
    }

    @Test
    @RestoreBlankInstance
    public void testEditUserGroupsRemoveLastSysAdminGroup() {
        this.navigateToUser("admin");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToLeave", "jira-administrators");
        this.tester.submit("leave");
        this.tester.assertTextPresent(ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS);
        this.tester.assertRadioOptionValuePresent("groupsToLeave", "jira-administrators");
    }

    @Test
    @RestoreBlankInstance
    public void testEditUserGroupsRemoveSysAdminGroupWithAnotherPresent() {
        this.administration.usersAndGroups().addGroup("sys-admin-group2");
        this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, "sys-admin-group2");
        this.administration.usersAndGroups().addUserToGroup("admin", "sys-admin-group2");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    public void testEditUserGroupsWithNoSysAdminPermRemoveLastAdmin() {
        try {
            this.navigateToUser("admin");
            this.tester.clickLink("editgroups_link");
            this.tester.selectOption("groupsToLeave", "jira-administrators");
            this.tester.submit("leave");
            this.tester.assertTextPresent(ERROR_LEAVING_ALL_ADMIN_GROUPS);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    public void testEditUserGroupsWithNoSysAdminPermRemoveAdmin() {
        try {
            this.administration.usersAndGroups().addGroup("admin-group2");
            this.administration.addGlobalPermission(GlobalPermissionKey.ADMINISTER, "admin-group2");
            this.administration.usersAndGroups().addUserToGroup("admin", "admin-group2");
            this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
            Assert.assertFalse((boolean)this.tester.getDialog().hasRadioOptionValue("groupsToLeave", "jira-administrators"));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @LoginAs(user="root")
    public void testSysAdminEditGroups() {
        try {
            this.navigateToUser("admin");
            this.tester.clickLink("editgroups_link");
            this.tester.assertRadioOptionValueNotPresent("groupsToLeave", "jira-sys-admins");
            this.navigateToUser("root");
            this.tester.clickLink("editgroups_link");
            this.tester.assertRadioOptionValuePresent("groupsToLeave", "jira-sys-admins");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    public void testAdminEditGroups() {
        try {
            this.navigateToUser("admin");
            this.tester.clickLink("editgroups_link");
            Assert.assertFalse((boolean)this.tester.getDialog().hasRadioOptionValue("groupsToJoin", "jira-sys-admins"));
            this.tester.assertRadioOptionValueNotPresent("groupsToLeave", "jira-sys-admins");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-sys-admins&join=true"));
            this.tester.assertTextPresent("You cannot add users to groups which are not visible to you.");
            this.navigateToUser("root");
            this.tester.clickLink("editgroups_link");
            Assert.assertFalse((boolean)this.tester.getDialog().hasRadioOptionValue("groupsToJoin", "jira-sys-admins"));
            this.tester.assertRadioOptionValueNotPresent("groupsToLeave", "jira-sys-admins");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=root&groupsToLeave=jira-sys-admins&leave=true"));
            this.tester.assertTextPresent("You can not remove a group from this user as it is not visible to you.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @LoginAs(user="fred")
    public void testFredEditGroups() {
        try {
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-sys-admins&join=true"));
            this.tester.assertTextPresent("my login on this computer");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=root&groupsToLeave=jira-sys-admins&leave=true"));
            this.tester.assertTextPresent("my login on this computer");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @RestoreBlankInstance
    public void testEditGroupsUserDoesNotExist() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=foo&groupsToJoin=jira-developers&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("This user does not exist please select a user from the user browser.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=foo&groupsToLeave=jira-developers&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("This user does not exist please select a user from the user browser.");
    }

    @Test
    @RestoreBlankInstance
    public void testEditGroupsGroupDoesNotExist() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=invalid&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToLeave=invalid&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
    }

    @Test
    @RestoreBlankInstance
    public void testEditGroupsCanNotJoinAlreadyAMemeber() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-administrators&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot add user 'admin', user is already a member of 'jira-administrators'");
    }

    @Test
    @RestoreBlankInstance
    public void testEditGroupsCanNotLeaveNotAMemeber() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=fred&groupsToLeave=jira-administrators&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot remove user 'fred' from group 'jira-administrators' since user is not a member of 'jira-administrators'");
    }

    @Test
    @RestoreBlankInstance
    public void testEditGroupsMustSelectAGroup() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=fred"));
        this.tester.submit("join");
        this.tester.assertTextPresent("You must select at least one group to join.");
        this.tester.submit("leave");
        this.tester.assertTextPresent("You must select at least one group to leave.");
    }

    private void navigateToUser(String username) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink(username);
    }
}

