/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PageBeanMatcher;
import com.atlassian.jira.functest.matcher.UserJsonMatcher;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.restclient.GenericRestClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.atlassian.jira.webtests.ztests.user.GroupClient;
import com.atlassian.jira.webtests.ztests.user.UsersPageBean;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.USERS_AND_GROUPS})
@RestoreBlankInstance
public class TestGroupResourceFunc
extends BaseJiraFuncTest {
    private GroupClient groupClient;
    private GenericRestClient genericRestClient;

    @Before
    public void setup() {
        this.groupClient = new GroupClient(this.environmentData);
        this.genericRestClient = new GenericRestClient();
    }

    @After
    public void teardown() {
        this.groupClient.close();
    }

    @Test
    public void testGroupResourceAddAndRemoveUserHappyPath() {
        this.createGroup("jedi");
        this.ensureGroupExists("jedi");
        this.addUserToGroup("jedi", "fred");
        this.ensureCantAddUserToGroup("jedi", "fred");
        this.removeUserFromGroup("jedi", "fred");
        this.ensureCantRemoveUserFromGroup("jedi", "fred");
    }

    @Test
    public void testGroupResourceDeleteGroupHappyPath() {
        this.createGroup("jedi");
        this.ensureGroupExists("jedi");
        this.deleteGroup("jedi");
        this.ensureNoGroup("jedi");
        this.ensureCantDeleteGroup("jedi");
    }

    @Test
    public void testGettingUsersFromGroupPaginatedSelfAndNextPageLinks() {
        String groupname = "testGroup";
        this.backdoor.usersAndGroups().addGroup("testGroup");
        List<String> usernames = this.createUsersInGroup("testGroup", 3);
        UsersPageBean page1 = this.groupClient.getPaginatedUsersForGroup("testGroup", true, 0L, 2L);
        Assert.assertThat((String)"Self link is present on first page", (Object)page1.getSelf(), (Matcher)Matchers.notNullValue());
        UsersPageBean samePage1 = (UsersPageBean)((Object)this.genericRestClient.get((URI)page1.getSelf(), UsersPageBean.class).body);
        Assert.assertThat((String)"Self link gives same result for first page", (Object)samePage1.getValues(), (Matcher)Matchers.equalTo((Object)page1.getValues()));
        Assert.assertThat((String)"nextPage link is present on first page", (Object)page1.getNextPage(), (Matcher)Matchers.notNullValue());
        UsersPageBean page2 = (UsersPageBean)((Object)this.genericRestClient.get((URI)page1.getNextPage(), UsersPageBean.class).body);
        Assert.assertThat((String)"nextPage link finds last user on last page", (Object)page2.getValues(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{UserJsonMatcher.matcher((Matcher<String>)Matchers.is((Object)usernames.get(2)), (Matcher<Boolean>)Matchers.is((Object)true))}));
        Assert.assertThat((String)"Self link is present on last page", (Object)page2.getSelf(), (Matcher)Matchers.notNullValue());
        UsersPageBean samePage2 = (UsersPageBean)((Object)this.genericRestClient.get((URI)page2.getSelf(), UsersPageBean.class).body);
        Assert.assertThat((String)"Self link gives same result for last page", (Object)samePage2.getValues(), (Matcher)Matchers.equalTo((Object)page2.getValues()));
        Assert.assertThat((String)"nextPage link is NOT present on last page", (Object)page2.getNextPage(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGettingUsersFromGroupPaginated() {
        String groupname = "testGroup";
        this.backdoor.usersAndGroups().addGroup(groupname);
        List<String> usernames = this.createUsersInGroup(groupname, 100);
        this.assertGetPage(0, 10, 100, usernames, groupname, false);
        this.assertGetPage(0, 20, 100, usernames, groupname, false);
        this.assertGetPage(10, 10, 100, usernames, groupname, false);
        this.assertGetPage(10, 10, 100, usernames, groupname, true);
        UserDTO userToDeactive = this.backdoor.usersAndGroups().getUserByName("0testuser");
        this.backdoor.usersAndGroups().updateUser(new UserDTO(false, userToDeactive.getDirectoryId(), userToDeactive.getDisplayName(), userToDeactive.getEmail(), userToDeactive.getKey(), userToDeactive.getName(), userToDeactive.getUsername(), Long.valueOf(userToDeactive.getId())));
        Assert.assertThat((Object)this.groupClient.getPaginatedUsersForGroup(groupname, true, 0L, 1L).getValues(), (Matcher)Matchers.contains(UserJsonMatcher.matcher((Matcher<String>)Matchers.is((Object)"0testuser"), (Matcher<Boolean>)Matchers.is((Object)false))));
    }

    @Test
    public void testGettingPaginatedUsersFromGroupForNotExistingGroupReturnsNotFound() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.groupClient.getPaginatedUsersForGroup("not_existing_group", false, 0L, 2L);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testGettingPaginatedUsersWithoutPermissionsReturnsForbidden() {
        String groupName = "new_group";
        this.backdoor.usersAndGroups().addGroup(groupName);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.backdoor.usersAndGroups().addUser("not_admin");
            ((GroupClient)this.groupClient.loginAs("not_admin", "not_admin")).getPaginatedUsersForGroup(groupName, false, 0L, 2L);
            return null;
        }, Response.Status.FORBIDDEN);
    }

    @Test
    public void testGettingPaginatesUsersAnonymouslyReturnsUnathorized() {
        String groupName = "new_group";
        this.backdoor.usersAndGroups().addGroup(groupName);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((GroupClient)this.groupClient.anonymous()).getPaginatedUsersForGroup(groupName, false, 0L, 2L);
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testGettingPaginatesUsersWithIllegalGroupNameReturnsBadRequest() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.groupClient.getPaginatedUsersForGroup("", false, 0L, 2L);
            return null;
        }, Response.Status.BAD_REQUEST);
    }

    private void assertGetPage(int startAt, int maxResults, int total, List<String> usernames, String groupname, boolean includeInactive) {
        UsersPageBean usersForGroup = this.groupClient.getPaginatedUsersForGroup(groupname, includeInactive, Long.valueOf(startAt), Long.valueOf(maxResults));
        List matchers = usernames.stream().skip(startAt).limit(maxResults).map(username -> UserJsonMatcher.matcher((Matcher<String>)Matchers.is((Object)username), (Matcher<Boolean>)Matchers.is((Object)true))).collect(Collectors.toList());
        Assert.assertThat((Object)((Object)usersForGroup), PageBeanMatcher.matcher((Matcher<Long>)Matchers.is((Object)startAt), (Matcher<Long>)Matchers.is((Object)total), (Matcher<Integer>)Matchers.is((Object)maxResults), Matchers.contains(matchers)));
    }

    private List<String> createUsernames(IntStream range) {
        return range.mapToObj(index -> index + "testuser").sorted(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        }).collect(Collectors.toList());
    }

    private List<String> createUsersInGroup(String groupName, int count) {
        List<String> userNames = this.createUsernames(IntStream.range(0, count));
        userNames.forEach(username -> {
            this.backdoor.usersAndGroups().addUser(username, username, username, username + "@atlassian.com", false);
            this.backdoor.usersAndGroups().addUserToGroup(username, groupName);
        });
        return userNames;
    }

    private void ensureCantRemoveUserFromGroup(String group, String user) {
        Response response = this.groupClient.removeUserFromGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        response.close();
    }

    private void ensureGroupExists(String group) {
        Response response = this.groupClient.getGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }

    private void ensureNoGroup(String group) {
        Response response = this.groupClient.getGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void createGroup(String group) {
        Response response = this.groupClient.createGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)response.getStringHeaders().get((Object)"Location")).get(0);
        String expectedUrl = this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=" + group;
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)expectedUrl));
        response.close();
    }

    private void addUserToGroup(String group, String user) {
        Response response = this.groupClient.addUserToGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)response.getStringHeaders().get((Object)"Location")).get(0);
        String expectedUrl = this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=" + group;
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)expectedUrl));
        response.close();
    }

    private void ensureCantAddUserToGroup(String group, String user) {
        Response response = this.groupClient.addUserToGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        response.close();
    }

    private void deleteGroup(String group) {
        Response response = this.groupClient.deleteGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }

    private void ensureCantDeleteGroup(String group) {
        Response response = this.groupClient.deleteGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void removeUserFromGroup(String group, String user) {
        Response response = this.groupClient.removeUserFromGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }
}

