/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestGroupSelector
extends BaseJiraFuncTest {
    public static final String GROUP_PICKER_CF_NAME = "mypickerofgroups";
    public static final String INVALID_GROUP_NAME = "invalid_group_name";
    public static final String ISSUE_SUMMARY = "This is my summary";
    private String groupPickerId = null;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.groupPickerId = this.backdoor.customFields().createCustomField(GROUP_PICKER_CF_NAME, "", CustomFields.builtInCustomFieldKey("grouppicker"), CustomFields.builtInCustomFieldKey("grouppickersearcher"));
        this.backdoor.screens().addFieldToScreen("Default Screen", GROUP_PICKER_CF_NAME);
    }

    @Test
    public void testCreateIssueWithGroupPicker() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", ISSUE_SUMMARY);
        this.tester.assertLinkPresent(this.groupPickerId + "-trigger");
        this.tester.setFormElement(this.groupPickerId, INVALID_GROUP_NAME);
        this.tester.submit("Create");
        this.textAssertions.assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.tester.setFormElement(this.groupPickerId, "jira-users");
        this.tester.submit("Create");
        this.textAssertions.assertTextPresent(this.locator.page(), ISSUE_SUMMARY);
        this.textAssertions.assertTextPresent(this.locator.page(), GROUP_PICKER_CF_NAME);
        this.tester.assertTextPresent("jira-users");
    }
}

