/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestNonExistentUsers
extends BaseJiraFuncTest {
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    @Restore(value="TestNullAssigneeAndReporter.xml")
    public void testNullReporterAndAssignee() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertViewIssueAssigneeAndReporter("AA-1", "Unassigned", "Anonymous");
        this.assertViewIssueAssigneeAndReporter("AA-2", "Unassigned", "admin");
        this.assertViewIssueAssigneeAndReporter("AA-3", "admin", "Anonymous");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertNavigatorAssigneeAndReporter(1, "AA-3", "admin", "Anonymous");
        this.assertNavigatorAssigneeAndReporter(2, "AA-2", "Unassigned", "admin");
        this.assertNavigatorAssigneeAndReporter(3, "AA-1", "Unassigned", "Anonymous");
    }

    @Test
    @Restore(value="TestNonExistentUsersNoFullname.xml")
    public void testUserWithNoFullName() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "admin");
        this.assertions.assertProfileLinkPresent("reporter_admin", "admin");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "admin");
    }

    private void assertNavigatorAssigneeAndReporter(int row, String issueKey, String assigneeName, String reporterName) {
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 1), issueKey);
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 3), assigneeName);
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 4), reporterName);
    }

    private void assertViewIssueAssigneeAndReporter(String issueKey, String assigneeName, String reporterName) {
        this.navigation.issue().viewIssue(issueKey);
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "assignee-val"), assigneeName, new String[0]);
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "reporter-val"), reporterName, new String[0]);
    }
}

