/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.SlowTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestUserBrowser
extends BaseJiraFuncTest {
    private static final List<String> EVERYONE = Arrays.asList("admin", "anteater", "antoinette", "anton", "antone", "barney", "detkin");
    private static final String USER_SEARCH_FILTER = "userSearchFilter";
    private static final String GROUP_FILTER = "group";
    private static final String MAX = "max";

    @Test
    public void testFindByFiltering() {
        this.backdoor.restoreDataFromResource("TestUserBrowser.xml");
        this.navigation.login("admin", "admin");
        this.gotoUserBrowser();
        this.resetAll();
        this.assertUserNameColumn(EVERYONE);
        this.filterBy(USER_SEARCH_FILTER, "ant");
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone"));
        this.filterBy(USER_SEARCH_FILTER, "anto");
        this.assertUserNameColumn(Arrays.asList("antoinette", "anton", "antone"));
        this.filterBy(USER_SEARCH_FILTER, "e@");
        this.assertUserNameColumn(Arrays.asList("antoinette", "antone"));
        this.resetFilterBy(USER_SEARCH_FILTER);
        this.assertUserNameColumn(EVERYONE);
        this.filterBy(USER_SEARCH_FILTER, "Etkin");
        this.assertUserNameColumn(Arrays.asList("detkin"));
        this.resetFilterBy(USER_SEARCH_FILTER);
        this.filterBy(USER_SEARCH_FILTER, "d");
        this.assertUserNameColumn(Arrays.asList("admin", "detkin"));
        this.filterBy(USER_SEARCH_FILTER, "atlassian");
        this.assertUserNameColumn(Arrays.asList("admin", "detkin"));
    }

    @Test
    public void testPaging() {
        this.backdoor.restoreDataFromResource("TestUserBrowserManyUsers.xml");
        this.navigation.login("admin", "admin");
        this.gotoUserBrowser();
        this.resetAll();
        this.filterBy(MAX, "10");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 2)));
        this.filterBy(MAX, "20");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 12)));
        this.filterBy(MAX, "50");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 42)));
        this.filterBy(MAX, "100");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 92)));
        this.filterBy(MAX, "All");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 120)));
        this.resetAll();
        this.filterBy(USER_SEARCH_FILTER, "username");
        this.assertUserNameColumn(this.userList(0, 19));
        this.gotoNext();
        this.assertUserNameColumn(this.userList(20, 39));
        this.gotoPrev();
        this.assertUserNameColumn(this.userList(0, 19));
        this.gotoNext();
        this.gotoNext();
        this.assertUserNameColumn(this.userList(40, 59));
        this.gotoPrev();
        this.assertUserNameColumn(this.userList(20, 39));
        this.resetAll();
        this.filterBy(USER_SEARCH_FILTER, "odd");
        this.assertUserNameColumn(this.userListBy2(1, 39));
        this.gotoNext();
        this.assertUserNameColumn(this.userListBy2(41, 79));
        this.gotoNext();
        this.assertUserNameColumn(this.userListBy2(81, 119));
        this.gotoPrev();
        this.assertUserNameColumn(this.userListBy2(41, 79));
        this.gotoPrev();
        this.assertUserNameColumn(this.userListBy2(1, 39));
    }

    @Test
    public void testCreatedUser() {
        this.backdoor.restoreDataFromResource("TestUserBrowserManyUsers.xml");
        this.navigation.login("admin", "admin");
        this.gotoUserBrowser();
        this.resetAll();
        this.filterBy(USER_SEARCH_FILTER, "ant");
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone"));
        this.tester.gotoPage("secure/admin/user/UserBrowser.jspa?createdUser=username069&createdUser=username070&createdUser=username069");
        this.assertUserNameColumn(Arrays.asList("username069", "username070", "admin", "anteater", "antoinette", "anton", "antone", "barney"));
    }

    @Test
    @SlowTest
    public void testFilteringByGroupWorksForLargeGroups() {
        this.backdoor.restoreDataFromResource("TestUserBrowser35kUsersTwoDirectories.xml");
        this.navigation.login("admin", "admin");
        this.gotoUserBrowser("jira-servicedesk-users");
        Assert.assertThat((Object)new XPathLocator(this.tester, "//table[@id='user_browser_table']/tbody/tr").getNodes().length, (Matcher)Matchers.equalTo((Object)20));
    }

    private void gotoPrev() {
        this.tester.clickLinkWithText("<< Previous");
    }

    private void gotoNext() {
        this.tester.clickLinkWithText("Next >>");
    }

    private List<String> userList(int startI, int endI) {
        return this.userListBy(startI, endI, 1);
    }

    private List<String> userListBy2(int startI, int endI) {
        return this.userListBy(startI, endI, 2);
    }

    private List<String> userListBy(int startI, int endI, int by) {
        ArrayList<String> users = new ArrayList<String>();
        for (int i = startI; i <= endI; i += by) {
            String padNum = StringUtils.leftPad((String)String.valueOf(i), (int)3, (char)'0');
            users.add("username" + padNum);
        }
        return users;
    }

    private List<String> asList(List<String> ... lists) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<String> args : lists) {
            list.addAll(args);
        }
        return list;
    }

    private void assertUserNameColumn(List<String> values) {
        this.assertColumnImpl(2, 1, values);
    }

    private void assertColumnImpl(int col, int startRow, List<String> values) {
        int row = startRow;
        for (String value : values) {
            XPathLocator locator = new XPathLocator(this.tester, "//table[@id='user_browser_table']//tr[" + row + "]/td[" + col + "]/div/span");
            Assert.assertEquals((String)("Asserting user browser row[" + row + "] col[" + col + "]"), (Object)value, (Object)locator.getText());
            ++row;
        }
    }

    private void filterBy(String fieldName, String value) {
        if (MAX.equals(fieldName)) {
            this.tester.selectOption(fieldName, value);
        } else {
            this.tester.setFormElement(fieldName, value);
        }
        this.tester.submit("");
    }

    private void resetAll() {
        this.resetFilterBy(USER_SEARCH_FILTER);
        this.filterBy(MAX, "20");
    }

    private void resetFilterBy(String fieldName) {
        this.tester.setFormElement(fieldName, "");
        this.tester.submit("");
    }

    private void gotoUserBrowser() {
        this.tester.gotoPage("secure/admin/user/UserBrowser.jspa");
    }

    private void gotoUserBrowser(String group) {
        this.tester.gotoPage(String.format("secure/admin/user/UserBrowser.jspa?group=%s", group));
    }
}

