/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserFormat
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @After
    public void tearDown() {
        this.administration.backdoor().darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @Test
    public void testAnonymous() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "Administrator");
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS);
        this.navigation.logout();
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My second anoymous test comment");
        this.tester.submit();
        this.tester.assertLinkNotPresent("Anonymous");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Anonymous", "added a comment");
    }

    @Test
    public void testCommentPanel() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_COMMENTS);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("edit_comment_10000");
        this.tester.setWorkingForm("comment-edit");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.tester.setFormElement("comment", "My first test comment edited...");
        try {
            Thread.sleep(1001L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tester.submit("Save");
        this.tester.clickLink("edit_comment_10000");
        this.tester.setWorkingForm("comment-edit");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("delete_comment_10000");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
    }

    @Test
    public void testViewProjects() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
    }

    @Test
    public void testViewVoters() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("toggle-vote-issue");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("view-voters");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }

    @Test
    public void testFullProfileIsSafeFromXSS() {
        this.tester.gotoPage("/secure/EditProfile!default.jspa?username=admin");
        this.tester.setFormElement("fullName", "admin \"<script>alert('owned')</script>\"");
        this.tester.setFormElement("email", "\"<script>alert('owned')</script>\"@localhost");
        this.tester.setFormElement("password", "admin");
        this.tester.submit();
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        boolean condition3 = this.tester.getDialog().getResponseText().indexOf("User Profile: admin &quot;&lt;script&gt;alert(&#39;owned&#39;)&lt;/script&gt;&quot;") != -1;
        Assert.assertTrue((boolean)condition3);
        boolean condition2 = this.tester.getDialog().getResponseText().indexOf("User Profile: admin \"<script>alert(&#39;owned&#39;)</script>\"") == -1;
        Assert.assertTrue((boolean)condition2);
        boolean condition1 = this.tester.getDialog().getResponseText().indexOf("mailto:&quot;&lt;script&gt;alert(&#39;owned&#39;)&lt;/script&gt;&quot;") != -1;
        Assert.assertTrue((boolean)condition1);
        boolean condition = this.tester.getDialog().getResponseText().indexOf("mailto:\"<script>alert('owned')</script>\"") == -1;
        Assert.assertTrue((boolean)condition);
    }

    @Test
    public void testIssueSummary() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.tester.clickLink("assign-issue");
            this.tester.selectOption("assignee", "Fred Normal");
            this.tester.submit("Assign");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.assertions.assertNodeByIdHasText("issue_summary_assignee_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("issue_summary_reporter_admin", "Administrator");
    }

    @Test
    public void testColumnView() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    @Test
    public void testColumnViewUnAssigned() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("allowUnassigned", "true");
        this.tester.submit("Update");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Unassigned bug");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.submit("Create");
        this.navigation.issueNavigator().displayAllIssues();
        WebLink link = this.tester.getDialog().getResponse().getLinkWithID("assignee_admin");
        Assert.assertNull((Object)link);
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 3), "Unassigned");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    @Test
    public void testIssueWatchers() {
        this.navigation.userProfile().changeAutowatch(false);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("toggle-watch-issue");
        this.tester.clickLink("manage-watchers");
        this.assertions.assertProfileLinkPresent("watcher_link_admin", "Administrator");
    }

    @Test
    public void testCustomFields() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Single User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Multi User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.setFormElement("customfield_10001", "admin, fred");
        this.tester.submit("Update");
        this.assertions.assertNodeByIdHasText("user_cf_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("multiuser_cf_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("multiuser_cf_admin", "Administrator");
    }

    @Test
    public void testActionHeaders() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.clickButton("log-work-submit");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "First test bug really");
        this.tester.submit("Update");
        this.tester.gotoPage("/browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "Administrator");
        this.assertions.assertProfileLinkPresent("changehistoryauthor_10000", "Administrator");
        this.assertions.assertProfileLinkPresent("changehistoryauthor_10001", "Administrator");
        this.assertions.assertProfileLinkPresent("worklogauthor_10000", "Administrator");
    }

    @Test
    public void testDeveloperWorkloadReport() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.clickButton("log-work-submit");
        this.navigation.runReport(10000L, "com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.submit("Next");
        this.assertions.assertProfileLinkPresent("dev_wl_report_admin", "Administrator");
    }

    @Test
    @Restore(value="TestFormatUserDifferentUsersInIterator.xml")
    public void testDifferentUsersInIterator() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("view_MKY_projects_fred", "Fred Normal");
        this.tester.gotoPage("/secure/ViewVoters!default.jspa?id=10001");
        this.assertions.assertProfileLinkPresent("voter_link_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }
}

