/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
@Restore(value="TestWebFragment.xml")
public class TestUserNavigationBarWebFragment
extends BaseJiraFuncTest {
    private static final String BACK_TO_PREVIOUS_VIEW = "Back to previous view";
    private static final String ISSUE_SUMMARY = "test printable";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @After
    public void tearDownTest() {
        this.navigation.login("admin", "admin");
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testUserNavigationBarWebFragment() {
        this._testLinkVisibilityWhileLoggedIn();
        this._testLinkVisibilityWhileNotLoggedIn();
    }

    @Test
    public void testPrintableViewLink() {
        this.navigation.login("admin", "admin");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", ISSUE_SUMMARY);
        this.navigation.issue().viewIssue(issueKey);
        this.tester.assertTextPresent("Details");
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.gotoPage("/si/jira.issueviews:issue-html/HSP-1/HSP-1.html");
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent("[" + issueKey + "]");
        this.tester.assertLinkPresentWithText(ISSUE_SUMMARY);
        this.tester.gotoPage("/issues/?jql=ORDER BY issuekey DESC");
        this.tester.assertTextPresent("Issue Navigator");
        this.navigation.issueNavigator().displayPrintableAllIssues();
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent(issueKey);
        this.tester.assertTextPresent(ISSUE_SUMMARY);
        this.tester.gotoPage("/secure/views/securitybreach.jsp");
        this.tester.assertTextPresent("Access Denied");
        this.tester.gotoPage("/secure/views/securitybreach.jsp?decorator=printable");
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent("Access Denied");
    }

    private void _testLinkVisibilityWhileLoggedIn() {
        this.navigation.login("admin", "admin");
        this.tester.assertLinkNotPresentWithText("Log In");
        Assert.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        Assert.assertEquals((Object)"Administrator", (Object)this.navigation.userProfile().userName());
        this.tester.assertLinkPresentWithText("Profile");
        this.tester.assertLinkPresentWithText("About JIRA");
        this.tester.assertLinkPresentWithText("Log Out");
    }

    private void _testLinkVisibilityWhileNotLoggedIn() {
        this.navigation.logout();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresentWithText("Log In");
        this.tester.assertLinkNotPresentWithText("Log Out");
        Assert.assertFalse((boolean)this.navigation.userProfile().link().isPresent());
    }
}

