/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserProfile
extends BaseJiraFuncTest {
    private static final String XSS_ALERT_RAW = "\"alert('surprise!')";
    private static final String XSS_ALERT_ESCAPED = "&quot;alert(&#39;surprise!&#39;)";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testXssInAvatarPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        this.navigation.login(XSS_ALERT_RAW, "password");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    @Test
    public void testUrlPropertyRendersAsLink() {
        ImmutableList links = ImmutableList.of((Object)"http://www.atlassian.com/uniqueLinkForThisTest", (Object)"www.atlassian-func-tests.com");
        for (int i = 0; i < links.size(); ++i) {
            String link = (String)links.get(i);
            this.addUserProperty("homePage" + i, link);
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(link, link);
        }
    }

    @Test
    public void testBadUrlPropertyDoesNotRenderAsLink() {
        String linkUrl = "htp:/bad.url.com";
        this.addUserProperty("homePage", "htp:/bad.url.com");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.assertLinkNotPresentWithText("htp:/bad.url.com");
    }

    @Test
    @LoginAs(user="fred")
    public void testUserChangePassword() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.clickLinkWithText("Change Password");
        this.tester.setFormElement("current", "");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", "");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "The current password specified is incorrect.");
        this.textAssertions.assertTextPresent(this.locator.page(), "The new password cannot be blank.");
        this.tester.setFormElement("current", "invalid");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "mismatch");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "The current password specified is incorrect.");
        this.textAssertions.assertTextPresent(this.locator.page(), "The password and confirmation do not match.");
        String newPassword = "newpassword";
        this.tester.setFormElement("current", "fred");
        this.tester.setFormElement("password", "newpassword");
        this.tester.setFormElement("confirm", "newpassword");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "Your password has successfully been changed");
        this.navigation.logout();
        this.navigation.loginAttempt("fred", "fred");
        this.textAssertions.assertTextPresent(this.locator.page(), "Sorry, your username and password are incorrect - please try again.");
        this.navigation.login("fred", "newpassword");
        Assert.assertEquals((Object)"Fred Normal", (Object)this.navigation.userProfile().userName());
    }

    @Test
    @Restore(value="TestUserProfileI18n.xml")
    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.textAssertions.assertTextPresent(this.locator.id("up-p-locale"), "Deutsch (Deutschland) [Standard]");
        this.tester.clickLink("edit_prefs_lnk");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "Deutsch (Deutschland) [Standard]");
    }

    @Test
    @Restore(value="TestUserProfileI18n.xml")
    public void testShowsLanguageListInTheUsersLanguage() {
        try {
            this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
            this.navigation.login("fred");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.textAssertions.assertTextPresent(this.locator.id("up-p-locale"), "espa\u00f1ol (Espa\u00f1a)");
            this.tester.clickLink("edit_prefs_lnk");
            this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "espa\u00f1ol (Espa\u00f1a)");
        }
        finally {
            this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
        }
    }

    @Test
    public void testChangeUserProfileRequiresPassword() {
        String newFullName = "New FullName";
        String newEmail = "newemail@example.com";
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "wrongpassword");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "admin");
        this.textAssertions.assertTextSequence(this.locator.page(), "Profile", "New FullName", "Full name", "New FullName", "Email", "newemail@example.com");
    }

    @Test
    public void testWebItemsInOperationsProperlyStyled() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.assertTextPresent("Tools");
        Node node = this.locator.css(".reference-web-item-test-class").getNode();
        Assert.assertEquals((Object)node.getAttributes().getNamedItem("id").getNodeValue(), (Object)"com.atlassian.jira.dev.reference-plugin:reference-item-user-profile-operations");
    }

    private void updateUserProfileForm(String userName, String fullName, String email, String password) {
        this.tester.gotoPage("secure/EditProfile!default.jspa?username=" + userName);
        this.tester.setFormElement("fullName", fullName);
        this.tester.setFormElement("email", email);
        this.tester.setFormElement("password", password);
        this.tester.submit();
    }

    private void addUserProperty(String key, String value) {
        this.tester.gotoPage("/secure/admin/user/EditUserProperties.jspa?name=admin");
        this.tester.setFormElement("key", key);
        this.tester.setFormElement("value", value);
        this.tester.submit();
    }
}

