/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
@Restore(value="TestViewProfile.xml")
public class TestViewProfile
extends BaseJiraFuncTest {
    public static final String PROJECT_MONKEY = "monkey";
    public static final String PROJECT_HOMOSAP = "homosapien";
    private static final String LAST_LOGIN_TIME_ID = "up-d-last-login";
    private static final String LAST_FAILED_LOGIN_TIME_ID = "up-d-last-failed-login-time";
    private static final String CURRENT_FAILED_LOGIN_COUNT_ID = "up-d-current-failed-login-count";
    private static final String TIMESTAMP_PATTERN = "\\d{2}/[A-Z]{1}[a-z]{2}/\\d{2} \\d{1,2}:\\d{2} (AM|PM)";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testIssueNavigatorLinkEncoding() throws Exception {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=monkey%2Bman");
        this.textAssertions.assertTextNotPresent(this.tester.getDialog().getResponseText(), "= \"monkey+man\"");
        this.textAssertions.assertTextPresent(this.tester.getDialog().getResponseText(), "+%3D+%22monkey%2Bman%22");
    }

    @Test
    public void testAllBasicSectionsPresent() {
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("Details");
        this.tester.assertTextPresent("Preferences");
        this.tester.assertTextPresent("Groups");
    }

    @Test
    public void testEmailVisibility() {
        this.tester.clickLink("view_profile");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full name:", "Administrator", "Email:", "admin@example.com"});
        this.tester.assertLinkPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "hide");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full name:", "Administrator"});
        this.tester.assertTextNotPresent("Email:");
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "mask");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full name:", "Administrator", "Email:", "admin at example dot com"});
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "user");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full name:", "Administrator", "Email:", "admin@example.com"});
        this.tester.assertLinkPresentWithText("admin@example.com");
    }

    @Test
    public void testAllLinksShow() {
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile");
        this.tester.clickLink("admin_user");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_project_roles");
        Assert.assertThat((Object)this.locator.css(".aui-nav-breadcrumbs a").getNodes()[0].getNodeValue(), (Matcher)Matchers.equalTo((Object)"Users"));
        Assert.assertThat((Object)this.locator.css(".aui-nav-breadcrumbs a").getNodes()[1].getNodeValue(), (Matcher)Matchers.equalTo((Object)"Administrator"));
        Assert.assertThat((Object)this.locator.css(".aui-page-header h2").getText(), (Matcher)Matchers.equalTo((Object)"View Project Roles for User"));
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_change_password");
        this.tester.assertLinkNotPresent("view_change_password");
    }

    @Test
    public void testNotOwnProfile() {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
        this.tester.assertLinkPresent("view_profile");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertTextNotPresent("Reports");
        this.tester.assertLinkNotPresent("voted");
        this.tester.assertLinkNotPresent("watched");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkNotPresent("view_dashboard_config");
        this.tester.assertLinkNotPresent("view_manage_filters");
        this.tester.assertLinkNotPresent("edit_prefs_lnk");
        this.tester.assertLinkNotPresent("edit_profile_lnk");
    }

    @Test
    public void testNotLoggedIn() {
        try {
            this.navigation.logout();
            this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
            this.tester.assertTextPresent("You must log in to access this page.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testVotingDisabled() {
        this.setGlobalOption("voting", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("voted");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("edit_profile_lnk");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("watched");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    @Test
    public void testWatchingDisabled() {
        this.setGlobalOption("watching", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("watched");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("edit_profile_lnk");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("voted");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    @Test
    public void testUserNotAdmin() {
        try {
            this.navigation.login("fred", "fred");
            this.navigation.dashboard();
            this.tester.clickLink("view_profile");
            this.tester.assertLinkNotPresent("view_project_roles");
            this.tester.assertLinkNotPresent("admin_user");
            this.tester.assertLinkPresent("edit_profile_lnk");
            this.tester.assertLinkPresent("view_change_password");
            this.tester.assertLinkPresent("voted");
            this.tester.assertLinkPresent("watched");
            this.tester.assertLinkPresent("edit_prefs_lnk");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testExternalUserManagementEnabled() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("edit_profile_lnk");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("voted");
        this.tester.assertLinkPresent("watched");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    @Test
    public void testAssignedOpenIssuesReport() {
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertTextPresent("You have no open issues assigned to you");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "First issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().createIssue(PROJECT_MONKEY, "Bug", "Second issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"1", PROJECT_HOMOSAP, "1", PROJECT_MONKEY});
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"1", PROJECT_HOMOSAP, "1", PROJECT_MONKEY});
    }

    @Test
    public void testEditProfileFieldsExceed255() throws Exception {
        this.tester.gotoPage("secure/EditProfile!default.jspa?username=admin");
        String fullname = StringUtils.repeat((String)"ABCDEFGH", (int)32);
        String email = StringUtils.repeat((String)"x", (int)246) + "@email.com";
        this.tester.setFormElement("fullName", fullname);
        this.tester.setFormElement("email", email);
        this.tester.submit();
        this.tester.assertTextPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextPresent("The email address must not exceed 255 characters in length.");
        this.tester.setFormElement("fullName", fullname.substring(0, 255));
        this.tester.setFormElement("email", email.substring(0, 255));
        this.tester.submit();
        this.tester.assertTextNotPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextNotPresent("The email address must not exceed 255 characters in length.");
    }

    private void setGlobalOption(String optionName, String value) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("title", "jWebTest JIRA installation");
        this.tester.checkCheckbox(optionName, value);
        this.tester.submit("Update");
    }

    @Test
    public void testAdminLink() {
        this.tester.clickLink("view_profile");
        this.tester.clickLink("admin_user");
        this.assertions.assertNodeByIdHasText("username", "admin");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_project_roles");
        this.assertions.assertNodeByIdHasText("return_link", "Administrator");
        this.navigation.userProfile().gotoUserProfile("fred");
        this.tester.clickLink("admin_user");
        this.assertions.assertNodeByIdHasText("username", "fred");
        this.navigation.userProfile().gotoUserProfile("fred");
        this.tester.clickLink("view_project_roles");
        this.assertions.assertNodeByIdHasText("return_link", "Fred Normal");
    }

    @Test
    public void testLastLoginTimeVisibleToCurrentAdmin() {
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("Last login:");
        this.tester.assertTextPresent("Last failed login:");
        this.tester.assertTextPresent("Current failed logins:");
        this.tester.assertTextInElement(LAST_FAILED_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "0");
    }

    @Test
    public void testLastLoginTimeVisibleToCurrentNonAdmin() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("Last login:");
        this.tester.assertTextPresent("Last failed login:");
        this.tester.assertTextPresent("Current failed logins:");
        this.tester.assertTextInElement(LAST_FAILED_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "0");
    }

    @Test
    public void testLastLoginTimeIsTranslated() {
        try {
            this.administration.generalConfiguration().setJiraLocale("polski (Polska)");
            this.tester.clickLink("view_profile");
            this.tester.assertTextPresent("Ostatnie logowanie:");
            this.tester.assertTextPresent("Ostatnie logowanie nie powiod\u0142o si\u0119:");
            this.tester.assertTextPresent("Aktualne pr\u00f3by logowania zako\u0144czone niepowodzeniem:");
            this.tester.assertTextInElement(LAST_FAILED_LOGIN_TIME_ID, "Nigdy");
        }
        finally {
            this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
        }
    }

    @Test
    public void testLastLoginTimeVisibleToAdmin() {
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("Last login:");
        this.tester.assertTextPresent("Last failed login:");
        this.tester.assertTextPresent("Current failed logins:");
        this.tester.assertTextInElement(LAST_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(LAST_FAILED_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "0");
    }

    @Test
    public void testLastLoginTimeNotVisibleToNonAdmin() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextNotPresent("Last login:");
        this.tester.assertTextNotPresent("Last failed login:");
        this.tester.assertTextNotPresent("Current failed logins:");
    }

    @Test
    public void testTimesGetUpdatedOnLogins() {
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextInElement(LAST_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(LAST_FAILED_LOGIN_TIME_ID, "Never");
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "0");
        this.navigation.logout();
        this.navigation.loginAttempt("fred", "!nc0rrectP@ssword");
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextInElement(LAST_LOGIN_TIME_ID, "Never");
        this.textAssertions.assertRegexMatch(this.tester.getDialog().getElement(LAST_FAILED_LOGIN_TIME_ID).getTextContent(), TIMESTAMP_PATTERN);
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "1");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.textAssertions.assertRegexMatch(this.tester.getDialog().getElement(LAST_LOGIN_TIME_ID).getTextContent(), TIMESTAMP_PATTERN);
        this.textAssertions.assertRegexMatch(this.tester.getDialog().getElement(LAST_FAILED_LOGIN_TIME_ID).getTextContent(), TIMESTAMP_PATTERN);
        this.tester.assertTextInElement(CURRENT_FAILED_LOGIN_COUNT_ID, "0");
    }
}

