/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestViewUserHoverAction
extends BaseJiraFuncTest {
    private static final String USER_HOVER_EMAIL = "user-hover-email";
    private static final String AVATAR_FULL_NAME_LINK = "avatar-full-name-link";
    @Inject
    private LocatorFactory locator;

    @Test
    @Restore(value="user_rename.xml")
    @LoginAs(user="admin")
    public void userHoverResultsCorrectWhenLoggedInAsAdmin() {
        this.assertUserHoverDetailsForMissingUser("doesnotexist");
        this.assertUserHoverDetails("admin", "Adam Ant", "mlassau@atlassian.com");
        this.assertUserHoverDetails("bb", "Bob Belcher", "bob@example.com");
        this.assertUserHoverDetails("betty", "Betty Boop", "betty@example.com");
        this.assertUserHoverDetails("cat", "Crazy Cat", "cat@example.com");
        this.assertUserHoverDetails("cc", "Candy Chaos", "candy@example.com");
    }

    @Test
    @Restore(value="user_rename.xml")
    public void usernameEnumerationNotPossibleWhenAnonymous() {
        this.assertUserHoverDetailsForAnonymousUser("doesnotexist");
        this.assertUserHoverDetailsForAnonymousUser("admin");
        this.assertUserHoverDetailsForAnonymousUser("bb");
        this.assertUserHoverDetailsForAnonymousUser("betty");
        this.assertUserHoverDetailsForAnonymousUser("cat");
        this.assertUserHoverDetailsForAnonymousUser("cc");
    }

    private void gotoUserHover(String username) {
        this.gotoUserHoverWithAction("!default", username);
    }

    private void gotoUserHoverWithAction(String actionName, String username) {
        this.navigation.gotoPage("/secure/ViewUserHover" + actionName + ".jspa?decorator=none&username=" + username);
    }

    private void assertUserHoverDetailsForMissingUser(String username) {
        this.gotoUserHover(username);
        Assert.assertFalse((boolean)this.locator.id(AVATAR_FULL_NAME_LINK).exists());
        Assert.assertEquals((Object)("User does not exist: " + username), (Object)this.locator.css("div.user-hover-details").getText());
        Assert.assertEquals((Object)"", (Object)this.locator.id(USER_HOVER_EMAIL).getText());
    }

    private void assertUserHoverDetailsForAnonymousUser(String username) {
        this.assertUserHoverDetailsWithActionForAnonymousUser("!default", username);
        this.assertUserHoverDetailsWithActionForAnonymousUser("", username);
    }

    private void assertUserHoverDetailsWithActionForAnonymousUser(String username, String actionName) {
        this.gotoUserHoverWithAction(username, actionName);
        Assert.assertFalse((boolean)this.locator.id(AVATAR_FULL_NAME_LINK).exists());
        Assert.assertEquals((Object)"Your session has timed out", (Object)this.locator.css(" div.aui-message").getText());
        Assert.assertEquals((Object)"", (Object)this.locator.id(USER_HOVER_EMAIL).getText());
    }

    private void assertUserHoverDetails(String username, String fullName, String emailAddress) {
        this.gotoUserHover(username);
        Element link = (Element)this.locator.id(AVATAR_FULL_NAME_LINK).getNode();
        Assert.assertEquals((Object)username, (Object)link.getAttribute("title"));
        Assert.assertEquals((Object)fullName, (Object)link.getTextContent().trim());
        Assert.assertEquals((Object)emailAddress, (Object)this.locator.id(USER_HOVER_EMAIL).getText());
    }
}

