/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.a11y;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@RestoreBlankInstance
public class TestA11yPage
extends BaseJiraFuncTest {
    private static final String A11Y_SETTINGS_PAGE = "/secure/AccessibilityPersonalSettings!default.jspa";
    private static final String A11Y_PAGE_HEADER = "<h1>Accessibility</h1>";
    private static final String LOGIN_PAGE_TEXT = "Welcome to jWebTest JIRA installation";

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=808000)
    public void testAnonymousAccess() {
        this.navigation.gotoPage(A11Y_SETTINGS_PAGE);
        this.assertions.getTextAssertions().assertTextPresent(LOGIN_PAGE_TEXT);
        this.assertions.getTextAssertions().assertTextNotPresent(A11Y_PAGE_HEADER);
    }

    @LoginAs(user="admin")
    @Test
    @SinceBuildRule.SinceBuild(buildNumber=808000)
    public void testLoggedInAccess() {
        this.navigation.gotoPage(A11Y_SETTINGS_PAGE);
        this.assertions.getTextAssertions().assertTextPresent(A11Y_PAGE_HEADER);
        this.assertions.getTextAssertions().assertTextNotPresent(LOGIN_PAGE_TEXT);
    }
}

