/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.CustomFieldDefaultValueFKChangedEvent;
import com.atlassian.jira.webtests.ztests.user.anonymize.CFChangeTestBase;
import com.atlassian.jira.webtests.ztests.user.anonymize.ForeignKeysClient;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.ACTIVE_OBJECTS, Category.PLUGINS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCFUserPickerKeyChange
extends CFChangeTestBase {
    private ForeignKeysClient foreignKeysClient;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.foreignKeysClient = new ForeignKeysClient(this.environmentData);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage("com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.assertDefaultValueForUserPickerEmpty();
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
    }

    @Test
    public void shouldUpdateCustomFieldValues() {
        this.setDefaultValueForUserPickerField("admin");
        String someUserIssueKey = this.createIssue();
        this.setDefaultValueForUserPickerField("fred");
        String fredIssueKey = this.createIssue();
        String fredAnotherIssueKey = this.createIssue();
        Assert.assertEquals((Object)"fred", (Object)this.getCustomUserPickerFieldValue(fredIssueKey));
        Assert.assertEquals((Object)"fred", (Object)this.getCustomUserPickerFieldValue(fredAnotherIssueKey));
        Assert.assertEquals((Object)"admin", (Object)this.getCustomUserPickerFieldValue(someUserIssueKey));
        ParsedResponse result = this.foreignKeysClient.triggerUpdate("fred", "fooBar");
        Assert.assertEquals((long)200L, (long)result.statusCode);
        Assert.assertEquals((Object)"fooBar", (Object)this.getCustomUserPickerFieldValue(fredIssueKey));
        Assert.assertEquals((Object)"fooBar", (Object)this.getCustomUserPickerFieldValue(fredAnotherIssueKey));
        Assert.assertEquals((Object)"admin", (Object)this.getCustomUserPickerFieldValue(someUserIssueKey));
    }

    @Test
    public void shouldUpdateCustomFieldsDefaultValues() {
        this.setDefaultValueForUserPickerField("fred");
        EventClient.EventPoller eventPoller = this.backdoor.events().createPoller();
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fooBar");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertDefaultValueForUserPickerFieldEquals("fooBar");
        Assert.assertThat(eventPoller.events(), (Matcher)CoreMatchers.hasItem((Object)CustomFieldDefaultValueFKChangedEvent.class.getName()));
    }

    private String getCustomUserPickerFieldValue(String issueKey) {
        return Optional.ofNullable((Map)this.backdoor.issues().getIssue((String)issueKey).fields.get("customfield_10000")).map(field -> (String)field.get("key")).orElse(null);
    }
}

