/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.beans.UserDTO;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@Restore(value="change-external-id.xml")
public class TestChangeExternalId
extends BaseJiraFuncTest {
    private UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void shouldChangeExternalIdWhenAnonymizingInternalUser() {
        UserDTO john = this.backdoor.usersAndGroups().getUserByName("john");
        String externalIdBefore = this.userAnonymizeControl.getExternalId("john");
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(john.getKey(), false, null, null, "admin");
        String externalIdAfter = this.userAnonymizeControl.getExternalId(anonymizeResponse.getUserNameNew());
        Assert.assertThat((Object)externalIdAfter, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)externalIdBefore)));
        UUID.fromString(externalIdAfter);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void shouldChangeExternalIdWhenAnonymizingUserDeletedExternally() {
        UserDTO deletedExternally = this.backdoor.usersAndGroups().getUserByName("crowd-deleted");
        String externalIdBefore = this.userAnonymizeControl.getExternalId("crowd-deleted");
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(deletedExternally.getKey(), false, null, null, "admin");
        String externalIdAfter = this.userAnonymizeControl.getExternalId(anonymizeResponse.getUserNameNew());
        Assert.assertThat((Object)externalIdAfter, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)externalIdBefore)));
        UUID.fromString(externalIdAfter);
        UserDTO userAfterAnonymize = this.backdoor.usersAndGroups().getUserByName(anonymizeResponse.getUserNameNew());
        Assert.assertThat((Object)userAfterAnonymize.isActive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void shouldFailValidationWhenChangingExternalIdForUserInMultipleDirectories() {
        UserDTO multiple = this.backdoor.usersAndGroups().getUserByName("multiple");
        String externalIdBefore = this.userAnonymizeControl.getExternalId("multiple");
        UserAnonymizeControl.AnonymizePerformResultValidationError validationError = this.userAnonymizeControl.anonymizeWithValidationError(multiple.getKey(), false, null, null, "admin");
        Assert.assertThat(validationError.getErrors(), (Matcher)Matchers.contains((Object[])new String[]{"You can't anonymize a user that exists in multiple directories."}));
        Assert.assertThat(validationError.getAffectedEntitiesReport().entrySet(), (Matcher)Matchers.empty());
        Assert.assertThat(validationError.getOperationValidation().entrySet(), (Matcher)Matchers.empty());
        String externalIdAfter = this.userAnonymizeControl.getExternalId("multiple");
        Assert.assertThat((Object)externalIdAfter, (Matcher)Matchers.equalTo((Object)externalIdBefore));
    }
}

