/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.webtests.ztests.admin.AuditingClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserAnonymizeChangeUserKey
extends BaseJiraFuncTest {
    UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUpTest() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.getEnvironmentData());
    }

    @Test
    public void testAnonymizeUser() {
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        Assert.assertTrue((boolean)userToAnonymize.isActive());
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        Optional<UserDTO> addedUserAfterChange = this.getUserByKey(userToAnonymize.getKey());
        Assert.assertFalse((boolean)addedUserAfterChange.isPresent());
        Optional<UserDTO> anonymizedUserOption = this.getUserByKey(anonymizeResponse.getUserKeyNew());
        Assert.assertTrue((boolean)anonymizedUserOption.isPresent());
        UserDTO anonymizedUser = anonymizedUserOption.get();
        Assert.assertThat((Object)anonymizedUser.getKey(), (Matcher)RegexMatchers.regexMatches((String)"^JIRAUSER[0-9]+$"));
        Assert.assertFalse((boolean)anonymizedUser.isActive());
        this.assertAuditLogRecordForFred();
    }

    @Test
    public void testAnonymizeDeletedUser() {
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.backdoor.usersAndGroups().deleteUser("fred");
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        UserDTO oldName = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(userToAnonymize.getName());
        Assert.assertThat((Object)oldName.getId(), (Matcher)IsEqual.equalTo((Object)-1L));
        UserDTO anonymized = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(anonymizeResponse.getUserNameNew());
        Assert.assertThat((Object)anonymized.getId(), (Matcher)IsEqual.equalTo((Object)10000L));
        Assert.assertThat((Object)anonymized.getKey(), (Matcher)IsEqual.equalTo((Object)anonymizeResponse.getUserKeyNew()));
        Assert.assertThat((Object)anonymized.getKey(), (Matcher)RegexMatchers.regexMatches((String)"^JIRAUSER[0-9]+$"));
        this.assertAuditLogRecordForFred();
    }

    private void assertAuditLogRecordForFred() {
        List<AuditingClient.ViewResponse.RecordResponse> records = this.backdoor.auditing().getViewResponse().getRecords();
        Assert.assertThat(records, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"summary", (Matcher)Matchers.equalTo((Object)"User anonymized")), (Matcher)Matchers.hasProperty((String)"description", (Matcher)Matchers.equalTo((Object)"User with username 'jirauser10000' (was: 'fred') and key 'JIRAUSER10000' (was: 'fred') has been anonymized.")), (Matcher)Matchers.hasProperty((String)"objectItem", TestUserAnonymizeChangeUserKey.matches("USER", "JIRAUSER10000", "jirauser10000")), (Matcher)Matchers.hasProperty((String)"associatedItems", (Matcher)Matchers.contains(TestUserAnonymizeChangeUserKey.matches("USER", "fred", "fred"))))}));
        Assert.assertThat(records, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"summary", (Matcher)Matchers.equalTo((Object)"User anonymization started")), (Matcher)Matchers.hasProperty((String)"description", (Matcher)Matchers.equalTo((Object)"Anonymization started for user with username 'fred' and key 'fred'.")), (Matcher)Matchers.hasProperty((String)"objectItem", TestUserAnonymizeChangeUserKey.matches("USER", "fred", "fred")), (Matcher)Matchers.hasProperty((String)"associatedItems", (Matcher)Matchers.empty()))}));
        Assert.assertThat(records, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"summary", (Matcher)Matchers.equalTo((Object)"User's key changed")), (Matcher)Matchers.hasProperty((String)"description", (Matcher)Matchers.nullValue()), (Matcher)Matchers.hasProperty((String)"objectItem", TestUserAnonymizeChangeUserKey.matches("USER", "JIRAUSER10000", "fred")), (Matcher)Matchers.hasProperty((String)"associatedItems", (Matcher)Matchers.contains(TestUserAnonymizeChangeUserKey.matches("USER", "fred", "fred"))))}));
    }

    private Optional<UserDTO> getUserByKey(String key) {
        return this.backdoor.usersAndGroups().getAllUsers().stream().filter(user -> user.getKey().equals(key)).findFirst();
    }

    private static Matcher<AuditingClient.ViewResponse.AssociatedItemResponse> matches(final String type, final String id, final String name) {
        return new TypeSafeMatcher<AuditingClient.ViewResponse.AssociatedItemResponse>(){

            protected boolean matchesSafely(AuditingClient.ViewResponse.AssociatedItemResponse item) {
                return Objects.equals(item.getObjectType(), type) && Objects.equals(item.getObjectId(), id) && Objects.equals(item.getObjectName(), name);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Associated item with type: %s, id: %s, name: %s", type, id, name));
            }
        };
    }
}

