/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.issue.customfields.CustomFieldTypes;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.v2.user.anonymization.AffectedEntityBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationValidationBean;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectUpdateField;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionStringHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserAnonymizeChangeUserName
extends BaseJiraFuncTest {
    private static final String EXPAND_AFFECTED_ENTITIES = "affectedEntities";
    private static final String DELETED_EXTERNALLY = "crowd1";
    private static final String FRED_MENTION = MentionStringHelper.formatMention((String)"fred");
    private static final String FRED_UPPECASE_MENTION = MentionStringHelper.formatMention((String)"fred".toUpperCase());
    private static final String ADMIN_MENTION = MentionStringHelper.formatMention((String)"admin");
    private static final String SHOW_ENTITIES = "Show entities";
    private static final String SHOW_ENTITIES_URL = "http://www.atlassian.com";
    private static final List<String> mentionTestStrings = ImmutableList.of((Object)"Some [~fred] mentioning comment! fred [~admin]", (Object)"Another comment which mentions [~fred]...fred [~admin]", (Object)"Hey, [~fred]! fred [~admin]", (Object)"Ahh fred fred, [~fred]... fred [~admin]", (Object)"[~fred] you're very freddy [~fred] ! fred [~admin]", (Object)"I did not hit [~admin]! I did not! Oh, hi, [~fred]! fred");
    private UserAnonymizeControl userAnonymizeControl;
    private WorklogClient worklogClient;
    private ProjectClient projectClient;

    @Before
    public void setUpTest() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
    }

    @Test
    public void testAnonymizeUser() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        Optional<UserDTO> addedUserAfterChange = this.getUserByName(userToAnonymize.getName());
        Assert.assertFalse((boolean)addedUserAfterChange.isPresent());
        Optional<UserDTO> anonymizedUserOption = this.getUserByName(anonymizeResponse.getUserNameNew());
        Assert.assertTrue((boolean)anonymizedUserOption.isPresent());
        UserDTO anonymized = anonymizedUserOption.get();
        Assert.assertThat((Object)anonymized.isActive(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)IsEqual.equalTo((Object)anonymizeResponse.getUserNameNew()));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)IsEqual.equalTo((Object)anonymized.getUsername()));
    }

    @Test
    public void testAnonymizeDeletedUser() {
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.backdoor.usersAndGroups().deleteUser("fred");
        Optional<UserDTO> deletedUser = this.getUserByName(userToAnonymize.getName());
        Assert.assertFalse((boolean)deletedUser.isPresent());
        UserDTO deletedUserUnknown = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(userToAnonymize.getName());
        Assert.assertFalse((boolean)deletedUserUnknown.isActive());
        Assert.assertThat((Object)deletedUserUnknown.getId(), (Matcher)IsEqual.equalTo((Object)10000L));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        UserDTO oldName = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(userToAnonymize.getName());
        Assert.assertThat((Object)oldName.getId(), (Matcher)IsEqual.equalTo((Object)-1L));
        UserDTO anonymized = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(anonymizeResponse.getUserNameNew());
        Assert.assertThat((Object)anonymized.getId(), (Matcher)IsEqual.equalTo((Object)10000L));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)IsEqual.equalTo((Object)anonymizeResponse.getUserNameNew()));
        Assert.assertThat((Object)anonymized.getKey(), (Matcher)IsEqual.equalTo((Object)anonymizeResponse.getUserKeyNew()));
    }

    @Restore(value="deletedexternally.xml")
    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804001)
    public void testAnonymizeUserDeletedExternally() {
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName(DELETED_EXTERNALLY);
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        Assert.assertThat((Object)anonymizeResponse.getUserNameNew(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)DELETED_EXTERNALLY)));
        Optional<UserDTO> userByOldUsername = this.getUserByName(userToAnonymize.getName());
        Assert.assertFalse((boolean)userByOldUsername.isPresent());
        Optional<UserDTO> anonymizedUserOption = this.getUserByName(anonymizeResponse.getUserNameNew());
        Assert.assertTrue((boolean)anonymizedUserOption.isPresent());
        UserDTO anonymized = anonymizedUserOption.get();
        Assert.assertThat((Object)anonymized.getEmail(), (Matcher)Matchers.endsWith((String)"@jira.invalid"));
        Assert.assertThat((Object)anonymized.getDisplayName(), (Matcher)RegexMatchers.regexMatches((String)"user-[0-9a-f]{5}"));
        Assert.assertThat((Object)anonymized.isActive(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)Matchers.not((Matcher)IsEqual.equalTo((Object)DELETED_EXTERNALLY)));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)IsEqual.equalTo((Object)anonymizeResponse.getUserNameNew()));
        Assert.assertThat((Object)anonymized.getName(), (Matcher)IsEqual.equalTo((Object)anonymized.getUsername()));
    }

    @Test
    public void testAnonymizeUserMentionsInComments() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createSomeIssues();
        this.setValuesForIssue(issueKeys, (key, text) -> this.backdoor.issues().commentIssue(key, text));
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        this.assertUsernameAnonymizedInComments(issueKeys, anonymizationResult);
    }

    @Test
    public void testAnonymizeUserMentionsInWorklogs() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createSomeIssues();
        this.setValuesForIssue(issueKeys, (key, text) -> {
            Worklog worklog = new Worklog();
            worklog.comment = text;
            worklog.timeSpent = "1h";
            this.worklogClient.post(key, worklog);
        });
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        this.assertUsernameAnonymizedInWorklogs(issueKeys, anonymizationResult);
    }

    @Test
    public void testAnonymizeUserMentionsInDescription() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createMoreIssues();
        this.setValueForIssue(issueKeys, (key, text) -> this.backdoor.issues().setDescription(key, text));
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        this.assertUsernameAnonymizedInDescriptions(issueKeys, anonymizationResult);
    }

    @Test
    public void testAnonymizeUserMentionsInEnvironment() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createMoreIssues();
        this.setValueForIssue(issueKeys, (key, text) -> this.backdoor.issues().setIssueFields(key, new IssueFields().environment(text)));
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        this.assertUsernameAnonymizedInEnvironments(issueKeys, anonymizationResult);
    }

    @Test
    public void testAnonymizeUserMentionsInProjectDescription() {
        this.backdoor.applicationProperties().setOption("jira.project.description.html.enabled", false);
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        String projectDescriptionTemplate = "hey [~%s] how are you [~%s]. Some other mention: [~otheruser]. Uppercase: [~%s]";
        String projectDescriptionBefore = String.format("hey [~%s] how are you [~%s]. Some other mention: [~otheruser]. Uppercase: [~%s]", userToAnonymize.getUsername(), userToAnonymize.getUsername(), userToAnonymize.getUsername().toUpperCase());
        this.setProjectDescription("HSP", projectDescriptionBefore);
        this.setProjectDescription("MKY", projectDescriptionBefore);
        this.backdoor.project().addProject("ANON", "ANON", "admin");
        String anonDescriptionBefore = "hey [~admin] how are you [~admin]. Some other mention: [~otheruser]. Uppercase: [~ADMIN]";
        this.setProjectDescription("ANON", "hey [~admin] how are you [~admin]. Some other mention: [~otheruser]. Uppercase: [~ADMIN]");
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymization(userToAnonymize.getKey(), EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Project description", Long.valueOf(2L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User key entries in the database", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", Long.valueOf(1L), "User Profile", this.getBaseUrl() + "/secure/ViewProfile.jspa?name=fred"), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Full name in issue history", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", null, null, null)}));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        String projectDescriptionExpected = String.format("hey [~%s] how are you [~%s]. Some other mention: [~otheruser]. Uppercase: [~%s]", anonymizeResult.getUserNameNew(), anonymizeResult.getUserNameNew(), anonymizeResult.getUserNameNew());
        Assert.assertThat((Object)this.projectClient.get((String)"ANON").description, (Matcher)IsEqual.equalTo((Object)"hey [~admin] how are you [~admin]. Some other mention: [~otheruser]. Uppercase: [~ADMIN]"));
        Assert.assertThat((Object)this.projectClient.get((String)"HSP").description, (Matcher)IsEqual.equalTo((Object)projectDescriptionExpected));
        Assert.assertThat((Object)this.projectClient.get((String)"MKY").description, (Matcher)IsEqual.equalTo((Object)projectDescriptionExpected));
    }

    @Test
    public void testAnonymizeUserMentionsInCustomFields() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createMoreIssues();
        String customFieldKey = this.backdoor.customFields().createCustomField("Text custom field", null, CustomFieldTypes.TEXTAREA.getKey(), null);
        this.backdoor.screens().addFieldToScreen("Default Screen", "Text custom field");
        Long customFieldId = Long.valueOf(customFieldKey.substring("customfield_".length()));
        this.setValueForIssue(issueKeys, (key, text) -> this.backdoor.issues().setIssueFields(key, new IssueFields().customField(customFieldId, text)));
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        this.assertUsernameAnonymizedInCustomFields(issueKeys, customFieldKey, anonymizationResult);
    }

    @Test
    public void testAnonymizeUsermentionsInIssueHistory() {
        UserDTO userToAnonymize = this.getActiveUserToAnonymize();
        List<String> issueKeys = this.createMoreIssues();
        this.setValuesForIssue(issueKeys, (key, text) -> {
            this.backdoor.issues().setIssueFields(key, new IssueFields().environment(text));
            this.backdoor.issues().setIssueFields(key, new IssueFields().description(text));
        });
        this.setValuesForIssue(issueKeys, Lists.reverse(mentionTestStrings), (key, text) -> {
            this.backdoor.issues().setIssueFields(key, new IssueFields().environment(text));
            this.backdoor.issues().setIssueFields(key, new IssueFields().description(text));
        });
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        String newUsernameMention = MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew());
        String allChangesString = issueKeys.stream().map(issueKey -> this.backdoor.issues().getIssue((String)issueKeys.iterator().next(), new Issue.Expand[]{Issue.Expand.changelog})).flatMap(issue -> issue.changelog.histories.stream().flatMap(h -> h.items.stream().flatMap(hi -> Stream.of(hi.fromString, hi.toString)))).collect(Collectors.joining(" "));
        Assert.assertThat((Object)allChangesString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)FRED_MENTION)));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)allChangesString, (CharSequence)newUsernameMention), (Matcher)Matchers.is((Object)(6 * mentionTestStrings.size())));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)allChangesString, (CharSequence)ADMIN_MENTION), (Matcher)Matchers.is((Object)(6 * mentionTestStrings.size())));
    }

    @Test
    public void testMentionInDefaultValuesForTextCustomFields() {
        String username = "testxml'\"";
        String usernameMention = MentionStringHelper.formatMention((String)"testxml'\"");
        String usernameMentionUppercase = MentionStringHelper.formatMention((String)"testxml'\"").toUpperCase();
        this.backdoor.usersAndGroups().addUser("testxml'\"");
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("testxml'\"");
        String textArea1CFKey = this.backdoor.customFields().createCustomField("Textarea custom field1", null, CustomFieldTypes.TEXTAREA.getKey(), null);
        String textArea2CFKey = this.backdoor.customFields().createCustomField("Textarea custom field2", null, CustomFieldTypes.TEXTAREA.getKey(), null);
        String textField1CFKey = this.backdoor.customFields().createCustomField("Textfield custom field1", null, CustomFieldTypes.TEXTFIELD.getKey(), null);
        String textField2CFKey = this.backdoor.customFields().createCustomField("Textfield custom field2", null, CustomFieldTypes.TEXTFIELD.getKey(), null);
        List allProjectIds = this.backdoor.project().getProjects().stream().map(p -> p.id).map(Long::parseLong).collect(Collectors.toList());
        long textArea1Context = this.backdoor.customFields().createCustomFieldContext(this.getCustomFieldId(textArea1CFKey), allProjectIds, Collections.emptyList());
        long textArea2Context = this.backdoor.customFields().createCustomFieldContext(this.getCustomFieldId(textArea2CFKey), allProjectIds, Collections.emptyList());
        long textField1Context = this.backdoor.customFields().createCustomFieldContext(this.getCustomFieldId(textField1CFKey), allProjectIds, Collections.emptyList());
        long textField2Context = this.backdoor.customFields().createCustomFieldContext(this.getCustomFieldId(textField2CFKey), allProjectIds, Collections.emptyList());
        String defaultValue = String.format("Informing %s and %s and also other %s", ADMIN_MENTION, usernameMention, usernameMentionUppercase);
        String defaultValueNoMentions = "Some simple text possibly with <string>html tags</strong> and other [fred] characters.";
        this.backdoor.customFields().setDefaultValueForContext(Long.valueOf(textArea1Context), (Object)defaultValue);
        this.backdoor.customFields().setDefaultValueForContext(Long.valueOf(textArea2Context), (Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters.");
        this.backdoor.customFields().setDefaultValueForContext(Long.valueOf(textField1Context), (Object)defaultValue);
        this.backdoor.customFields().setDefaultValueForContext(Long.valueOf(textField2Context), (Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters.");
        this.backdoor.screens().getAllScreens().stream().forEach(screen -> {
            this.backdoor.screens().addFieldToScreen(screen.getName(), "Textarea custom field1");
            this.backdoor.screens().addFieldToScreen(screen.getName(), "Textarea custom field2");
            this.backdoor.screens().addFieldToScreen(screen.getName(), "Textfield custom field1");
            this.backdoor.screens().addFieldToScreen(screen.getName(), "Textfield custom field2");
        });
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymization(userToAnonymize.getKey(), EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Text custom fields (default values)", Long.valueOf(2L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", Long.valueOf(1L), "User Profile", this.getBaseUrl() + "/secure/ViewProfile.jspa?name=testxml%27%22"), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Full name in issue history", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL)}));
        IssueCreateResponse createdIssueBefore = this.backdoor.issues().createIssue("HSP", "issue before anonymization");
        Issue createdIssueBeforeData = this.backdoor.issues().getIssue(createdIssueBefore.key);
        Assert.assertThat((Object)createdIssueBeforeData.fields.get(textArea1CFKey), (Matcher)IsEqual.equalTo((Object)defaultValue));
        Assert.assertThat((Object)createdIssueBeforeData.fields.get(textArea2CFKey), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
        Assert.assertThat((Object)createdIssueBeforeData.fields.get(textField1CFKey), (Matcher)IsEqual.equalTo((Object)defaultValue));
        Assert.assertThat((Object)createdIssueBeforeData.fields.get(textField2CFKey), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
        UserAnonymizeControl.AnonymizePerformResult anonymizationResult = this.userAnonymizeControl.anonymize(userToAnonymize.getKey());
        String expectedAnonymizedValue = String.format("Informing %s and %s and also other %s", ADMIN_MENTION, MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew()), MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew()));
        Assert.assertThat((Object)this.backdoor.customFields().getDefaultValueForContext(Long.valueOf(textArea1Context)), (Matcher)IsEqual.equalTo((Object)expectedAnonymizedValue));
        Assert.assertThat((Object)this.backdoor.customFields().getDefaultValueForContext(Long.valueOf(textArea2Context)), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
        Assert.assertThat((Object)this.backdoor.customFields().getDefaultValueForContext(Long.valueOf(textField1Context)), (Matcher)IsEqual.equalTo((Object)expectedAnonymizedValue));
        Assert.assertThat((Object)this.backdoor.customFields().getDefaultValueForContext(Long.valueOf(textField2Context)), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
        IssueCreateResponse createdIssue = this.backdoor.issues().createIssue("HSP", "issue after anonymization");
        Issue createdIssueData = this.backdoor.issues().getIssue(createdIssue.key);
        Assert.assertThat((Object)createdIssueData.fields.get(textArea1CFKey), (Matcher)IsEqual.equalTo((Object)expectedAnonymizedValue));
        Assert.assertThat((Object)createdIssueData.fields.get(textArea2CFKey), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
        Assert.assertThat((Object)createdIssueData.fields.get(textField1CFKey), (Matcher)IsEqual.equalTo((Object)expectedAnonymizedValue));
        Assert.assertThat((Object)createdIssueData.fields.get(textField2CFKey), (Matcher)IsEqual.equalTo((Object)"Some simple text possibly with <string>html tags</strong> and other [fred] characters."));
    }

    private String getCustomFieldId(String cfKey) {
        return CustomFieldUtils.getCustomFieldId((String)cfKey).toString();
    }

    private Optional<UserDTO> getUserByName(String userName) {
        return this.backdoor.usersAndGroups().getAllUsers().stream().filter(user -> user.getName().equals(userName)).findFirst();
    }

    private UserDTO getActiveUserToAnonymize() {
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        Assert.assertTrue((boolean)userToAnonymize.isActive());
        return userToAnonymize;
    }

    private List<String> createSomeIssues() {
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue("HSP", "Test issue 1");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue("HSP", "Test issue 2");
        IssueCreateResponse issue3 = this.backdoor.issues().createIssue("MKY", "Test issue 3");
        return ImmutableList.of((Object)issue1.key, (Object)issue2.key, (Object)issue3.key);
    }

    private List<String> createMoreIssues() {
        return Stream.of(this.createSomeIssues(), this.createSomeIssues()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void setValuesForIssue(List<String> issueKeys, BiConsumer<String, String> issueKeyAndTextConsumer) {
        this.setValuesForIssue(issueKeys, mentionTestStrings, issueKeyAndTextConsumer);
    }

    private void setValuesForIssue(List<String> issueKeys, List<String> mentionTestStrings, BiConsumer<String, String> issueKeyAndTextConsumer) {
        this.executeOnMentionsStringPartitionedByIssueId(issueKeys, mentionTestStrings, (key, mentionTexts) -> {
            for (String mentionText : mentionTexts) {
                issueKeyAndTextConsumer.accept((String)key, mentionText);
            }
        });
    }

    private void setValueForIssue(List<String> issueKeys, BiConsumer<String, String> issueKeyAndTextConsumer) {
        for (int i = 0; i < issueKeys.size(); ++i) {
            String issueKey = issueKeys.get(i);
            String text = mentionTestStrings.get(i);
            issueKeyAndTextConsumer.accept(issueKey, text);
        }
    }

    private void executeOnMentionsStringPartitionedByIssueId(List<String> issueKeys, List<String> mentionTestStrings, BiConsumer<String, List<String>> consumer) {
        List partitionedMentionTestStrings = Lists.partition(mentionTestStrings, (int)((int)Math.ceil((double)mentionTestStrings.size() / (double)issueKeys.size())));
        IntStream.range(0, issueKeys.size()).forEach(idx -> consumer.accept((String)issueKeys.get(idx), (List<String>)partitionedMentionTestStrings.get(idx)));
    }

    private void assertUsernameAnonymizedInComments(List<String> issueKeys, UserAnonymizeControl.AnonymizePerformResult anonymizeResult) {
        String newMention = MentionStringHelper.formatMention((String)anonymizeResult.getUserNameNew());
        for (String issueKey : issueKeys) {
            this.assertIssueCommentsAnonymized(issueKey, newMention);
        }
    }

    private void assertIssueCommentsAnonymized(String issueKey, String newMention) {
        Issue issue = this.backdoor.issues().getIssue(issueKey);
        List comments = issue.getComments();
        Assert.assertThat((Object)comments, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        for (Comment comment : comments) {
            this.assertMentionsAnonymizedCorrectly(comment.body, newMention);
        }
    }

    private void assertMentionsAnonymizedCorrectly(String text, String newMention) {
        Assert.assertThat((Object)text, (Matcher)Matchers.containsString((String)newMention));
        Assert.assertThat((Object)text, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)FRED_MENTION)));
        Assert.assertThat((Object)text, (Matcher)Matchers.containsString((String)ADMIN_MENTION));
        Assert.assertThat((Object)text, (Matcher)Matchers.containsString((String)"fred"));
    }

    private void assertUsernameAnonymizedInWorklogs(List<String> issueKeys, UserAnonymizeControl.AnonymizePerformResult anonymizationResult) {
        String newMention = MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew());
        for (String issueKey : issueKeys) {
            this.assertIssueWorklogsAnonymized(issueKey, newMention);
        }
    }

    private void assertIssueWorklogsAnonymized(String issueKey, String newMention) {
        WorklogWithPaginationBean allWorklogs = this.worklogClient.getAll(issueKey);
        Assert.assertThat((Object)allWorklogs.worklogs, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        for (Worklog worklog : allWorklogs.worklogs) {
            this.assertMentionsAnonymizedCorrectly(worklog.comment, newMention);
        }
    }

    private void assertUsernameAnonymizedInDescriptions(List<String> issueKeys, UserAnonymizeControl.AnonymizePerformResult anonymizationResult) {
        String newMention = MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew());
        for (String issueKey : issueKeys) {
            this.assertIssueDescriptionsAnonymized(issueKey, newMention);
        }
    }

    private void assertIssueDescriptionsAnonymized(String issueKey, String newMention) {
        String description = this.backdoor.issues().getIssue((String)issueKey).fields.description;
        this.assertMentionsAnonymizedCorrectly(description, newMention);
    }

    private void assertUsernameAnonymizedInEnvironments(List<String> issueKeys, UserAnonymizeControl.AnonymizePerformResult anonymizationResult) {
        String newMention = MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew());
        for (String issueKey : issueKeys) {
            this.assertIssueEnvironmentsAnonymized(issueKey, newMention);
        }
    }

    private void assertIssueEnvironmentsAnonymized(String issueKey, String newMention) {
        String description = this.backdoor.issues().getIssue((String)issueKey).fields.environment;
        this.assertMentionsAnonymizedCorrectly(description, newMention);
    }

    private void assertUsernameAnonymizedInCustomFields(List<String> issueKeys, String customFieldKey, UserAnonymizeControl.AnonymizePerformResult anonymizationResult) {
        String newMention = MentionStringHelper.formatMention((String)anonymizationResult.getUserNameNew());
        for (String issueKey : issueKeys) {
            this.assertIssueCustomFieldsAnonymized(issueKey, customFieldKey, newMention);
        }
    }

    private void assertIssueCustomFieldsAnonymized(String issueKey, String customFieldKey, String newMention) {
        String cfValue = (String)this.backdoor.issues().getIssue((String)issueKey).fields.get(customFieldKey);
        this.assertMentionsAnonymizedCorrectly(cfValue, newMention);
    }

    private void setProjectDescription(String projectKey, String description) {
        Response updateResponse = this.projectClient.update(projectKey, ProjectClient.UpdateBean.builder().with(ProjectUpdateField.DESCRIPTION, (Object)description).build());
        Assert.assertThat((Object)updateResponse.getStatusInfo(), (Matcher)IsEqual.equalTo((Object)Response.Status.OK));
    }

    @Nonnull
    private String getBaseUrl() {
        return this.getEnvironmentData().getBaseUrl().toString();
    }
}

