/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.FilterSubscriptionControl;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Project;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserAnonymizeOwnershipTransfer
extends BaseJiraFuncTest {
    private UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUpTest() {
        this.backdoor.generalConfiguration().allowUnassignedIssues();
        this.userAnonymizeControl = new UserAnonymizeControl(this.getEnvironmentData());
    }

    @Test
    public void testChangeProjectLead() {
        this.setProjectLead("fred");
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)IsEqual.equalTo((Object)"admin"));
        Assert.assertThat((Object)project.assigneeType, (Matcher)IsEqual.equalTo((Object)Project.AssigneeType.UNASSIGNED));
    }

    @Test
    public void testChangeProjectLeadBeingDefaultAssignee() {
        this.setProjectLeadWithDefaultAssignee("fred");
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)IsEqual.equalTo((Object)"admin"));
        Assert.assertThat((Object)project.assigneeType, (Matcher)IsEqual.equalTo((Object)Project.AssigneeType.PROJECT_LEAD));
    }

    @Test
    public void testChangeProjectLeadBeingDefaultAssigneeForDeletedUser() {
        this.setProjectLeadWithDefaultAssignee("fred");
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.backdoor.usersAndGroups().deleteUser("fred");
        this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)IsEqual.equalTo((Object)"admin"));
        Assert.assertThat((Object)project.assigneeType, (Matcher)IsEqual.equalTo((Object)Project.AssigneeType.PROJECT_LEAD));
    }

    @Test
    public void testChangeComponentLead() {
        this.createComponentWithLead("Dummy component", "admin");
        this.createComponentWithLead("Dummy component 2", "fred");
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        List<String> componentLeads = this.getComponentLeadNamesForProject("MKY");
        Assert.assertThat((Object)componentLeads.size(), (Matcher)IsEqual.equalTo((Object)2));
        Assert.assertThat(componentLeads, (Matcher)Matchers.everyItem((Matcher)IsEqual.equalTo((Object)"admin")));
    }

    @Test
    public void testChangeSubscriptionsForGroupOwnership() {
        long filterId = Long.parseLong(this.backdoor.filters().createFilter("", "all issues"));
        ((FilterSubscriptionControl)this.backdoor.filterSubscriptions().loginAs("fred")).addSubscription(filterId, "jira-developers", "0 0 1 ? * *", true);
        UserDTO userToAnonymize = this.backdoor.usersAndGroups().getUserByName("fred");
        this.userAnonymizeControl.anonymize(userToAnonymize.getKey(), false, null, null, "admin");
        List<Map<String, Object>> subscriptions = ((FilterSubscriptionControl)this.backdoor.filterSubscriptions().loginAs("admin")).forFilter(filterId);
        Assert.assertThat(subscriptions, (Matcher)Matchers.hasSize((int)1));
        Map<String, Object> theSubscription = subscriptions.get(0);
        Assert.assertThat(theSubscription, (Matcher)Matchers.hasEntry((Object)"groupName", (Object)"jira-developers"));
        Assert.assertThat(theSubscription, (Matcher)Matchers.hasEntry((Object)"userKey", (Object)"admin"));
    }

    private void setProjectLead(String leadUserName) {
        this.setProjectLead(leadUserName, false);
    }

    private void setProjectLeadWithDefaultAssignee(String leadUserName) {
        this.setProjectLead(leadUserName, true);
    }

    private void setProjectLead(String leadUserName, boolean hasDefaultAssignee) {
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.backdoor.project().setProjectLead(projectId, leadUserName);
        this.backdoor.project().setProjectDefaultAssignee(projectId, hasDefaultAssignee);
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)IsEqual.equalTo((Object)leadUserName));
        Assert.assertThat((Object)project.assigneeType, (Matcher)IsEqual.equalTo((Object)(hasDefaultAssignee ? Project.AssigneeType.PROJECT_LEAD : Project.AssigneeType.UNASSIGNED)));
    }

    private Component createComponentWithLead(String componentName, String leadUserName) {
        return this.backdoor.components().create(new Component().project("MKY").name(componentName).leadUserName(leadUserName).assigneeType(Component.AssigneeType.COMPONENT_LEAD));
    }

    private List<String> getComponentLeadNamesForProject(String projectKey) {
        return this.backdoor.project().getProject((String)projectKey).components.stream().map(shallowComponent -> this.backdoor.components().get((String)new StringBuilder().append((String)"").append((Object)shallowComponent.id).toString()).lead.name).collect(Collectors.toList());
    }
}

