/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestUserRenameOnChangeHistory
extends BaseJiraFuncTest {
    private static final String ASSIGNEE = "Assignee";
    private static final String REPORTER = "Reporter";
    private static final String ASSIGNEE_FIELD = "assignee";
    private static final String REPORTER_FIELD = "reporter";
    private static final String UPDATE_BUTTON = "Update";
    private static final String BROWSE_ISSUE_WITH_HISTORY_URL = "browse/%s?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel";
    private static final String AUTHOR_ID = "changehistoryauthor_%d";
    private static final String CHANGE_TABLE_ID = "changehistory_%d";
    private static final String SINGLE_USER_FIELD_ID = "customfield_10400";
    private static final String SINGLE_USER_FIELD_NAME = "Single user";
    private static final String MULTI_USER_FIELD_ID = "customfield_10401";
    private static final String MULTI_USER_FIELD_NAME = "Multi user";
    private static final String NOTHING = "";
    private static final String COW_1 = "COW-1";
    private static final String COW_2 = "COW-2";
    private static final String COW_3 = "COW-3";
    private static final String COW_4 = "COW-4";
    private static final String ADAM_ANT = "Adam Ant";
    private static final String BETTY_BOOP = "Betty Boop";
    private static final String BOB_BELCHER = "Bob Belcher";
    private static final String JIRA_ADMINISTRATORS = "jira-administrators";
    private static final String ADMIN = "admin";
    private static final String CRAZY = "crazy";
    private static final String CAT = "cat";
    private static final String BELCHYMAN = "belchyman";
    private static final String BETTY = "betty";
    private static final String BB = "bb";
    private static final String CC = "cc";
    private static final String CANDY = "candy";
    private static final String MEOW = "meow";
    private static final String BETTY_BOOP_SYSTEM_FIELD_DISPLAY = "Betty Boop [ betty ]";
    private static final String CRAZY_CAT_CRAZY_SYSTEM_FIELD_DISPLAY = "Crazy Cat [ crazy ]";
    private static final String CRAZY_CAT_CAT_SYSTEM_FIELD_DISPLAY = "Crazy Cat [ cat ]";
    private static final String CANDY_CHAOS_CANDY_SYSTEM_FIELD_DISPLAY = "Candy Chaos [ candy ]";
    private static final String CANDY_CHAOS_CC_SYSTEM_FIELD_DISPLAY = "Candy Chaos [ cc ]";
    private static final String CANDY_CHAOS_ID_SYSTEM_FIELD_DISPLAY = "Candy Chaos [ ID10101 ]";
    private static final String BOB_BELCHER_BELCHYMAN_SYSTEM_FIELD_DISPLAY = "Bob Belcher [ belchyman ]";
    private static final String BOB_BELCHER_ID_SYSTEM_FIELD_DISPLAY = "Bob Belcher [ ID10001 ]";
    private static final String ADAM_ANT_SYSTEM_FIELD_DISPLAY = "Adam Ant [ admin ]";
    private static final String CC_CAT = "cc, cat";
    private static final String BB_CRAZY_CANDY = "bb, crazy, candy";
    private static final String BB_MEOW_CANDY = "bb, meow, candy";
    private static final String CANDY_CHAOS_CRAZY_CAT_CHANGE = "Candy Chaos, Crazy Cat [ ID10101, cc ]";
    private static final String BETTY_BOOP_CANDY_CHAOS_CRAZY_CAT_CHANGE = "Betty Boop, Candy Chaos, Crazy Cat [ bb, ID10101, cc ]";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename_customfields.xml");
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.administration.backdoor().darkFeatures().enableForSite("no.frother.assignee.field");
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @After
    public void tearDown() {
        this.administration.backdoor().darkFeatures().disableForSite("jira.no.frother.reporter.field");
        this.administration.backdoor().darkFeatures().disableForSite("no.frother.assignee.field");
        this.administration.backdoor().darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @Test
    public void testCustomFieldChangeAuthorPreservedDespiteRename() {
        this.navigation.login(BB);
        this.navigation.issue().setFreeTextCustomField(COW_2, SINGLE_USER_FIELD_ID, BB);
        this.navigation.issue().setFreeTextCustomField(COW_2, MULTI_USER_FIELD_ID, CC_CAT);
        this.assertChangeRecordedCorrectly(COW_2, 10800, BOB_BELCHER, SINGLE_USER_FIELD_NAME, NOTHING, BOB_BELCHER_ID_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly(COW_2, 10801, BOB_BELCHER, MULTI_USER_FIELD_ID, NOTHING, CANDY_CHAOS_CRAZY_CAT_CHANGE);
        this.navigation.login(ADMIN);
        this.renameUser(BB, BELCHYMAN);
        this.assertChangeRecordedCorrectly(COW_2, 10800, BOB_BELCHER, SINGLE_USER_FIELD_NAME, NOTHING, BOB_BELCHER_ID_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly(COW_2, 10801, BOB_BELCHER, MULTI_USER_FIELD_ID, NOTHING, CANDY_CHAOS_CRAZY_CAT_CHANGE);
        this.navigation.login(BETTY);
        this.navigation.issue().setFreeTextCustomField(COW_3, SINGLE_USER_FIELD_ID, CC);
        this.navigation.issue().setFreeTextCustomField(COW_3, MULTI_USER_FIELD_ID, CC_CAT);
        this.assertChangeRecordedCorrectly(COW_3, 10802, BETTY_BOOP, SINGLE_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_ID_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly(COW_3, 10803, BETTY_BOOP, MULTI_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_CRAZY_CAT_CHANGE);
        this.navigation.login(ADMIN);
        this.renameUser(BETTY, BB);
        this.renameUser(CAT, CRAZY);
        this.renameUser(CC, CANDY);
        this.navigation.issue().setFreeTextCustomField(COW_3, MULTI_USER_FIELD_ID, BB_CRAZY_CANDY);
        this.assertChangeRecordedCorrectly(COW_3, 10802, BETTY_BOOP, SINGLE_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_ID_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly(COW_3, 10803, BETTY_BOOP, MULTI_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_CRAZY_CAT_CHANGE);
        this.assertChangeRecordedCorrectly(COW_3, 10804, ADAM_ANT, MULTI_USER_FIELD_NAME, CANDY_CHAOS_CRAZY_CAT_CHANGE, BETTY_BOOP_CANDY_CHAOS_CRAZY_CAT_CHANGE);
        this.renameUser(CRAZY, MEOW);
        this.navigation.issue().setFreeTextCustomField(COW_3, SINGLE_USER_FIELD_ID, CANDY);
        this.navigation.issue().setFreeTextCustomField(COW_3, MULTI_USER_FIELD_ID, BB_MEOW_CANDY);
        Assert.assertFalse((boolean)this.locator.id(String.format(CHANGE_TABLE_ID, 10805)).exists());
    }

    @Test
    public void testReporterAndAssigneeAuthorUpdatedAfterRename() {
        this.backdoor.usersAndGroups().addUserToGroup(BB, JIRA_ADMINISTRATORS);
        this.backdoor.usersAndGroups().addUserToGroup(BETTY, JIRA_ADMINISTRATORS);
        this.navigation.login(BETTY);
        this.navigation.issue().gotoEditIssue(COW_4);
        this.tester.setFormElement(ASSIGNEE_FIELD, CAT);
        this.tester.setFormElement(REPORTER_FIELD, CC);
        this.tester.submit(UPDATE_BUTTON);
        HashMap<String, Change> expectedChanges = new HashMap<String, Change>();
        expectedChanges.put(ASSIGNEE, new Change(ADAM_ANT_SYSTEM_FIELD_DISPLAY, CRAZY_CAT_CAT_SYSTEM_FIELD_DISPLAY));
        expectedChanges.put(REPORTER, new Change(ADAM_ANT_SYSTEM_FIELD_DISPLAY, CANDY_CHAOS_CC_SYSTEM_FIELD_DISPLAY));
        this.assertChangeRecordedCorrectly(COW_4, 10800, BETTY_BOOP, expectedChanges);
        this.navigation.login(ADMIN);
        this.renameUser(BB, BELCHYMAN);
        this.renameUser(BETTY, BB);
        this.assertChangeRecordedCorrectly(COW_4, 10800, BETTY_BOOP, expectedChanges);
        this.renameUser(BB, BETTY);
        this.renameUser(BELCHYMAN, BB);
        this.navigation.login(BB);
        this.navigation.issue().gotoEditIssue(COW_1);
        this.tester.setFormElement(ASSIGNEE_FIELD, CAT);
        this.tester.setFormElement(REPORTER_FIELD, CC);
        this.tester.submit(UPDATE_BUTTON);
        expectedChanges.clear();
        expectedChanges.put(ASSIGNEE, new Change(BETTY_BOOP_SYSTEM_FIELD_DISPLAY, CRAZY_CAT_CAT_SYSTEM_FIELD_DISPLAY));
        expectedChanges.put(REPORTER, new Change(CRAZY_CAT_CAT_SYSTEM_FIELD_DISPLAY, CANDY_CHAOS_CC_SYSTEM_FIELD_DISPLAY));
        this.assertChangeRecordedCorrectly(COW_1, 10801, BOB_BELCHER, expectedChanges);
        this.navigation.login(ADMIN);
        this.renameUser(CAT, CRAZY);
        this.renameUser(BB, BELCHYMAN);
        this.renameUser(CC, CANDY);
        expectedChanges.clear();
        expectedChanges.put(ASSIGNEE, new Change(BETTY_BOOP_SYSTEM_FIELD_DISPLAY, CRAZY_CAT_CRAZY_SYSTEM_FIELD_DISPLAY));
        expectedChanges.put(REPORTER, new Change(CRAZY_CAT_CRAZY_SYSTEM_FIELD_DISPLAY, CANDY_CHAOS_CANDY_SYSTEM_FIELD_DISPLAY));
        this.assertChangeRecordedCorrectly(COW_1, 10801, BOB_BELCHER, expectedChanges);
        this.navigation.login(BELCHYMAN, BB);
        this.navigation.issue().assignIssue(COW_4, null, BOB_BELCHER);
        this.assertChangeRecordedCorrectly(COW_4, 10802, BOB_BELCHER, ASSIGNEE, CRAZY_CAT_CRAZY_SYSTEM_FIELD_DISPLAY, BOB_BELCHER_BELCHYMAN_SYSTEM_FIELD_DISPLAY);
        this.navigation.issue().gotoEditIssue(COW_4);
        this.tester.setFormElement(REPORTER_FIELD, BELCHYMAN);
        this.tester.submit(UPDATE_BUTTON);
        this.assertChangeRecordedCorrectly(COW_4, 10803, BOB_BELCHER, REPORTER, CANDY_CHAOS_CANDY_SYSTEM_FIELD_DISPLAY, BOB_BELCHER_BELCHYMAN_SYSTEM_FIELD_DISPLAY);
    }

    private void assertChangeRecordedCorrectly(String issueKey, int changeId, String expectedAuthorName, String fieldName, String oldValue, String newValue) {
        HashMap<String, Change> expectedChanges = new HashMap<String, Change>();
        expectedChanges.put(fieldName, new Change(oldValue, newValue));
        this.assertChangeRecordedCorrectly(issueKey, changeId, expectedAuthorName, expectedChanges);
    }

    private void assertChangeRecordedCorrectly(String issueKey, int changeId, String expectedAuthorName, Map<String, Change> changesByFieldName) {
        this.navigation.gotoPage(String.format(BROWSE_ISSUE_WITH_HISTORY_URL, issueKey));
        this.textAssertions.assertTextPresent(this.locator.id(String.format(AUTHOR_ID, changeId)), expectedAuthorName);
        HtmlTable changesTable = this.page.getHtmlTable(String.format(CHANGE_TABLE_ID, changeId));
        for (HtmlTable.Row row : changesTable.getRows()) {
            String field = row.getCellAsText(0);
            if (!changesByFieldName.containsKey(field)) continue;
            Change expectedChange = changesByFieldName.get(field);
            String actualOld = row.getCellAsText(1);
            String actualNew = row.getCellAsText(2);
            Assert.assertEquals((Object)((expectedChange.oldValue.length() > 0 ? "Original: " : NOTHING) + expectedChange.oldValue), (Object)actualOld);
            Assert.assertEquals((Object)((expectedChange.newValue.length() > 0 ? "New: " : NOTHING) + expectedChange.newValue), (Object)actualNew);
        }
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit(UPDATE_BUTTON);
    }

    private static class Change {
        public final String oldValue;
        public final String newValue;

        public Change(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

