/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.PROJECTS})
@LoginAs(user="admin")
public class TestUserRenameOnComments
extends BaseJiraFuncTest {
    public static final String ALL_USERS = "All Users";
    public static final String ISSUE_FOR_COMMENT = "COW-4";
    @Inject
    private Form form;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testRenamedUserRetainsCommentOwnership() {
        this.renameUser("cc", "sweetsmayhem");
        this.navigation.login("cat");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment(ALL_USERS, "Cat's comment");
        this.navigation.login("sweetsmayhem", "cc");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment(ALL_USERS, "My very own comment");
        this.navigation.login("admin");
        this.renameUser("sweetsmayhem", "cc");
        this.navigation.login("cc");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.assertCannotEdit(10300L);
        this.editComment(10301L, "I may do as I please with my own comment");
        this.textAssertions.assertTextPresent("I may do as I please with my own comment");
        this.assertCannotDelete(10300L);
        this.deleteComment(10301L);
        this.textAssertions.assertTextNotPresent("I may do as I please with my own comment");
    }

    @Test
    public void testRenamedUserCorrectlyDisplayedAsCommentAuthorAndEditor() throws InterruptedException {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-developers");
        this.navigation.login("betty");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment(ALL_USERS, "Comment by a renamed user");
        this.navigation.login("bb");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment(ALL_USERS, "Comment by a recycled user");
        Thread.sleep(1000L);
        this.editComment(10300L, "Bob Belcher edited this comment");
        this.navigation.login("admin");
        this.renameUser("betty", "bboop");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.assertCommenterDisplayNameIs(10300L, "Betty Boop");
        this.assertEditorDisplayNameIs(10300L, "Bob Belcher");
    }

    @Test
    public void testRenamedUserRetainsCommentingAndViewingPermissions() {
        this.backdoor.permissionSchemes().replaceGroupPermissions(0L, ProjectPermissions.ADD_COMMENTS, "jira-developers");
        this.navigation.login("cat");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment("Developers", "Crazy Cat can comment");
        this.textAssertions.assertTextPresent("Crazy Cat can comment");
        this.navigation.login("cc");
        this.assertCannotComment();
        this.navigation.login("admin");
        this.renameUser("cat", "feline");
        this.renameUser("cc", "cat");
        this.navigation.login("feline", "cat");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment("Developers", "Comment with new name");
        this.textAssertions.assertTextPresent("Comment with new name");
        this.navigation.login("cat", "cc");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.assertCannotComment();
    }

    @Test
    public void testRenamedUserIdentifiedAsCommenterAndUpdaterInCommentRESTResource() {
        this.navigation.login("cat");
        this.navigation.issue().gotoIssue(ISSUE_FOR_COMMENT);
        this.addComment(ALL_USERS, "cat commented");
        Issue cow2Representation = this.backdoor.issues().getIssue(ISSUE_FOR_COMMENT);
        Assert.assertEquals((Object)"cat", (Object)((Comment)cow2Representation.getComments().iterator().next()).author.name);
        this.navigation.login("admin");
        this.renameUser("cc", "candy");
        this.renameUser("cat", "crazy");
        cow2Representation = this.backdoor.issues().getIssue(ISSUE_FOR_COMMENT);
        Assert.assertEquals((Object)"crazy", (Object)((Comment)cow2Representation.getComments().iterator().next()).author.name);
    }

    private void assertCannotDelete(long commentId) {
        IdLocator deleteButtonLocator = this.locator.id("delete_comment_" + commentId);
        Assert.assertFalse((String)"User should not be allowed to delete this comment", (boolean)deleteButtonLocator.exists());
    }

    private void deleteComment(long commentId) {
        this.tester.clickLink("delete_comment_" + commentId);
        this.tester.submit("Delete");
    }

    private void editComment(long commentId, String newContent) {
        this.tester.clickLink("edit_comment_" + commentId);
        this.tester.setWorkingForm("comment-edit");
        this.tester.setFormElement("comment", newContent);
        this.tester.submit("Save");
    }

    private void assertCannotEdit(long commentId) {
        IdLocator editButtonLocator = this.locator.id("edit_comment_" + commentId);
        Assert.assertFalse((String)"User should not be allowed to edit this comment", (boolean)editButtonLocator.exists());
    }

    private void assertCannotComment() {
        Assert.assertFalse((boolean)this.locator.id("comment-issue").exists());
    }

    private void assertEditorDisplayNameIs(long commentId, String displayName) {
        CssLocator commentLocator = this.locator.css(String.format("#comment-%d .action-details .update-info", commentId));
        commentLocator.getNode().getAttributes();
        String editedNodeTitle = commentLocator.getNode().getAttributes().getNamedItem("title").getNodeValue();
        Assert.assertTrue((String)"The comment update author name was not as expected.", (boolean)editedNodeTitle.startsWith(displayName));
    }

    private void assertCommenterDisplayNameIs(long commentId, String displayName) {
        IdLocator commentLocator = this.locator.id(String.format("commentauthor_%d_verbose", commentId));
        this.textAssertions.assertTextPresent(commentLocator, displayName);
    }

    private void addComment(String visibleTo, String comment) {
        this.tester.clickLink("footer-comment-button");
        this.form.selectOption("commentLevel", visibleTo);
        this.tester.setFormElement("comment", comment);
        this.tester.submit();
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

