/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
@LoginAs(user="admin")
public class TestUserRenameOnFilters
extends BaseJiraFuncTest {
    private static final String OWNER_XPATH = "//tr[@id='mf_%d']/td[2]/span[@data-filter-field='owner-full-name']";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testFiltersShareWithRenamedUser() {
        this.administration.restoreData("TestSharedDashboards.xml");
        this.renameUser("anotherdev", "someotherdev");
        this.backdoor.usersAndGroups().addUser("anotherdev");
        this.backdoor.projectRole().deleteGroup("HSP", "Users", "jira-users");
        this.backdoor.projectRole().deleteGroup("MKY", "Users", "jira-users");
        this.navigation.login("someotherdev", "anotherdev");
        this.navigation.manageFilters().popularFilters();
        this.tester.assertElementPresent("mf_10004");
        this.tester.assertElementPresent("mf_10006");
        this.navigation.login("anotherdev");
        this.tester.assertElementNotPresent("mf_10004");
        this.tester.assertElementNotPresent("mf_10006");
    }

    @Test
    public void testRenamedUserRetainsFilterOwnership() {
        this.administration.restoreData("sharedfilters/TestBrowseFiltersShareType.xml");
        this.backdoor.issues().createIssue("MKY", "I'm just here for column order testing");
        this.navigation.login("developer");
        this.backdoor.columnControl().setLoggedInUserColumns(Arrays.asList("labels"));
        this.navigation.manageFilters().popularFilters();
        this.tester.clickLink("subscribe_c");
        this.tester.submit("Subscribe");
        this.navigation.login("admin");
        this.administration.sharedFilters().goTo();
        this.administration.sharedFilters().changeFilterOwner(10046L, "developer");
        this.renameUser("developer", "code monkey");
        this.backdoor.usersAndGroups().addUser("developer", "developer", "Dave Loper", "devdave@example.com");
        this.administration.sharedFilters().goTo();
        this.administration.sharedFilters().changeFilterOwner(10006L, "developer");
        this.navigation.login("code monkey", "developer");
        this.navigation.manageFilters().favouriteFilters();
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10080)), "developer the great and wise");
        this.navigation.manageFilters().popularFilters();
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10080)), "developer the great and wise");
        this.tester.assertElementPresent("mf_10054");
        this.navigation.manageFilters().myFilters();
        this.tester.assertElementPresent("mf_10080");
        this.tester.assertElementPresent("mf_10046");
        this.navigation.manageFilters().searchFilters();
        this.tester.submit("Search");
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10080)), "developer the great and wise");
        this.navigation.manageFilters().manageSubscriptions(10007);
        this.textAssertions.assertTextPresent(this.locator.css("table > tbody > tr > td"), "developer the great and wise");
        Assert.assertEquals((String)"Renamed user still have the same columns", (Object)"labels", (Object)this.backdoor.columnControl().getLoggedInUserColumns().get((int)0).value);
        this.navigation.gotoPage("secure/EditFilter!default.jspa?filterId=10080");
        this.tester.setFormElement("filterName", "I renamed this");
        this.tester.submit();
        this.navigation.manageFilters().myFilters();
        this.textAssertions.assertTextPresent(this.locator.id("mf_10080"), "I renamed this");
        this.navigation.manageFilters().deleteFilter(10046);
        this.tester.submit();
        this.navigation.manageFilters().myFilters();
        this.tester.assertElementNotPresent("mf_10046");
        this.navigation.gotoResource("../rest/api/2/filter/10080");
        this.tester.assertTextPresent("developer the great and wise");
        this.navigation.login("developer", "developer");
        this.navigation.manageFilters().popularFilters();
        this.textAssertions.assertTextPresent(this.locator.id("mf_10006"), "Dave Loper");
        this.navigation.manageFilters().favouriteFilters();
        this.tester.assertElementNotPresent("mf_10080");
        this.tester.assertElementNotPresent("mf_10054");
        this.navigation.manageFilters().myFilters();
        this.tester.assertElementPresent("mf_10006");
        this.navigation.manageFilters().searchFilters();
        this.tester.submit("Search");
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10006)), "Dave Loper");
        this.navigation.gotoResource("../rest/api/2/filter/10006");
        this.tester.assertTextPresent("Dave Loper");
        this.navigation.login("admin");
        this.administration.sharedFilters().goTo();
        this.tester.setFormElement("searchName", "b");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10006)), "Dave Loper");
        this.tester.setFormElement("searchName", "I renamed this");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.xpath(String.format(OWNER_XPATH, 10080)), "developer the great and wise");
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

