/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.table.HtmlTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
@LoginAs(user="admin")
public class TestUserRenameOnProject
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    private static final FeatureFlag JIRA_USERS_AND_ROLES_PAGE_IN_REACT = FeatureFlag.featureFlag((String)"jira.users.and.roles.page.in.react");

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename.xml");
    }

    @Test
    public void testJqlFunctionsFindRenamedProjectLeads() {
        this.backdoor.project().setProjectLead(10000L, "cat");
        this.renameUser("cat", "crazy");
        this.renameUser("bb", "cat");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=project%20in%20projectsLeadByUser(cat)");
        this.tester.assertTextPresent("\"total\":0");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=project%20in%20projectsLeadByUser(crazy)");
        this.tester.assertTextPresent("\"total\":4");
    }

    @Test
    public void testRenamedDefaultProjectLeadAsDefaultAssignee() {
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10000");
        FormParameterUtil leadEditForm = this.getLeadEditForm();
        leadEditForm.setFormElement("lead", "bb");
        leadEditForm.submitForm();
        String dummyIssueId = this.backdoor.issues().createIssue("COW", "Chew on some grass").key();
        this.navigation.gotoPage(String.format("browse/%s", dummyIssueId));
        this.assertions.assertNodeByIdHasText("assignee-val", "Bob Belcher");
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10000");
        leadEditForm = this.getLeadEditForm();
        leadEditForm.setFormElement("lead", "betty");
        leadEditForm.submitForm();
        dummyIssueId = this.backdoor.issues().createIssue("COW", "Chew on some more grass").key();
        this.navigation.gotoPage(String.format("browse/%s", dummyIssueId));
        this.assertions.assertNodeByIdHasText("assignee-val", "Betty Boop");
    }

    @Test
    public void testUserRenameOnCreateProjectScreens() {
        this.backdoor.darkFeatures().disableForSite(JIRA_USERS_AND_ROLES_PAGE_IN_REACT);
        this.backdoor.project().addProject("Feline", "CAT", "betty");
        this.tester.gotoPage("plugins/servlet/project-config/CAT/roles");
        this.assertions.assertNodeByIdHasText("projectLead_betty", "Betty Boop");
        this.tester.gotoPage("plugins/servlet/project-config/CAT/summary");
        this.assertions.assertNodeByIdHasText("projectLead_betty", "Betty Boop");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        HtmlTable projectsSummaryTable = this.page.getHtmlTable("project-list");
        Assert.assertEquals((Object)"Betty Boop", (Object)projectsSummaryTable.getRow(2).getCellForHeading("Project Lead"));
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10100");
        this.assertOptionTextSelected("lead", "Betty Boop");
        this.renameUser("betty", "bboop");
        this.tester.gotoPage("plugins/servlet/project-config/CAT/roles");
        this.assertions.assertNodeByIdHasText("projectLead_bboop", "Betty Boop");
        this.tester.gotoPage("plugins/servlet/project-config/CAT/summary");
        this.assertions.assertNodeByIdHasText("projectLead_bboop", "Betty Boop");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        projectsSummaryTable = this.page.getHtmlTable("project-list");
        Assert.assertEquals((Object)"Betty Boop", (Object)projectsSummaryTable.getRow(2).getCellForHeading("Project Lead"));
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10100");
        this.assertOptionTextSelected("lead", "Betty Boop");
        this.backdoor.darkFeatures().enableForSite(JIRA_USERS_AND_ROLES_PAGE_IN_REACT);
    }

    @Test
    public void testUserRenameOnUpdateProjectScreens() {
        this.backdoor.darkFeatures().disableForSite(JIRA_USERS_AND_ROLES_PAGE_IN_REACT);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        HtmlTable projectsSummaryTable = this.page.getHtmlTable("project-list");
        Assert.assertEquals((Object)"Adam Ant", (Object)projectsSummaryTable.getRow(1).getCellForHeading("Project Lead"));
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10000");
        this.assertOptionTextSelected("lead", "Adam Ant");
        FormParameterUtil leadEditForm = this.getLeadEditForm();
        leadEditForm.setFormElement("lead", "bb");
        leadEditForm.submitForm();
        this.tester.gotoPage("plugins/servlet/project-config/COW/roles");
        this.assertions.assertNodeByIdHasText("projectLead_bb", "Bob Belcher");
        this.tester.gotoPage("plugins/servlet/project-config/COW/summary");
        this.assertions.assertNodeByIdHasText("projectLead_bb", "Bob Belcher");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        projectsSummaryTable = this.page.getHtmlTable("project-list");
        Assert.assertEquals((Object)"Bob Belcher", (Object)projectsSummaryTable.getRow(1).getCellForHeading("Project Lead"));
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10000");
        this.assertOptionTextSelected("lead", "Bob Belcher");
        leadEditForm = this.getLeadEditForm();
        leadEditForm.setFormElement("lead", "betty");
        leadEditForm.submitForm();
        this.tester.gotoPage("plugins/servlet/project-config/COW/roles");
        this.assertions.assertNodeByIdHasText("projectLead_betty", "Betty Boop");
        this.tester.gotoPage("plugins/servlet/project-config/COW/summary");
        this.assertions.assertNodeByIdHasText("projectLead_betty", "Betty Boop");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        projectsSummaryTable = this.page.getHtmlTable("project-list");
        Assert.assertEquals((Object)"Betty Boop", (Object)projectsSummaryTable.getRow(1).getCellForHeading("Project Lead"));
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10000");
        this.assertOptionTextSelected("lead", "Betty Boop");
        this.backdoor.darkFeatures().enableForSite(JIRA_USERS_AND_ROLES_PAGE_IN_REACT);
    }

    @Test
    public void testRenamedProjectLeadCanNotBeDeleted() {
        this.administration.restoreData("user_rename_doggy_components.xml");
        String bettysProjectName = "Canine";
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("betty"));
        this.textAssertions.assertTextPresent(deleteUserPage.getProjectLink(), "Canine");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        this.textAssertions.assertTextNotPresent(deleteUserPage.getProjectLink(), "Canine");
        this.renameUser("bb", "belchyman");
        this.renameUser("betty", "bb");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        this.textAssertions.assertTextPresent(deleteUserPage.getProjectLink(), "Canine");
    }

    private void assertOptionTextSelected(String selectId, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, String.format("//select[@id='%s']/option[@selected='selected']", selectId));
        Assert.assertTrue((boolean)locator.exists());
        this.textAssertions.assertTextPresent(locator, textToTest);
    }

    private void assertNodeHasText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((boolean)locator.exists());
        this.textAssertions.assertTextPresent(locator, textToTest);
    }

    private FormParameterUtil getLeadEditForm() {
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"admin", "Adam Ant"});
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"betty", "Betty Boop"});
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"bb", "Bob Belcher"});
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"cat", "Crazy Cat"});
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"cc", "Candy Chaos"});
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"admin"});
        return formParameterUtil;
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

