/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.JQL, Category.CHANGE_HISTORY})
@Restore(value="user_rename_search.xml")
public class TestUserRenameOnSearch
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "betty");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "cc");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "", "COW-4", "COW-3", "COW-2", "COW-1");
    }

    @Test
    public void testCurrentAssigneeAndReporter() {
        this.issueTableAssertions.assertSearchWithResults("assignee = currentUser()", "COW-4");
        this.issueTableAssertions.assertSearchWithResults("assignee = admin", "COW-4");
        this.issueTableAssertions.assertSearchWithResults("assignee = bb", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("assignee = betty", "COW-1");
        this.assertBadValueWarning("assignee = candy", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee = cat", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("assignee = cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee in (betty,bb)", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee in (admin,bb)", "COW-4", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("assignee in (currentUser(),bb)", "COW-4", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter = currentUser()", "COW-4");
        this.issueTableAssertions.assertSearchWithResults("reporter = admin", "COW-4");
        this.issueTableAssertions.assertSearchWithResults("reporter = bb", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter = betty", new String[0]);
        this.assertBadValueWarning("reporter = candy", "reporter", "candy");
        this.issueTableAssertions.assertSearchWithResults("reporter = cat", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter = cc", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter in (cc,cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter in (admin,cat)", "COW-4", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter in (currentUser(),cat)", "COW-4", "COW-2", "COW-1");
    }

    @Test
    public void testCurrentCustomFieldValue() {
        this.issueTableAssertions.assertSearchWithResults("tester = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("tester = admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("tester = bb", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("tester = betty", new String[0]);
        this.assertBadValueWarning("tester = candy", "tester", "candy");
        this.issueTableAssertions.assertSearchWithResults("tester = cat", "COW-3", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("tester = cc", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("tester in (cc,cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("tester in (admin,cat)", "COW-3", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("tester in (currentUser(),cat)", "COW-3", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("cc = currentUser()", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc = admin", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc = bb", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc = betty", "COW-3");
        this.assertBadValueWarning("cc = candy", "cc", "candy");
        this.issueTableAssertions.assertSearchWithResults("cc = cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("cc = cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("cc in (cc,cat)", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("cc in (admin,cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc in (currentUser(),cat)", "COW-3", "COW-2", "COW-1");
    }

    @Test
    public void testVotersAndWatchers() {
        this.initVotersAndWatchers("betty", "bb");
        this.issueTableAssertions.assertSearchWithResults("voter = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter = admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter = bb", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("voter = betty", "COW-1");
        this.assertBadValueWarning("voter = candy", "voter", "candy");
        this.issueTableAssertions.assertSearchWithResults("voter = cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter = cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter in (bb,betty)", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("voter in (admin,bb)", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("voter in (currentUser(),bb)", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("watcher = currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("watcher = admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("watcher = bb", "COW-4");
        this.issueTableAssertions.assertSearchWithResults("watcher = betty", "COW-2");
        this.assertBadValueWarning("watcher = candy", "watcher", "candy");
        this.issueTableAssertions.assertSearchWithResults("watcher = cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("watcher = cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("watcher in (bb,betty)", "COW-4", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("watcher in (admin,bb)", "COW-4", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("watcher in (currentUser(),bb)", "COW-4", "COW-3", "COW-2", "COW-1");
    }

    @Test
    public void testChangedBy() {
        this.issueTableAssertions.assertSearchWithResults("reporter changed by admin", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed by bb", "COW-3", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("reporter changed by cat", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter changed by cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed by admin", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee changed by bb", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("assignee changed by cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed by cc", new String[0]);
        this.assertByClauseError("reporter changed by asdfasdf", "asdfasdf");
        this.assertByClauseError("assignee changed by candy", "candy");
    }

    @Test
    public void testWasClauseForAssigneeAndReporter() {
        this.issueTableAssertions.assertSearchWithResults("assignee was currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee was admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertBadValueError("assignee was asdfasdf", "assignee", "asdfasdf");
        this.issueTableAssertions.assertSearchWithResults("assignee was bb", "COW-3");
        this.assertBadValueError("assignee was candy", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee was cat", "COW-2");
        this.assertBadValueError("assignee was in (candy, cat)", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee was cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter was currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter was admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertBadValueError("reporter was asdfasdf", "reporter", "asdfasdf");
        this.issueTableAssertions.assertSearchWithResults("reporter was bb", "COW-3");
        this.assertBadValueError("reporter was candy", "reporter", "candy");
        this.issueTableAssertions.assertSearchWithResults("reporter was cat", "COW-2", "COW-1");
        this.assertBadValueError("reporter was in (candy, cat)", "reporter", "candy");
        this.issueTableAssertions.assertSearchWithResults("reporter was cc", "COW-3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBettyAndCandy(String goodBetty, String badBetty, String goodCandy, String badCandy) {
        this.issueTableAssertions.assertSearchWithResults("assignee = " + goodCandy, new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed by " + goodBetty + "", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee was " + goodBetty + "", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee was in (" + goodBetty + ", cat)", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee was in (" + goodCandy + ", " + goodBetty + ")", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee changed from " + goodBetty + "", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed to " + goodBetty + "", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter = " + goodCandy, "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter in (" + goodCandy + ", cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter was " + goodBetty + "", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter was in (" + goodBetty + ", cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter was in (" + goodCandy + ", " + goodBetty + ")", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed by " + goodBetty + "", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from " + goodBetty + "", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed to " + goodBetty + "", "COW-3", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from bb to " + goodBetty + "", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from " + goodBetty + " to bb", new String[0]);
        this.assertBadValueError("reporter changed from " + goodBetty + " to " + badCandy, "reporter", badCandy);
        this.issueTableAssertions.assertSearchWithResults("reporter changed from " + goodBetty + " to cat", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from " + goodBetty + " to " + goodCandy, "COW-3");
        this.issueTableAssertions.assertSearchWithResults("tester = " + goodCandy, "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc = " + goodCandy, new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter = " + goodCandy, "COW-1");
        this.issueTableAssertions.assertSearchWithResults("watcher = " + goodCandy, "COW-2");
        this.issueTableAssertions.assertSearchWithResults("voter = " + goodBetty, "COW-3");
        this.issueTableAssertions.assertSearchWithResults("watcher = " + goodBetty, "COW-4");
        this.assertBadValueWarning("assignee = " + badCandy, "assignee", badCandy);
        this.assertByClauseError("assignee changed by " + badBetty, badBetty);
        this.assertBadValueError("assignee changed to " + badBetty, "assignee", badBetty);
        this.assertBadValueWarning("reporter = " + badCandy, "reporter", badCandy);
        this.assertByClauseError("reporter changed by " + badBetty, badBetty);
        this.assertBadValueError("reporter changed from " + badBetty, "reporter", badBetty);
        this.assertBadValueWarning("tester = " + badCandy, "tester", badCandy);
        this.assertBadValueWarning("cc = " + badCandy, "cc", badCandy);
        this.assertBadValueWarning("voter = " + badCandy, "voter", badCandy);
        this.assertBadValueWarning("watcher = " + badCandy, "watcher", badCandy);
        try {
            this.backdoor.issueTableClient().loginAs(goodBetty, "betty");
            this.assertCurrentUserQueryResultsForBetty();
            this.backdoor.issueTableClient().loginAs(goodCandy, "cc");
            this.assertCurrentUserQueryResultsForCandy();
        }
        finally {
            this.backdoor.issueTableClient().loginAs("admin");
        }
    }

    private void assertCurrentUserQueryResultsForBetty() {
        this.issueTableAssertions.assertSearchWithResults("assignee = currentUser()", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter in (currentUser(), cat)", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("tester = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("cc = currentUser()", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("voter = currentUser()", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("watcher = currentUser()", "COW-4");
    }

    private void assertCurrentUserQueryResultsForCandy() {
        this.issueTableAssertions.assertSearchWithResults("assignee = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter = currentUser()", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter in (currentUser(), cat)", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("tester = currentUser()", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("cc = currentUser()", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("voter = currentUser()", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("watcher = currentUser()", "COW-2");
    }

    @Test
    public void testChangedFromAndToForAssigneeAndReporter() {
        this.issueTableAssertions.assertSearchWithResults("assignee changed from admin", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("assignee changed from bb", new String[0]);
        this.assertBadValueError("assignee changed from candy", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee changed from cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed from cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed to admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed to bb", "COW-3");
        this.assertBadValueError("assignee changed to candy", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee changed to cat", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("assignee changed to cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed from admin to cat", "COW-2");
        this.issueTableAssertions.assertSearchWithResults("assignee changed from admin to cc", new String[0]);
        this.assertBadValueError("assignee changed from admin to candy", "assignee", "candy");
        this.issueTableAssertions.assertSearchWithResults("assignee changed from cat to admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee changed from cc to admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter changed from admin", "COW-3", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from bb", "COW-3");
        this.assertBadValueError("reporter changed from candy", "reporter", "candy");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from cat", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter changed from cc", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter changed to admin", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter changed to bb", "COW-3");
        this.assertBadValueError("reporter changed to candy", "reporter", "candy");
        this.issueTableAssertions.assertSearchWithResults("reporter changed to cat", "COW-2", "COW-1");
        this.issueTableAssertions.assertSearchWithResults("reporter changed to cc", "COW-3");
        this.issueTableAssertions.assertSearchWithResults("reporter changed from admin to cat", "COW-2");
        this.assertBadValueError("reporter changed from admin to candy", "reporter", "candy");
    }

    private void initVotersAndWatchers(String user1, String user2) {
        try {
            this.navigation.logout();
            this.navigation.login(user1);
            this.navigation.issue().viewIssue("COW-1").toggleVote();
            this.navigation.issue().viewIssue("COW-2").toggleWatch();
            this.navigation.logout();
            this.navigation.login(user2);
            this.navigation.issue().viewIssue("COW-3").toggleVote();
            this.navigation.issue().viewIssue("COW-4").toggleWatch();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
    }

    @Test
    public void testRenameUser() {
        this.initVotersAndWatchers("cc", "betty");
        this.checkBettyAndCandy("betty", "boop", "cc", "candy");
        this.renameUser("cc", "candy");
        this.renameUser("betty", "boop");
        this.checkBettyAndCandy("boop", "betty", "candy", "cc");
    }

    private void renameUser(String oldUsername, String newUsername) {
        this.administration.usersAndGroups().gotoEditUser(oldUsername).setUsername(newUsername).submitUpdate();
        Assert.assertEquals((Object)("/secure/admin/user/ViewUser.jspa?name=" + newUsername), (Object)this.navigation.getCurrentPage());
        Assert.assertEquals((Object)newUsername, (Object)this.locator.id("username").getText());
    }

    private void assertByClauseError(String jqlQuery, String badUser) {
        String expectedMessage = "The user '" + badUser + "' does not exist and cannot be used in the 'by' predicate.";
        this.issueTableAssertions.assertSearchWithError(jqlQuery, expectedMessage);
    }

    private void assertBadValueError(String jqlQuery, String badField, String badValue) {
        String expectedMessage = "The value '" + badValue + "' does not exist for the field '" + badField + "'.";
        this.issueTableAssertions.assertSearchWithError(jqlQuery, expectedMessage);
    }

    private void assertBadValueWarning(String jqlQuery, String badField, String badValue) {
        String expectedMessage = "The value '" + badValue + "' does not exist for the field '" + badField + "'.";
        this.issueTableAssertions.assertSearchWithWarning(jqlQuery, expectedMessage);
    }
}

