/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestUserRenameOnWorkflow
extends BaseJiraFuncTest {
    public static final String DAIRY_COMPONENT_ID = "10000";
    public static final String BEEF_COMPONENT_ID = "10001";
    @Inject
    private Administration administration;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename_post_functions.xml");
    }

    @Test
    public void testPostFunctionAssignsToRenamedUser() {
        HashMap<String, String[]> withDairyComponent = new HashMap<String, String[]>();
        HashMap<String, String[]> withBeefComponent = new HashMap<String, String[]>();
        withDairyComponent.put("components", new String[]{DAIRY_COMPONENT_ID});
        withBeefComponent.put("components", new String[]{BEEF_COMPONENT_ID});
        this.renameUser("bb", "robert");
        this.renameUser("betty", "bboop");
        this.navigation.login("robert", "bb");
        String dairyIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Milk Old Bessie", withDairyComponent);
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.navigation.clickLinkWithExactText("Assign To Me");
        this.workflowUtil.clickAction("action_id_4");
        Assert.assertEquals((Object)"bboop", (Object)this.assigneeOf(dairyIssueKey));
        this.navigation.issue().resolveIssue(dairyIssueKey, "Fixed", "Old Bessie was not cooperative, but the deed is done.");
        Assert.assertEquals((Object)"robert", (Object)this.assigneeOf(dairyIssueKey));
        this.navigation.issue().reopenIssue(dairyIssueKey);
        Assert.assertEquals((Object)"bboop", (Object)this.assigneeOf(dairyIssueKey));
        this.navigation.login("bboop", "betty");
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.workflowUtil.clickAction("action_id_4");
        Assert.assertEquals((Object)"bboop", (Object)this.assigneeOf(dairyIssueKey));
        this.navigation.login("robert", "bb");
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.workflowUtil.clickAction("action_id_301");
        Assert.assertEquals((Object)"robert", (Object)this.assigneeOf(dairyIssueKey));
        String beefIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Slaughter the young heifer.", withBeefComponent);
        this.navigation.issue().resolveIssue(beefIssueKey, "Won't Fix", "I couldn't bring myself to do it!");
        this.navigation.issue().reopenIssue(beefIssueKey);
        Assert.assertEquals((Object)"robert", (Object)this.assigneeOf(beefIssueKey));
        String calvingIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Breed Bessie and Buster");
        this.navigation.issue().resolveIssue(calvingIssueKey, "Cannot Reproduce", "They cannot reproduce");
        this.navigation.issue().reopenIssue(calvingIssueKey);
        Assert.assertEquals((Object)"robert", (Object)this.assigneeOf(calvingIssueKey));
    }

    private String assigneeOf(String key) {
        return this.backdoor.issues().getIssue((String)key).fields.assignee.name;
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

