/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.ProgressBar;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.restclient.ChangeLog;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.Assert;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractTestWorkflowSchemeMigration
extends BaseJiraFuncTest {
    protected static final String TEST_PROJECT_NAME = "Test Project";
    protected static final String TEST_PROJECT_KEY = "TST";
    protected static final String HOMOSAPIEN_PROJECT_NAME = "homosapien";
    protected static final String SOURCE_WORKFLOW_SCHEME = "Source Workflow Scheme";
    protected static final String DESTINATION_WORKFLOW_SCHEME = "Destination Workflow Scheme";
    protected static final String REOPENED_STATUS_NAME = "Reopened";
    protected static final String WORKFLOW_HOMOSAPIEN_SOURCE_1 = "Homosapien Source 1";
    protected static final String WORKFLOW_HOMOSPIEN_DESTINATION = "Homospien Destination";
    protected static final String WORKFLOW_HOMOSAPIEN_SOURCE_2 = "Homosapien Source 2";
    protected static final String WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE = "Homosapien Custom Issue Type Source";
    protected static final String WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION = "Homosapien Custom Issue Type Destination";
    protected static final String TRANSITION_NAME_GO_CUSTOM = "Go Custom";
    protected static final String ACKNOWLEDGE = "Acknowledge";
    protected static final String DONE = "Done";
    protected static final String WORKFLOW_FIELD_ID = "Workflow";
    protected static final String SUMMARY_FIELD_ID = "summary";
    protected static final String RESOLUTION_FIELD_ID = "resolution";
    protected static final String STATUS_FIELD_ID = "status";
    protected static final String FIX_VERSIONS_FIELD_ID = "Fix Version";
    protected static final String CUSTOM_STATUS_1 = "Custom Status 1";
    protected static final String CUSTOM_STATUS_2 = "Custom Status 2";
    protected static final String CUSTOM_STATUS_3 = "Custom Status 3";
    protected static final String CUSTOM_STATUS_4 = "Custom Status 4";
    protected static final String RESOLVED_STATUS_NAME = "Resolved";
    protected static final String CLOSED_STATUS_NAME = "Closed";
    protected static final String IN_PROGRESS_STATUS_NAME = "In Progress";
    protected static final String DESTINATION_WORKFLOW = "Destinatiom Workflow";
    protected static final String JIRA_DEFAULT_WORKFLOW = "jira";
    protected static final String SOURCE_WORKFLOW_1 = "Source Workflow 1";
    protected static final String SOURCE_WORKFLOW_2 = "Source Workflow 2";
    @Inject
    protected LocatorFactory locator;
    @Inject
    private ProgressBar progressBar;

    protected static ChangeLog.HistoryItem item(String field, String from, String to) {
        return new ChangeLog.HistoryItem().setField(field).setFromString(from).setToString(to);
    }

    private static String getText(Node option) {
        return StringUtils.stripToNull((String)DomKit.getCollapsedText(option));
    }

    protected Map<String, String> createTestWorkflowMigrationMapping() {
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", CUSTOM_STATUS_3);
        statusMapping.put("mapping_1_10001", CUSTOM_STATUS_4);
        statusMapping.put("mapping_4_1", CUSTOM_STATUS_3);
        statusMapping.put("mapping_4_3", RESOLVED_STATUS_NAME);
        statusMapping.put("mapping_4_6", CUSTOM_STATUS_4);
        statusMapping.put("mapping_2_1", CUSTOM_STATUS_3);
        statusMapping.put("mapping_2_3", RESOLVED_STATUS_NAME);
        statusMapping.put("mapping_2_6", CUSTOM_STATUS_4);
        return statusMapping;
    }

    protected void assertStandardIssues(String projectKey) {
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-1"), true);
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-2"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue(projectKey + "-3"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-4"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_3)).assertIssue(this.getIssue(projectKey + "-5"), true);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-6"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CLOSED_STATUS_NAME, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-7"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue(projectKey + "-8"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addTransitions("Reopen Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-9"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_3)).assertIssue(this.getIssue(projectKey + "-10"), true);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_3)).assertIssue(this.getIssue(projectKey + "-11"), true);
        this.assertJqlResults("updated >-1d and project = " + projectKey, projectKey + "-3", projectKey + "-4", projectKey + "-5", projectKey + "-6", projectKey + "-7", projectKey + "-8", projectKey + "-10", projectKey + "-11");
        this.assertJqlResults("status = OPEN and project = " + projectKey, projectKey + "-1", projectKey + "-2");
        this.assertJqlResults("status in (OPEN, CLOSED) and project = " + projectKey, projectKey + "-1", projectKey + "-2", projectKey + "-9");
        this.assertJqlResults("status in ('Custom Status 4') and project = " + projectKey, projectKey + "-7", projectKey + "-6", projectKey + "-4");
    }

    protected Issue getIssue(String issueKey) {
        return this.getBackdoor().issues().getIssue(issueKey, new Issue.Expand[]{Issue.Expand.changelog, Issue.Expand.transitions});
    }

    protected void assertJqlResults(String jql, String ... expectedKeys) {
        SearchResult searchResult = this.getBackdoor().search().getSearch(new SearchRequest().jql(jql).fields(new String[]{"key"}));
        HashSet actualKeys = Sets.newHashSet((Iterable)Iterables.transform((Iterable)searchResult.issues, input -> input.key));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])expectedKeys), (Object)actualKeys);
    }

    protected void assertIssuesAfterMigrationWithUnupdatedWorkflowScheme() {
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("TST-1"), false);
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("TST-2"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-3"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-4"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-5"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-6"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-7"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-8"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addTransitions("Reopen Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("TST-9"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-10"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue("TST-11"), false);
    }

    protected void assertIssuesMigratedAndChangeHistory(String projectKey) {
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-1"), false);
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-2"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue(projectKey + "-3"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-4"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-5"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-6"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Go 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CLOSED_STATUS_NAME, CUSTOM_STATUS_4)).assertIssue(this.getIssue(projectKey + "-7"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue(projectKey + "-8"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addTransitions("Reopen Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_1, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-9"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW)).assertIssue(this.getIssue(projectKey + "-10"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, SOURCE_WORKFLOW_2, DESTINATION_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_3)).assertIssue(this.getIssue(projectKey + "-11"), false);
    }

    protected void assertMappingAndSelectOptionsForHalfMigratedDataNewDestination() throws SAXException {
        ImmutableMap typeMappings = Maps.uniqueIndex(this.mappings(), (Function)new Function<IssueTypeMapping, String>(){

            public String apply(IssueTypeMapping input) {
                return input.issueType;
            }
        });
        IssueTypeMapping mapping = (IssueTypeMapping)typeMappings.get("Bug");
        Assert.assertEquals((Object)WORKFLOW_HOMOSAPIEN_SOURCE_1, (Object)mapping.oldWorkflow);
        Assert.assertEquals((Object)WORKFLOW_HOMOSPIEN_DESTINATION, (Object)mapping.newWorkflow);
        this.assertStatusMappings((List<String>)ImmutableList.of((Object)IN_PROGRESS_STATUS_NAME, (Object)CLOSED_STATUS_NAME, (Object)CUSTOM_STATUS_1, (Object)CUSTOM_STATUS_2), (List<String>)ImmutableList.of((Object)"Open", (Object)CUSTOM_STATUS_3, (Object)CUSTOM_STATUS_4, (Object)RESOLVED_STATUS_NAME), mapping);
        this.tester.selectOption("mapping_1_3", "Open");
        this.tester.selectOption("mapping_1_6", RESOLVED_STATUS_NAME);
        this.tester.selectOption("mapping_1_10000", CUSTOM_STATUS_3);
        this.tester.selectOption("mapping_1_10001", CUSTOM_STATUS_4);
        this.tester.assertFormElementNotPresent("mapping_1_10003");
        mapping = (IssueTypeMapping)typeMappings.get("Improvement");
        Assert.assertEquals((Object)WORKFLOW_HOMOSAPIEN_SOURCE_2, (Object)mapping.oldWorkflow);
        Assert.assertEquals((Object)"Jira Workflow (jira)", (Object)mapping.newWorkflow);
        this.assertStatusMappings((List<String>)ImmutableList.of((Object)CUSTOM_STATUS_1, (Object)CUSTOM_STATUS_3), (List<String>)ImmutableList.of((Object)"Open", (Object)IN_PROGRESS_STATUS_NAME, (Object)RESOLVED_STATUS_NAME, (Object)REOPENED_STATUS_NAME, (Object)CLOSED_STATUS_NAME), mapping);
        this.tester.selectOption("mapping_4_10000", IN_PROGRESS_STATUS_NAME);
        this.tester.selectOption("mapping_4_10002", RESOLVED_STATUS_NAME);
        this.tester.assertTextNotPresent("New Feature");
        mapping = (IssueTypeMapping)typeMappings.get("Task");
        Assert.assertEquals((Object)WORKFLOW_HOMOSPIEN_DESTINATION, (Object)mapping.oldWorkflow);
        Assert.assertEquals((Object)WORKFLOW_HOMOSPIEN_DESTINATION, (Object)mapping.newWorkflow);
        this.assertStatusMappings((List<String>)ImmutableList.of((Object)IN_PROGRESS_STATUS_NAME, (Object)CLOSED_STATUS_NAME), (List<String>)ImmutableList.of((Object)"Open", (Object)CUSTOM_STATUS_3, (Object)CUSTOM_STATUS_4, (Object)RESOLVED_STATUS_NAME), mapping);
        this.tester.selectOption("mapping_3_3", CUSTOM_STATUS_3);
        this.tester.selectOption("mapping_3_6", RESOLVED_STATUS_NAME);
        mapping = (IssueTypeMapping)typeMappings.get("Sub-task");
        Assert.assertEquals((Object)WORKFLOW_HOMOSAPIEN_SOURCE_1, (Object)mapping.oldWorkflow);
        Assert.assertEquals((Object)WORKFLOW_HOMOSPIEN_DESTINATION, (Object)mapping.newWorkflow);
        this.assertStatusMappings((List<String>)ImmutableList.of((Object)CUSTOM_STATUS_1, (Object)CUSTOM_STATUS_2), (List<String>)ImmutableList.of((Object)"Open", (Object)CUSTOM_STATUS_3, (Object)CUSTOM_STATUS_4, (Object)RESOLVED_STATUS_NAME), mapping);
        this.tester.selectOption("mapping_5_10000", CUSTOM_STATUS_3);
        this.tester.selectOption("mapping_5_10001", CUSTOM_STATUS_4);
        this.tester.assertTextNotPresent("Custom Issue Type");
    }

    private void assertStatusMappings(List<String> oldStatuses, List<String> targetStatuses, IssueTypeMapping mapping) {
        ArrayList actualOldStatuses = Lists.newArrayList();
        for (StatusMapping statusMapping : mapping.statusMappings) {
            Assert.assertEquals(targetStatuses, (Object)statusMapping.newStatuses);
            actualOldStatuses.add(statusMapping.oldStatus);
        }
        Assert.assertEquals(oldStatuses, (Object)actualOldStatuses);
    }

    protected void assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination() {
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-1"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-2"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, "Open")).assertIssue(this.getIssue("HSP-3"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, "Open")).assertIssue(this.getIssue("HSP-4"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-5"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-6"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CLOSED_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue("HSP-7"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CLOSED_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue("HSP-8"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-9"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-10"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-11"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-12"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-13"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-14"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-15"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-16"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-17"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-18"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-19"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CLOSED_STATUS_NAME, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue("HSP-20"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").assertIssue(this.getIssue("HSP-21"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-22"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_3, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-23"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_4, RESOLVED_STATUS_NAME), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID.toLowerCase(Locale.ENGLISH), null, "Fixed")).assertIssue(this.getIssue("HSP-24"), false);
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("HSP-25"), false);
        new IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("HSP-26"), false);
        new IssueAssertions().status(IN_PROGRESS_STATUS_NAME).addTransitions("Stop Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, IN_PROGRESS_STATUS_NAME)).assertIssue(this.getIssue("HSP-27"), false);
        new IssueAssertions().status(IN_PROGRESS_STATUS_NAME).addTransitions("Stop Progress", "Resolve Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, IN_PROGRESS_STATUS_NAME)).assertIssue(this.getIssue("HSP-28"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_3, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue("HSP-29"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen Issue", "Close Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_3, RESOLVED_STATUS_NAME)).assertIssue(this.getIssue("HSP-30"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addTransitions("Reopen Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("HSP-31"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addTransitions("Reopen Issue").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_2, JIRA_DEFAULT_WORKFLOW)).assertIssue(this.getIssue("HSP-32"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").assertIssue(this.getIssue("HSP-33"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").assertIssue(this.getIssue("HSP-34"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(SUMMARY_FIELD_ID, "In Progress New Feature 1", "Custom Status 3 New Feature 1")).assertIssue(this.getIssue("HSP-35"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(SUMMARY_FIELD_ID, "In Progress New Feature 2", "Custom Status 3 New Feature 2")).assertIssue(this.getIssue("HSP-36"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_3, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-37"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_3, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-38"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_4, RESOLVED_STATUS_NAME), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Fixed")).assertIssue(this.getIssue("HSP-39"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_4, RESOLVED_STATUS_NAME), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Fixed")).assertIssue(this.getIssue("HSP-40"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-41"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-42"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-43"), false);
        new IssueAssertions().status("Open").addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-44"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-45"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_1, CUSTOM_STATUS_3)).assertIssue(this.getIssue("HSP-46"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Go custom 4").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)).assertIssue(this.getIssue("HSP-47"), false);
        new IssueAssertions().status(CUSTOM_STATUS_4).addTransitions("Resolve").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, CUSTOM_STATUS_2, CUSTOM_STATUS_4)).assertIssue(this.getIssue("HSP-48"), false);
        new IssueAssertions().status("Open").addTransitions("Go custom").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-49"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Close").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-50"), false);
        new IssueAssertions().status("Open").addTransitions("Go custom").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-51"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-52"), false);
        new IssueAssertions().status(RESOLVED_STATUS_NAME).addTransitions("Go Custom 3").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-53"), false);
        new IssueAssertions().status(CUSTOM_STATUS_3).addTransitions("Close").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(WORKFLOW_FIELD_ID, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)).assertIssue(this.getIssue("HSP-54"), false);
    }

    protected void checkIssuesInTestProjectAfterHalfMigratedDataNewDestination() {
        new IssueAssertions().status("Open").addTransitions("Start Progress").assertIssue(this.getIssue("TST-1"), false);
        new IssueAssertions().status("Open").addTransitions("Start Progress").addHistoryItems(AbstractTestWorkflowSchemeMigration.item("assignee", "Developer User", "Admin")).assertIssue(this.getIssue("TST-2"), false);
        new IssueAssertions().status(IN_PROGRESS_STATUS_NAME).addTransitions("Stop Progress", "Close").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", IN_PROGRESS_STATUS_NAME)).assertIssue(this.getIssue("TST-3"), false);
        new IssueAssertions().status(CUSTOM_STATUS_2).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_2), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Incomplete")).assertIssue(this.getIssue("TST-4"), false);
        new IssueAssertions().status("Open").addTransitions(TRANSITION_NAME_GO_CUSTOM).assertIssue(this.getIssue("TST-5"), false);
        new IssueAssertions().status(CUSTOM_STATUS_2).addTransitions("Reopen").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", CUSTOM_STATUS_2), AbstractTestWorkflowSchemeMigration.item(FIX_VERSIONS_FIELD_ID, null, "Version 1"), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Fixed")).assertIssue(this.getIssue("TST-6"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, CLOSED_STATUS_NAME), AbstractTestWorkflowSchemeMigration.item(FIX_VERSIONS_FIELD_ID, null, "Version 1"), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Cannot Reproduce")).assertIssue(this.getIssue("TST-7"), false);
        new IssueAssertions().status(IN_PROGRESS_STATUS_NAME).addTransitions("Stop Progress", "Close").addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, "Open", IN_PROGRESS_STATUS_NAME)).assertIssue(this.getIssue("TST-8"), false);
        new IssueAssertions().status(CLOSED_STATUS_NAME).addHistoryItems(AbstractTestWorkflowSchemeMigration.item(STATUS_FIELD_ID, IN_PROGRESS_STATUS_NAME, CLOSED_STATUS_NAME), AbstractTestWorkflowSchemeMigration.item(FIX_VERSIONS_FIELD_ID, null, "Version 3"), AbstractTestWorkflowSchemeMigration.item(RESOLUTION_FIELD_ID, null, "Won't Fix")).assertIssue(this.getIssue("TST-9"), false);
        new IssueAssertions().status("Open").addTransitions(TRANSITION_NAME_GO_CUSTOM).assertIssue(this.getIssue("TST-10"), false);
        new IssueAssertions().status("Open").addTransitions(TRANSITION_NAME_GO_CUSTOM).assertIssue(this.getIssue("TST-11"), false);
    }

    protected void waitForFailedMigration() {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                Assert.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().getResponsePageTitle().contains("WORKFLOW ASSOCIATION ERROR")) {
                    return;
                }
                Assert.fail((String)"Page encountered during migration that was not expected");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected void waitForSuccessfulWorkflowActivation(String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                Assert.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                    this.progressBar.validateProgressBarUI(DONE);
                    this.tester.submit(DONE);
                    return;
                }
                if (this.tester.getDialog().getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                    this.progressBar.validateProgressBarUI(ACKNOWLEDGE);
                    this.tester.submit(ACKNOWLEDGE);
                    return;
                }
                Assert.fail((String)("Page encountered during migration that was not expected - " + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    @Deprecated
    protected void waitForSuccessfulWorkflowSchemeMigration(String projectName, String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                Assert.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                    this.progressBar.validateProgressBarUI(DONE);
                    this.tester.submit(DONE);
                    this.assertions.getSidebarAssertions().assertProjectName(projectName);
                    WorkflowSchemeData scheme = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    Assert.assertEquals((Object)scheme.getName(), (Object)targetWorkflowName);
                    return;
                }
                if (this.tester.getDialog().getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                    this.progressBar.validateProgressBarUI(ACKNOWLEDGE);
                    this.tester.submit(ACKNOWLEDGE);
                    this.assertions.getSidebarAssertions().assertProjectName(projectName);
                    WorkflowSchemeData scheme = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    Assert.assertEquals((Object)scheme.getName(), (Object)targetWorkflowName);
                    return;
                }
                if (this.tester.getDialog().getElement("project-config-header-name") != null) {
                    return;
                }
                Assert.fail((String)("Page encountered during migration that was not expected : PROJECT:" + projectName + " - WORKFLOW SCHEME NAME" + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected void assertIssueVerifierErrorMessages(String projectKey) {
        this.tester.assertTextPresent("There are errors associated with issues that are to be migrated to the new workflow association");
        this.tester.assertTextPresent("Unable to determine the current workflow entry for issue &#39;" + projectKey + "-2&#39;");
        this.tester.assertTextPresent("Unable to determine the current status for issue &#39;" + projectKey + "-3&#39;");
        this.tester.assertTextPresent("Unable to determine the current workflow entry for issue &#39;" + projectKey + "-6&#39;");
        this.tester.assertTextPresent("Unable to determine the current issue type for issue &#39;" + projectKey + "-7&#39;");
        this.tester.assertTextPresent("Unable to determine the current issue type for issue &#39;" + projectKey + "-9&#39;");
        this.tester.assertTextPresent("Unable to determine the current status for issue &#39;" + projectKey + "-11&#39;");
    }

    public List<IssueTypeMapping> mappings() {
        Node[] tableRows;
        Pattern issueTypePattern = Pattern.compile("(.*)\\s(\\d+)");
        Pattern existngWorkflowPattern = Pattern.compile("(.*)");
        Pattern targetWorkflowPattern = Pattern.compile("(.*)");
        Pattern affectedIssuesPattern = Pattern.compile("Affected issues:\\s(\\d+)\\sof\\s(\\d+)");
        IssueTypeMapping mapping = null;
        ArrayList mappings = Lists.newArrayList();
        for (Node tableRow : tableRows = this.locator.css("#workflow-mapping-table tbody tr").getNodes()) {
            Node[] cells = new CssLocator(tableRow, "td").getNodes();
            String text = AbstractTestWorkflowSchemeMigration.getText(cells[0]);
            if (text != null) {
                if (mapping != null) {
                    mappings.add(mapping);
                }
                mapping = new IssueTypeMapping();
                Matcher matcher = issueTypePattern.matcher(text);
                if (!matcher.matches()) {
                    throw new RuntimeException("Issue Type column '" + text + "' did not match.");
                }
                mapping.issueType = matcher.group(1);
                long affectedIssues = Long.parseLong(matcher.group(2));
                text = AbstractTestWorkflowSchemeMigration.getText(cells[1]);
                matcher = existngWorkflowPattern.matcher(text);
                if (!matcher.matches()) {
                    throw new RuntimeException("Existing Workflow column '" + text + "' did not match.");
                }
                mapping.oldWorkflow = matcher.group(1);
                text = AbstractTestWorkflowSchemeMigration.getText(cells[3]);
                matcher = targetWorkflowPattern.matcher(text);
                if (!matcher.matches()) {
                    throw new RuntimeException("Affected Workflow column '" + text + "' did not match.");
                }
                mapping.newWorkflow = matcher.group(1);
                String title = this.getAttribute(new CssLocator(cells[0], ".status-issue-count").getNode(), "title");
                matcher = affectedIssuesPattern.matcher(title);
                if (!matcher.matches()) {
                    throw new RuntimeException("Affected issues title '" + title + "' not as expected.");
                }
                long actualAffectedIssues = Long.parseLong(matcher.group(1));
                if (affectedIssues != actualAffectedIssues) {
                    throw new RuntimeException("Expected affected issues of '" + affectedIssues + "' but got value of '" + actualAffectedIssues + "'.");
                }
                mapping.affectedIssues = actualAffectedIssues;
                mapping.totalIssue = Long.parseLong(matcher.group(2));
                continue;
            }
            StatusMapping statusMapping = new StatusMapping();
            statusMapping.oldStatus = AbstractTestWorkflowSchemeMigration.getText(cells[1]);
            for (Node option : new CssLocator(cells[3], "option").getNodes()) {
                statusMapping.newStatuses.add(AbstractTestWorkflowSchemeMigration.getText(option));
            }
            assert (mapping != null);
            mapping.statusMappings.add(statusMapping);
        }
        if (mapping != null) {
            mappings.add(mapping);
        }
        return mappings;
    }

    private String getAttribute(Node cell, String attributeName) {
        Node title = cell.getAttributes().getNamedItem(attributeName);
        return title != null ? StringUtils.stripToNull((String)title.getNodeValue()) : null;
    }

    private static class StatusMapping {
        private final List<String> newStatuses = Lists.newArrayList();
        private String oldStatus;

        private StatusMapping() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class IssueTypeMapping {
        private final List<StatusMapping> statusMappings = Lists.newArrayList();
        private String issueType;
        private String oldWorkflow;
        private String newWorkflow;
        private long totalIssue;
        private long affectedIssues;

        private IssueTypeMapping() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class IssueAssertions {
        private final List<ChangeLog.HistoryItem> items = Lists.newArrayList();
        private final Set<String> transitions = Sets.newHashSet();
        private String status;

        public IssueAssertions status(String status) {
            this.status = status;
            return this;
        }

        public IssueAssertions addHistoryItems(ChangeLog.HistoryItem ... items) {
            this.items.addAll(Arrays.asList(items));
            return this;
        }

        public IssueAssertions addTransitions(String ... transtions) {
            this.transitions.addAll(Arrays.asList(transtions));
            return this;
        }

        public void assertIssue(Issue issue, boolean exactHistory) {
            this.assertStatus(issue);
            this.assertTransitions(issue);
            if (exactHistory) {
                this.assertExactChangeHistory(issue);
            } else {
                this.assertLastChangeHistory(issue);
            }
        }

        private void assertStatus(Issue issue) {
            Assert.assertEquals((Object)this.status, (Object)issue.fields.status.name());
        }

        private void assertTransitions(Issue issue) {
            HashSet actualTransitions = Sets.newHashSet((Iterable)Iterables.transform((Iterable)issue.transitions, (Function)new Function<IssueTransitionsMeta.Transition, String>(){

                public String apply(IssueTransitionsMeta.Transition input) {
                    return input.name;
                }
            }));
            Assert.assertEquals(this.transitions, (Object)actualTransitions);
        }

        private void assertLastChangeHistory(Issue issue) {
            List histories = issue.changelog.getHistories();
            if (this.items.isEmpty()) {
                Assert.assertTrue((boolean)histories.isEmpty());
            } else {
                Assert.assertFalse((String)"Expected at least one change group.", (boolean)histories.isEmpty());
                this.assertHistory(((ChangeLog.History)histories.get((int)(histories.size() - 1))).items, this.items);
            }
        }

        private void assertExactChangeHistory(Issue issue) {
            List histories = issue.changelog.getHistories();
            if (this.items.isEmpty()) {
                Assert.assertTrue((boolean)histories.isEmpty());
            } else {
                Iterator i = histories.iterator();
                block0: while (i.hasNext()) {
                    ChangeLog.History history = (ChangeLog.History)i.next();
                    for (ChangeLog.HistoryItem item : history.getItems()) {
                        if (!"ProjectImport".equals(item.getField())) continue;
                        i.remove();
                        continue block0;
                    }
                }
                Assert.assertEquals((String)("Expected only 1 history but got " + histories.size()), (long)1L, (long)histories.size());
                this.assertHistory(((ChangeLog.History)histories.get((int)0)).items, this.items);
            }
        }

        private void assertHistory(Collection<ChangeLog.HistoryItem> actualItems, Collection<ChangeLog.HistoryItem> expectedItems) {
            if (!(actualItems = this.simplifyHistory(actualItems)).equals(expectedItems = this.simplifyHistory(expectedItems))) {
                Assert.fail((String)String.format("%s != %s.", expectedItems, actualItems));
            }
        }

        private Set<ChangeLog.HistoryItem> simplifyHistory(Iterable<? extends ChangeLog.HistoryItem> simplify) {
            return Sets.newHashSet((Iterable)Iterables.transform(simplify, (Function)new Function<ChangeLog.HistoryItem, ChangeLog.HistoryItem>(){

                public ChangeLog.HistoryItem apply(ChangeLog.HistoryItem input) {
                    return new ChangeLog.HistoryItem().setField(input.field).setToString(input.toString).setFromString(input.fromString);
                }
            }));
        }
    }
}

